/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.directory.api.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.model.Id;

class ClientDirectoryService<K extends Id>
implements Directory<K> {
    private final Object port;
    private final Method methodGet;
    private final Method methodGetByTitle;
    private final Method methodList;
    private final Object[] methodListArgs;
    private final Method methodUpdate;
    private final Method methodDelete;

    public ClientDirectoryService(Object port, Method methodGet, Method methodGetByTitle, Method methodList, Object[] methodListArgs, Method methodUpdate, Method methodDelete) {
        this.port = port;
        this.methodGet = methodGet;
        this.methodGetByTitle = methodGetByTitle;
        this.methodList = methodList;
        this.methodListArgs = methodListArgs;
        this.methodUpdate = methodUpdate;
        this.methodDelete = methodDelete;
    }

    @Override
    public K get(int id) throws BGException {
        if (this.methodGet == null) {
            throw new UnsupportedOperationException();
        }
        try {
            return (K)((Id)this.methodGet.invoke(this.port, id));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof BGException) {
                throw (BGException)cause;
            }
            throw new BGException(e.getCause());
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    @Override
    public K get(String title) throws BGException {
        if (this.methodGetByTitle == null) {
            throw new UnsupportedOperationException();
        }
        try {
            return (K)((Id)this.methodGetByTitle.invoke(this.port, title));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof BGException) {
                throw (BGException)cause;
            }
            throw new BGException(e.getCause());
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    @Override
    public List<K> list() throws BGException {
        if (this.methodList == null) {
            throw new UnsupportedOperationException();
        }
        try {
            return (List)this.methodList.invoke(this.port, this.methodListArgs);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof BGException) {
                throw (BGException)cause;
            }
            throw new BGException(e.getCause());
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    @Override
    public void update(K k) throws BGException {
        if (this.methodUpdate == null) {
            throw new UnsupportedOperationException();
        }
        try {
            int id = (Integer)this.methodUpdate.invoke(this.port, k);
            ((Id)k).setId(id);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof BGException) {
                throw (BGException)cause;
            }
            throw new BGException(e.getCause());
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    @Override
    public int delete(int id) throws BGException {
        if (this.methodDelete == null) {
            throw new UnsupportedOperationException();
        }
        try {
            Object result = this.methodDelete.invoke(this.port, id);
            if (result instanceof Integer) {
                return (Integer)result;
            }
            return 0;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof BGException) {
                throw (BGException)cause;
            }
            throw new BGException(e.getCause());
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }
}

