/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;

public class CatalogTariffTreeNode
extends DefaultTariffTreeNode {
    private JPanel propsPanel = new JPanel();
    private JTextField textField;
    private String folderTitle;
    protected JLabel view = new JLabel();

    public CatalogTariffTreeNode() {
        this.view.setIcon(ClientUtils.getIcon("folder.png"));
        this.textField = new JTextField(40);
        this.propsPanel.add(this.textField);
    }

    @Override
    protected JPanel getEditorPanel() {
        return this.propsPanel;
    }

    @Override
    public Component getView() {
        this.updateView();
        return this.view;
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>(2);
        data.put("folder", this.textField.getText());
        this.setDataInHash(data);
        this.updateView();
    }

    @Override
    protected void loadData() {
        Map<String, String> data = this.getDataInHash();
        String folderTitle = data.get("folder");
        if (folderTitle == null) {
            folderTitle = "";
        }
        this.textField.setText(folderTitle);
    }

    @Override
    public int compareTo(Object o) {
        int result = -1;
        if (o instanceof CatalogTariffTreeNode) {
            String catName = ((CatalogTariffTreeNode)o).getData();
            result = this.getData().compareTo(catName);
        }
        return result;
    }

    public String getName() {
        return this.getData();
    }

    @Override
    public void serializeToXML(Element el) throws Exception {
        el.setAttribute("title", this.getName());
        this.serializeChildsToXML(el);
    }

    @Override
    public void loadFromXML(Element el) throws Exception {
        String title = el.getAttribute("title");
        this.setData(title);
        this.saveData();
        this.loadChildsFromXML(el);
    }

    private void updateView() {
        this.extractData();
        this.view.setText("\u041a\u0430\u0442\u0430\u043b\u043e\u0433: " + this.folderTitle);
    }

    private void extractData() {
        Map<String, String> data = this.getDataInHash();
        this.folderTitle = data.get("folder");
        if (this.folderTitle == null) {
            this.folderTitle = "";
        }
    }
}

