/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.worker;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContextThreadFactory;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.concurrent.ConcurrentUtils;
import ru.bitel.common.worker.WorkerThreadFactory;

public abstract class PeriodicalTaskRunner<T extends Runnable>
extends BGLogger
implements Runnable {
    protected final Setup setup;
    ScheduledExecutorService service;
    private final int threadCount;
    private final long initialDelay;
    private final long delay;
    private final int moduleId;
    private final String threadName;

    public PeriodicalTaskRunner(Setup setup, int threadCount, long initialDelay, long delay, int moduleId, String threadName) {
        this.setup = setup;
        this.threadCount = threadCount;
        this.initialDelay = initialDelay;
        this.delay = delay;
        this.moduleId = moduleId;
        this.threadName = threadName;
    }

    public void start() {
        ServerContextThreadFactory threadContextFactory = new ServerContextThreadFactory(this.setup, this.moduleId, this.threadName, null);
        this.service = Executors.newScheduledThreadPool(1, new WorkerThreadFactory(this.threadName, null, threadContextFactory));
        this.service.scheduleWithFixedDelay(this, this.initialDelay, this.delay, TimeUnit.SECONDS);
    }

    protected abstract List<T> readTasks() throws BGException;

    @Override
    public void run() {
        try {
            List<T> tasks = this.readTasks();
            ConcurrentUtils.invokeAll(tasks, this.threadCount);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public void shutdown() throws InterruptedException {
        this.service.shutdown();
        this.service.awaitTermination(10000000L, TimeUnit.SECONDS);
    }
}

