/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.client;

import bitel.billing.module.common.BGSelectFilePanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.loader.common.service.LoaderService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public abstract class UtilPanel
extends BGUPanel {
    private LoaderService loaderService = null;
    private ContractParameterService contractParameterService = null;
    private List<ContractParameterGroupAttr> contractParameterList = null;
    protected JTextArea importResult = new JTextArea();

    protected LoaderService getLoaderService() {
        if (this.loaderService == null) {
            this.loaderService = ((ClientContext)this.getContext()).getPort(LoaderService.class);
        }
        return this.loaderService;
    }

    protected ContractParameterService getContractParameterService() {
        if (this.contractParameterService == null) {
            this.contractParameterService = ((ClientContext)this.getContext()).getPort(ContractParameterService.class);
        }
        return this.contractParameterService;
    }

    protected List<ContractParameterGroupAttr> getContractParameterList(int[] types) {
        if (this.contractParameterList == null) {
            this.contractParameterList = new ArrayList<ContractParameterGroupAttr>();
            try {
                ArrayList<Integer> typeIds = new ArrayList<Integer>();
                int count = types.length;
                for (int i = 0; i < count; ++i) {
                    typeIds.add(types[i]);
                }
                for (ContractParameterGroupAttr attr : this.getContractParameterService().contractParameterGroupAttrList()) {
                    if (types.length != 0 && !typeIds.contains(attr.getType())) continue;
                    this.contractParameterList.add(attr);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
        return this.contractParameterList;
    }

    protected byte[] getDataFromFile(File file) {
        byte[] bytes = null;
        try {
            bytes = Utils.readByBlock(new FileInputStream(file));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        return bytes;
    }

    protected PanelContractParameter getContractParameterPanel(String title, int[] types) {
        PanelContractParameter panel = new PanelContractParameter(title);
        panel.getList().setData(this.getContractParameterList(types).stream().map(a -> a.toIdTitle()).toList());
        return panel;
    }

    protected PanelContractParameters getPanelContractParameters(int[] types) {
        PanelContractParameters panel = new PanelContractParameters();
        panel.model.setData(this.getContractParameterList(types));
        return panel;
    }

    protected JPanel getTextPanel(String title, BGTextField textField) {
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(title), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        panel.add((Component)textField, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 2, 5), 0, 0));
        return panel;
    }

    protected JPanel getHelpPanel(String title, String text) {
        JTextArea help = new JTextArea(5, 5);
        help.setMargin(new Insets(3, 3, 3, 3));
        help.setLineWrap(true);
        help.setWrapStyleWord(true);
        help.setText(text);
        help.setEditable(false);
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(title), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        panel.add((Component)new JScrollPane(help), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 2, 5), 0, 0));
        return panel;
    }

    protected JPanel getButtonPanel() {
        BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
        okCancelPanel.addActionListener(actionEvent -> {
            if (actionEvent.getActionCommand().equals("ok")) {
                this.doUtil();
            } else {
                this.doClearForm();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)okCancelPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    protected JPanel getFilePanel(AtomicReference<String> atomicReference) {
        BGSelectFilePanel selectFilePanel = new BGSelectFilePanel();
        selectFilePanel.setDialogTitle("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430");
        selectFilePanel.setShowPath(true);
        selectFilePanel.setFileFieldBackground(new JTextField().getBackground());
        selectFilePanel.setFileFilter("csv", "Text CSV");
        selectFilePanel.addPropertyChangeListener(e -> {
            Path path;
            File file;
            if ("fileSelected".equals(e.getPropertyName()) && (file = selectFilePanel.getSelectedFile()) != null && Files.exists(path = file.toPath(), new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
                try {
                    atomicReference.set(Files.readString(path));
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder("\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430"));
        panel.add((Component)selectFilePanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    protected JPanel getInfoPanel(JTextArea info) {
        return this.getInfoPanel(info, null);
    }

    protected JPanel getInfoPanel(JTextArea info, String title) {
        info.setMargin(new Insets(3, 3, 3, 3));
        info.setWrapStyleWord(true);
        info.setLineWrap(true);
        info.setEditable(false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(title != null ? title : "\u0424\u043e\u0440\u043c\u0430\u0442 \u0437\u0430\u043f\u0438\u0441\u0435\u0439:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane(info), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
        return panel;
    }

    protected JPanel getDataPanel(final AtomicReference<String> atomicReference) {
        final JTextArea textData = new JTextArea(10, 50);
        textData.setMargin(new Insets(3, 3, 3, 3));
        textData.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                atomicReference.set(textData.getText());
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0414\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430 (\u043c\u043e\u0436\u043d\u043e \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c):"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JScrollPane(textData), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    protected JPanel getImportResultPanel() {
        this.importResult.setMargin(new Insets(3, 3, 3, 3));
        this.importResult.setEditable(false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u0438\u043c\u043f\u043e\u0440\u0442\u0430:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane(this.importResult), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
        return panel;
    }

    protected void doUtil() {
    }

    protected void doClearForm() {
    }

    public class PanelContractParameter
    extends JPanel {
        BGUList<IdTitle> list;

        public PanelContractParameter() {
            this(null);
        }

        public PanelContractParameter(String title) {
            super(new GridBagLayout());
            this.list = new BGUList();
            this.list.setSelectionMode(0);
            int gridy = 0;
            this.add((Component)new JLabel(title == null ? "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430:" : title), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 2, 5), 0, 0));
            this.add((Component)new JScrollPane(this.list), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 2, 5), 0, 0));
        }

        public BGUList<IdTitle> getList() {
            return this.list;
        }
    }

    public class PanelContractParameters
    extends JPanel {
        ContractParameterTableModel model;
        BGUTable table;

        public PanelContractParameters() {
            super(new GridBagLayout());
            this.model = new ContractParameterTableModel(ContractParameterTableModel.class.getName());
            this.table = new BGUTable(this.model);
            int gridy = 0;
            this.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430:"), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
            this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 2, 5), 0, 0));
        }
    }

    public class ContractParameterTableModel
    extends BGTableModel<ContractParameterGroupAttr> {
        public ContractParameterTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", -1, -1, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class PanelTitleLabel
    extends JLabel {
        public PanelTitleLabel(String text) {
            super(text);
            this.setFont(new Font("Dialog", 1, 15));
        }
    }
}

