/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGToolBar;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectType;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternBaseTabPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class ContractPatternObjectsTabPanel
extends PatternBaseTabPanel {
    private static final String OBJECTS_NODE = "objects";
    private ContractObjectPatternTable objectTableModel = new ContractObjectPatternTable();
    private List<ObjectType> objectTypes = null;
    private List<ContractPatternObjectItem> contractPatternObjectItems = new ArrayList<ContractPatternObjectItem>();

    public ContractPatternObjectsTabPanel(Document moduleDoc) {
    }

    @Override
    protected void jbInit() throws Exception {
        BGToolBar toolBar = new BGToolBar(true, true);
        toolBar.add(this.getActionMap().get("item.add"));
        toolBar.add(this.getActionMap().get("item.edit"));
        toolBar.add(this.getActionMap().get("item.delete"));
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)toolBar, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        topPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        BGUTable table = new BGUTable(this.objectTableModel);
        table.setSelectionMode(0);
        this.setLayout(new GridBagLayout());
        this.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.handleEdit((JTable)table, this, "item.edit");
    }

    private List<ObjectType> getObjectTypes() {
        if (this.objectTypes == null) {
            try {
                this.objectTypes = this.getContext().getWebService(ContractObjectService.class, 0).objectTypeList(false);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
        return this.objectTypes;
    }

    @Override
    public void setPatternData(Element pattern) throws Exception {
        ArrayList<ContractPatternObjectItem> items = new ArrayList<ContractPatternObjectItem>();
        Element objects = XMLUtils.selectElement(pattern, "//objects");
        if (objects != null) {
            NodeList objectNodes = objects.getElementsByTagName("object");
            for (int i = 0; i < objectNodes.getLength(); ++i) {
                Element child = (Element)objectNodes.item(i);
                items.add(new ContractPatternObjectItem(Utils.parseInt(child.getAttribute("type")), Utils.parseInt(child.getAttribute("amount"))));
            }
        }
        this.contractPatternObjectItems = items;
    }

    @Override
    public void resetData() {
        this.objectTableModel.deleteRows();
        this.objectTypes = null;
    }

    @Override
    public boolean setRequestData(Request request) {
        request.setAttribute(OBJECTS_NODE, this.contractPatternObjectItems.stream().map(a -> a.getTypeId() + ":" + a.getAmount()).collect(Collectors.joining(",")));
        return true;
    }

    @Override
    public void initUI() {
        this.performAction("refresh");
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            this.objectTypes = this.getObjectTypes();
            this.objectTableModel.setData(this.contractPatternObjectItems);
        });
        new AbstractBGUPanel.BGActionItemAdd(e -> new ContractPatternObjectEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432", new ContractPatternObjectItem(0, 0)).open());
        new AbstractBGUPanel.BGActionItemEdit(e -> this.objectTableModel.optSelectedRow().ifPresentOrElse(item -> new ContractPatternObjectEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432", (ContractPatternObjectItem)item).open(), () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u043f\u0438\u0441\u0442\u044c \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435")));
        new AbstractBGUPanel.BGActionItemDelete(e -> this.objectTableModel.optSelectedRow().ifPresentOrElse(item -> {
            if (ClientUtils.confirmDelete("\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0442\u0430\u0431\u043b\u0438\u0446\u044b")) {
                this.contractPatternObjectItems.remove(item);
                this.objectTableModel.setData(this.contractPatternObjectItems);
            }
        }, () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!")));
    }

    class ContractObjectPatternTable
    extends BGTableModel<ContractPatternObjectItem> {
        public ContractObjectPatternTable() {
            super(ContractObjectPatternTable.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0422\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430", 200, 500, -1, "typeId", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", 200, 200, 200, "amount", false, DecimalTableCellRenderer.INTEGER());
        }

        @Override
        public Object getValue(ContractPatternObjectItem val, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("typeId".equals(identifier)) {
                return ContractPatternObjectsTabPanel.this.objectTypes.stream().filter(a -> a.getId() == val.getTypeId()).findFirst().map(a -> a.getGuiTitle()).orElse("???") + " [ID#" + val.getTypeId() + "]";
            }
            return super.getValue(val, column);
        }
    }

    public class ContractPatternObjectItem {
        private int typeId = 0;
        private int amount = 0;

        public ContractPatternObjectItem(int typeId, int amount) {
            this.typeId = typeId;
            this.amount = amount;
        }

        public int getTypeId() {
            return this.typeId;
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            this.amount = amount;
        }
    }

    public class ContractPatternObjectEditor
    extends BGEditorDialog<ContractPatternObjectItem> {
        private BGUComboBox<IdTitle> objectsCB;
        private IntTextField amountTF;

        public ContractPatternObjectEditor(String title, ContractPatternObjectItem data) {
            super(title, data);
            this.objectsCB = new BGUComboBox();
            this.amountTF = new IntTextField(30);
        }

        @Override
        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u0422\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add(this.objectsCB, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.amountTF, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            ArrayList list = new ArrayList();
            list.addAll(ContractPatternObjectsTabPanel.this.getObjectTypes().stream().toList());
            list.add(0, new IdTitle(0, "===== \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d ====="));
            this.objectsCB.setData(list);
            this.objectsCB.setSelectedItem(this.objectsCB.getData().stream().filter(a -> a.getId() == ((ContractPatternObjectItem)this.data).getTypeId()).findFirst().orElse(this.objectsCB.getData().get(0)));
            this.amountTF.setText(String.valueOf(((ContractPatternObjectItem)this.data).getAmount()));
        }

        @Override
        public boolean doApply() throws Exception {
            IdTitle idTitle = (IdTitle)this.objectsCB.getSelectedItem();
            if (idTitle == null || idTitle.getId() == 0) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430");
                return false;
            }
            int amount = Utils.parseInt(this.amountTF.getText());
            if (amount <= 0) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f!");
                return false;
            }
            IdTitle type = (IdTitle)this.objectsCB.getSelectedItem();
            ContractPatternObjectsTabPanel.this.contractPatternObjectItems.stream().filter(a -> a.getTypeId() == type.getId()).findFirst().ifPresentOrElse(a -> a.setAmount(amount), () -> ContractPatternObjectsTabPanel.this.contractPatternObjectItems.add(new ContractPatternObjectItem(type.getId(), amount)));
            ContractPatternObjectItem item = (ContractPatternObjectItem)ContractPatternObjectsTabPanel.this.objectTableModel.getSelectedRow();
            ContractPatternObjectsTabPanel.this.objectTableModel.setData(ContractPatternObjectsTabPanel.this.contractPatternObjectItems);
            ContractPatternObjectsTabPanel.this.objectTableModel.fireTableDataChanged();
            ContractPatternObjectsTabPanel.this.objectTableModel.setSelectedRow(item);
            return true;
        }
    }
}

