/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.resource.action;

import bitel.billing.server.admin.resource.action.base.ActionBase;
import bitel.billing.server.admin.resource.bean.ip.IPResourceRange;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.modules.ipn.server.bean.IPNResourceManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionIPResourceTable
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        long ip2;
        long ip1;
        boolean maskMode;
        int categoryId = this.getIntParameter("category_id", -1);
        Calendar onDate = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("on_date"));
        String status = this.getParameter("status");
        String fromNumber = this.getParameter("range1");
        String toNumber = this.getParameter("range2");
        String net = this.getParameter("net");
        String mask = this.getParameter("mask");
        boolean bl = maskMode = net != null;
        if (maskMode) {
            ip1 = Utils.parseLong((String)net, (long)0L);
            ip2 = Utils.parseLong((String)mask, (long)0L);
        } else {
            ip1 = Utils.parseLong((String)fromNumber, (long)0L);
            ip2 = Utils.parseLong((String)toNumber, (long)0L);
        }
        if (categoryId < 0 || this.mid <= 0 || Utils.isBlankString((String)status)) {
            throw new BGIllegalArgumentException();
        }
        IPNResourceManager resourceManager = new IPNResourceManager(this.con, this.mid);
        Iterable resourceList = null;
        resourceList = status.equals("free") ? resourceManager.getFreeResourceIterator(categoryId, onDate) : (status.equals("busy") ? resourceManager.getBusyResourceIterator(categoryId, onDate, ip1, ip2, maskMode) : resourceManager.getResourceIterator(categoryId, ip1, ip2, maskMode));
        try {
            this.request.setAttribute("contentType", (Object)"binary");
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter w = factory.createXMLStreamWriter((OutputStream)this.response.getOutputStream(), "UTF-8");
            w.writeStartDocument("UTF-8", "1.0");
            w.writeStartElement("data");
            w.writeAttribute("status", "ok");
            w.writeStartElement("table");
            w.writeStartElement("data");
            for (IPResourceRange resource : resourceList) {
                w.writeStartElement("row");
                w.writeAttribute("id", String.valueOf(resource.getId()));
                w.writeAttribute("period", TimeUtils.formatPeriod((Date)resource.getDateFrom(), (Date)resource.getDateTo()));
                w.writeAttribute("ip1", IPUtils.convertLongIpToString((long)resource.getIp1()));
                w.writeAttribute("ip2", IPUtils.convertLongIpToString((long)resource.getIp2()));
                w.writeAttribute("item_id", String.valueOf(resource.getItemId()));
                w.writeEndElement();
            }
            w.writeEndElement();
            w.writeEndElement();
            w.writeEndElement();
            w.writeEndDocument();
            w.flush();
        }
        catch (XMLStreamException e) {
            if (!(e.getCause() instanceof IOException)) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

