/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.ActionConType;
import bitel.billing.server.contract.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.LocalDate;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;

@ActionConType(value=2)
public class ActionFindContractByPhone
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        String parameters = this.getParameter("parameters");
        Element contracts = this.createElement(this.rootNode, "contracts");
        if (parameters == null || parameters.trim().length() == 0) {
            throw new BGIllegalArgumentException();
        }
        Object phone = this.getParameter("phone");
        if (phone != null && ((String)phone).length() == 0) {
            phone = null;
        }
        String phoneSearchPrefix = this.setup.get("phone.search.prefix", "7");
        phone = phoneSearchPrefix + this.getParameter("phone", "");
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT DISTINCT contract.id, contract.title, contract.comment, contract.gr ");
        sb.append("FROM contract LEFT JOIN ");
        sb.append("contract_parameter_type_phone_item");
        sb.append(" AS t2 ON contract.id=t2.cid WHERE t2.pid in ( ");
        sb.append(parameters);
        sb.append(")");
        if (phone != null) {
            sb.append(" AND t2.phone=?");
        }
        int index = 1;
        PreparedStatement ps = this.con.prepareStatement(sb.toString());
        if (phone != null) {
            ps.setString(index++, (String)phone);
        }
        LocalDate now = LocalDate.now();
        BalanceUtils bu = new BalanceUtils(this.con);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int contractId = rs.getInt(1);
            Element element = this.createElement(contracts, "item");
            element.setAttribute("id", String.valueOf(contractId));
            element.setAttribute("title", rs.getString(2));
            element.setAttribute("comment", rs.getString(3));
            element.setAttribute("group", String.valueOf(rs.getLong(4)));
            element.setAttribute("balance", String.valueOf(bu.getBalance(now, contractId)));
        }
        rs.close();
        ps.close();
        bu.close();
    }
}

