/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.load.action;

import bitel.billing.server.load.action.base.ActionBase;
import bitel.billing.server.load.bean.Source;
import bitel.billing.server.load.bean.SourceManager;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public class ActionSourceManagerInfo
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        int source_id = this.getIntParameter("source_id", -1);
        int month = this.getIntParameter("month", -1);
        int year = this.getIntParameter("year", -1);
        if (this.mid == -1 || month == -1 || year == -1) {
            return;
        }
        GregorianCalendar date1 = new GregorianCalendar(year, month - 1, 1);
        Calendar date2 = (Calendar)((Calendar)date1).clone();
        date2.add(2, 1);
        SourceManager sm = new SourceManager(this.con);
        if (source_id == -1) {
            List<Source> listSource = sm.getSourceList(this.mid, date1.getTime(), date2.getTime());
            Element listElement = this.createElement(this.rootNode, "list");
            for (Source source : listSource) {
                Element element = this.createElement(listElement, "item");
                element.setAttribute("id", String.valueOf(source.getId()));
                element.setAttribute("title", source.getTitle());
                element.setAttribute("sourceType", String.valueOf(source.getType()));
                if (new Preferences(source.getConfig(), "\r\n").getInt("use.load", 0) <= 0) continue;
                element.setAttribute("use.load", "1");
            }
        } else {
            Integer day;
            PreparedStatement ps;
            Object query;
            Element info = this.createElement(this.rootNode, "info");
            Source source = sm.getSource(source_id);
            if (new Preferences(source.getConfig(), "\r\n").getInt("use.load", 0) > 0) {
                info.setAttribute("use.load", "1");
            }
            Hashtable<Integer, Integer> daysLoad = new Hashtable<Integer, Integer>(31);
            Hashtable<Integer, Integer> daysProcess = new Hashtable<Integer, Integer>(31);
            Hashtable<Integer, Integer> daysLabel = new Hashtable<Integer, Integer>(31);
            Hashtable<Integer, Integer> daysZero = new Hashtable<Integer, Integer>(31);
            Integer zero = 0;
            for (int i = 1; i <= 31; ++i) {
                Integer day2 = i;
                daysLoad.put(day2, zero);
                daysProcess.put(day2, zero);
                daysLabel.put(day2, zero);
                daysZero.put(day2, zero);
            }
            String tableName = "source_data_" + TimeUtils.format((Calendar)date1, (String)"yyyyMM");
            if (ServerUtils.tableExists(this.con, tableName)) {
                query = "SELECT dayofmonth( dt ), hour( dt ), process, modtime, size FROM " + tableName + " WHERE source_id=?";
                ps = this.con.prepareStatement((String)query);
                ps.setInt(1, source_id);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    Integer value = null;
                    day = rs.getInt(1);
                    int hh = rs.getInt(2);
                    if (rs.getLong("modtime") > 0L) {
                        value = (Integer)daysLoad.get(day);
                        if (value != null) {
                            value = value | 1 << hh;
                            daysLoad.put(day, value);
                        }
                        if (rs.getLong("size") < 150L && (rs.getInt("process") & 2) == 0 && (value = (Integer)daysZero.get(day)) != null) {
                            value = value | 1 << hh;
                            daysZero.put(day, value);
                        }
                    }
                    if ((rs.getInt("process") & 1) > 0 && (value = (Integer)daysProcess.get(day)) != null) {
                        value = value | 1 << hh;
                        daysProcess.put(day, value);
                    }
                    if ((rs.getInt("process") & 2) <= 0 || (value = (Integer)daysLabel.get(day)) == null) continue;
                    value = value | 1 << hh;
                    daysLabel.put(day, value);
                }
                rs.close();
            }
            Hashtable<Integer, Integer> daysInProcess = new Hashtable<Integer, Integer>(31);
            for (int i = 1; i <= 31; ++i) {
                daysInProcess.put(i, zero);
            }
            query = "SELECT dayofmonth( dt ), hour( dt ) FROM task_proccess WHERE mid=? AND ( param=0 OR param=? ) AND dt>=? AND dt<?";
            ps = this.con.prepareStatement((String)query);
            ps.setInt(1, this.mid);
            ps.setInt(2, source_id);
            ps.setDate(3, new Date(date1.getTime().getTime()));
            ps.setDate(4, new Date(date2.getTime().getTime()));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                day = rs.getInt(1);
                Integer value = (Integer)daysInProcess.get(day);
                if (value == null) continue;
                value = value | (int)Math.pow(2.0, rs.getInt(2));
                daysInProcess.put(day, value);
            }
            rs.close();
            Hashtable<Integer, Integer> daysInLoad = new Hashtable<Integer, Integer>(31);
            for (int i = 1; i <= 31; ++i) {
                daysInLoad.put(i, zero);
            }
            query = "SELECT dayofmonth( dt ), hour( dt ) FROM task_load AS t1, source AS t2 WHERE t1.param=t2.id AND t2.mid=? AND param=? AND dt>=? AND dt<?";
            ps = this.con.prepareStatement((String)query);
            ps.setInt(1, this.mid);
            ps.setInt(2, source_id);
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)date1));
            ps.setDate(4, TimeUtils.convertCalendarToSqlDate((Calendar)date2));
            rs = ps.executeQuery();
            while (rs.next()) {
                Integer day3 = rs.getInt(1);
                Integer value = 0;
                if (daysInLoad.containsKey(day3)) {
                    value = (Integer)daysInLoad.get(day3);
                }
                value = value | (int)Math.pow(2.0, rs.getInt(2));
                daysInLoad.put(day3, value);
            }
            rs.close();
            for (int i = 1; i <= 31; ++i) {
                Integer day4 = i;
                Element element = this.createElement(info, "day");
                element.setAttribute("id", day4.toString());
                element.setAttribute("v1", ((Integer)daysLoad.get(day4)).toString());
                element.setAttribute("v2", ((Integer)daysProcess.get(day4)).toString());
                element.setAttribute("v3", ((Integer)daysInProcess.get(day4)).toString());
                element.setAttribute("v4", ((Integer)daysInLoad.get(day4)).toString());
                element.setAttribute("v5", ((Integer)daysLabel.get(day4)).toString());
                element.setAttribute("v6", ((Integer)daysZero.get(day4)).toString());
            }
        }
    }
}

