/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.util;

public class ConsoleTable {
    int[] widths = null;
    String[] columns = null;
    private StringBuffer table = new StringBuffer();

    public ConsoleTable(String[] columns, int[] widths) {
        this.widths = widths;
        this.columns = columns;
        this.addHeader();
    }

    private void addHeader() {
        this.addDevider();
        for (int i = 0; i < this.columns.length; ++i) {
            this.addCell(this.columns[i], i, true);
        }
        this.addDevider();
    }

    private void addDevider() {
        this.table.append("+");
        for (int i = 0; i < this.widths.length; ++i) {
            for (int k = 0; k < this.widths[i]; ++k) {
                this.table.append("-");
            }
            this.table.append("+");
        }
        this.table.append("\n");
    }

    private void addCell(String str, int pos, boolean center) {
        if (str == null) {
            str = "NULL";
        }
        if (pos < this.widths.length) {
            int i;
            int offsRight;
            int cellWidth = this.widths[pos];
            int offsLeft = 2;
            if (center && (offsLeft = (cellWidth - str.length()) / 2) < 0) {
                offsLeft = 0;
            }
            if ((offsRight = cellWidth - str.length() - offsLeft) < 0) {
                offsRight = 0;
            }
            this.table.append("|");
            for (i = 0; i < offsLeft; ++i) {
                this.table.append(" ");
            }
            this.table.append(str);
            for (i = 0; i < offsRight; ++i) {
                this.table.append(" ");
            }
            if (pos == this.widths.length - 1) {
                this.table.append("|\n");
            }
        }
    }

    public void addRow(String[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.addCell(values[i], i, true);
        }
    }

    public String toString() {
        this.addDevider();
        return this.table.toString();
    }
}

