/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.option.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOption;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TariffOptionDao
extends AbstractIdDao<TariffOption> {
    public TariffOptionDao(Connection con) {
        super(con, 0, "tariff_option");
    }

    public List<TariffOption> list(List<Integer> optionIds) throws SQLException {
        return optionIds != null && !optionIds.isEmpty() ? this.list("id IN ( " + Utils.toString(optionIds) + " )", "title", new Object[0]) : Collections.emptyList();
    }

    public List<TariffOption> list(Date date) throws SQLException {
        java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate(date);
        return this.list("(date1 IS NULL OR date1<=?) AND (date2 IS NULL OR ?<=date2)", "title", sqlDate, sqlDate);
    }

    @Override
    protected TariffOption getFromRS(ResultSet rs) throws SQLException {
        return TariffOption.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setTariffIdSet(Utils.toIntegerSet(rs.getString("tariff_ids"))).setContractLabels(Utils.toIntegerSet(rs.getString("contract_labels"))).setComment(rs.getString("comment")).setDescription(rs.getString("description")).setConfig(rs.getString("config")).setDateFrom(rs.getDate("date1")).setDateTo(rs.getDate("date2")).setDepends(Utils.toIntegerSet(rs.getString("depends"))).setIncompatible(Utils.toIntegerSet(rs.getString("incompatible"))).setHideForWeb(rs.getBoolean("hideForWeb")).setHideForContractLabels(Utils.toIntegerSet(rs.getString("hide_for_web_contract_labels"))).setHideForContractGroupsMode(rs.getInt("hideForWebContractGroupsMode")).build();
    }

    @Override
    protected void updateImpl(TariffOption option) throws SQLException {
        String querySet = "title=?, tariff_ids=?, contract_labels=?, comment=?, description=?, config=?, date1=?, date2=?, depends=?, incompatible=?, hideForWeb=?, hide_for_web_contract_labels=?, hideForWebContractGroupsMode=?";
        try (PreparedStatement ps = this.prepareStatement(option, querySet);){
            int index = 1;
            ps.setString(index++, option.getTitle());
            ps.setString(index++, Utils.toString(option.getTariffIdSet()));
            ps.setString(index++, Utils.toString(option.getContractLabels()));
            ps.setString(index++, option.getComment());
            ps.setString(index++, option.getDescription());
            ps.setString(index++, option.getConfig());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(option.getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(option.getDateTo()));
            ps.setString(index++, Utils.toString(option.getDepends()));
            ps.setString(index++, Utils.toString(option.getIncompatible()));
            ps.setBoolean(index++, option.isHideForWeb());
            ps.setString(index++, Utils.toString(option.getHideForContractLabels()));
            ps.setInt(index++, option.getHideForContractGroupsMode());
            this.executeUpdate(option, index, ps);
        }
    }
}

