/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client.treetable;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import ru.bitel.common.client.table.BasicBGTableModel;
import ru.bitel.common.client.treetable.AbstractBGUTreeTable;
import ru.bitel.common.model.TreeNode;

public abstract class DefaultBGTreeTableModel<N>
extends BasicBGTableModel<N>
implements TreeModel {
    protected EventListenerList listenerList = new EventListenerList();
    protected N root;

    public DefaultBGTreeTableModel(String name) {
        super(name);
    }

    public DefaultBGTreeTableModel(String name, Class<N> clazz) {
        super(name, clazz);
    }

    protected JTree getTree() {
        AbstractBGUTreeTable table = (AbstractBGUTreeTable)this.table;
        if (table == null) {
            return null;
        }
        return table.tree;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    @Override
    public int getChildCount(Object parent) {
        List children = parent != null ? ((TreeNode)parent).getChildren() : null;
        return children != null ? children.size() : 0;
    }

    public N getChild(Object parent, int index) {
        List<N> children = this.getChildren(parent);
        return children != null ? (N)children.get(index) : null;
    }

    protected abstract List<? extends N> getChildren(Object var1);

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        List children = ((TreeNode)parent).getChildren();
        if (children != null) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                if (!children.get(i).equals(child)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean isLeaf(Object node) {
        List children = ((TreeNode)node).getChildren();
        return children == null || children.size() == 0;
    }

    public N getRoot() {
        return this.root;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public N nodeForRow(int row) {
        if (row == 0) {
            return this.root;
        }
        TreePath treePath = this.getTree().getPathForRow(row);
        return (N)(treePath != null ? treePath.getLastPathComponent() : null);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            return this.getValue(this.nodeForRow(rowIndex), columnIndex);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.setValue(this.nodeForRow(rowIndex), columnIndex, value);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return TreeNode.class.isAssignableFrom(this.getColumnClass(columnIndex)) && rowIndex > 0;
    }

    @Override
    public int getRowCount() {
        JTree tree = this.getTree();
        return tree != null ? tree.getRowCount() : 0;
    }

    @Override
    public N getSelectedRow() {
        TreePath treePath = this.getTree().getSelectionPath();
        return (N)(treePath != null ? treePath.getLastPathComponent() : null);
    }

    @Override
    public List<N> getSelectedRows() {
        ArrayList<Object> result = new ArrayList<Object>();
        TreePath[] treePaths = this.getTree().getSelectionPaths();
        if (treePaths != null) {
            int size = treePaths.length;
            for (int i = 0; i < size; ++i) {
                result.add(treePaths[i].getLastPathComponent());
            }
        }
        return result;
    }

    public Optional<List<N>> optSelectedRows() {
        return Optional.ofNullable(this.getSelectedRows());
    }

    public Icon getIcon(N value) {
        return null;
    }

    public void setData(N root) {
        this.root = root;
        this.fireTreeStructureChanged(this, new Object[]{root}, null, null);
        this.fireTableStructureChanged();
    }
}

