/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.fakesql.FakeConnection;
import ru.bitel.common.sql.SetupConnectionSet;
import ru.bitel.common.worker.Commitable;

public abstract class ConnectionSet
extends BGLogger
implements Commitable,
AutoCloseable {
    public static final int TYPE_MASTER = 1;
    public static final int TYPE_SLAVE = 2;
    public static final int TYPE_TRASH = 3;
    public static final int TYPE_FAKE = 4;
    private static final int traceFreq = ConnectionSet.getIntProperty("connectionSet.trace", 150);
    private static final AtomicLong traceFlag = new AtomicLong(0L);
    protected boolean autoCommit;
    private final boolean internalMaster;
    private Connection masterConnection;
    private Connection slaveConnection;
    private Map<String, TrashConnectionHolder> trashConnections;
    private volatile boolean recycled = false;
    private StackTraceElement[] stackTrace;

    private static int getIntProperty(String prop, int defaultVal) {
        String val = System.getProperty(prop);
        if (val == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public ConnectionSet(Connection master, boolean autoCommit) {
        this.masterConnection = master;
        this.internalMaster = master == null;
        this.autoCommit = autoCommit;
        assert (ConnectionSet.check(master, autoCommit));
        if (traceFreq > 0) {
            if (traceFreq == 1) {
                this.stackTrace = new Throwable().getStackTrace();
            } else if (traceFlag.incrementAndGet() == (long)traceFreq) {
                this.stackTrace = new Throwable().getStackTrace();
                traceFlag.set(0L);
            }
        }
    }

    private static boolean check(Connection master, boolean autoCommit) {
        try {
            return master == null || master.getAutoCommit() == autoCommit;
        }
        catch (SQLException ex) {
            BGLogger.error((Throwable)ex);
            return false;
        }
    }

    public Connection getConnection() {
        if (this.masterConnection == null) {
            this.recycled = false;
            this.masterConnection = this.newMasterConnection();
        }
        return this.masterConnection;
    }

    protected abstract Connection newMasterConnection();

    protected abstract Connection newSlaveConnection();

    protected abstract Connection newTrashConnection(String var1);

    public Connection getSlaveConnection() {
        if (this.slaveConnection == null) {
            this.recycled = false;
            this.slaveConnection = this.newSlaveConnection();
            if (this.slaveConnection == null) {
                this.slaveConnection = this.getConnection();
            }
        }
        return this.slaveConnection;
    }

    public Connection getTrashConnection(String tableName, int defaultType) {
        Connection connection;
        TrashConnectionHolder holder;
        if (this.trashConnections == null) {
            this.trashConnections = new HashMap<String, TrashConnectionHolder>();
        }
        if ((holder = this.trashConnections.get(tableName)) == null) {
            holder = new TrashConnectionHolder();
            this.trashConnections.put(tableName, holder);
        }
        if ((connection = holder.connections[0]) == null) {
            this.recycled = false;
            if (!holder.inited) {
                holder.inited = true;
                holder.connections[0] = connection = this.newTrashConnection(tableName);
            }
            if (connection == null && (connection = holder.connections[defaultType]) == null) {
                switch (defaultType) {
                    case 2: {
                        holder.connections[2] = connection = this.getSlaveConnection();
                        break;
                    }
                    case 4: {
                        holder.connections[4] = connection = new FakeConnection();
                        break;
                    }
                    default: {
                        holder.connections[1] = connection = this.getConnection();
                    }
                }
            }
        }
        return connection;
    }

    @Override
    public void commit() throws BGException {
        try {
            if (this.masterConnection != null && !this.masterConnection.getAutoCommit()) {
                this.masterConnection.commit();
            }
            if (this.trashConnections != null) {
                HashSet<Connection> commited = new HashSet<Connection>();
                for (TrashConnectionHolder holder : this.trashConnections.values()) {
                    for (Connection connection : holder.connections) {
                        if (connection == null || connection == this.slaveConnection || connection == this.masterConnection || connection.getAutoCommit() || !commited.add(connection)) continue;
                        connection.commit();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    @Override
    public void close() {
        this.recycled = true;
        if (this.trashConnections != null) {
            for (TrashConnectionHolder holder : this.trashConnections.values()) {
                for (Connection connection : holder.connections) {
                    if (connection == null || connection == this.slaveConnection || connection == this.masterConnection) continue;
                    try {
                        if (!connection.isClosed()) {
                            connection.close();
                        }
                    }
                    catch (Exception ex) {
                        this.logError(ex);
                    }
                    holder.connections[i] = null;
                }
            }
            this.trashConnections.clear();
        }
        if (this.slaveConnection != null) {
            if (this.slaveConnection != this.masterConnection) {
                try {
                    if (!this.slaveConnection.isClosed()) {
                        this.slaveConnection.close();
                    }
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
            this.slaveConnection = null;
        }
        if (this.masterConnection != null) {
            if (this.internalMaster) {
                try {
                    if (!this.masterConnection.isClosed()) {
                        this.masterConnection.close();
                    }
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
            this.masterConnection = null;
        }
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        if (this.trashConnections != null) {
            for (TrashConnectionHolder holder : this.trashConnections.values()) {
                for (Connection connection : holder.connections) {
                    if (connection == null || connection == this.slaveConnection || connection == this.masterConnection) continue;
                    try {
                        connection.setAutoCommit(autoCommit);
                    }
                    catch (Exception ex) {
                        this.logError(ex);
                    }
                }
            }
        }
        if (this.masterConnection != null) {
            try {
                this.masterConnection.setAutoCommit(autoCommit);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        this.autoCommit = autoCommit;
    }

    public void rollback() {
        if (this.trashConnections != null) {
            for (TrashConnectionHolder holder : this.trashConnections.values()) {
                for (Connection connection : holder.connections) {
                    if (connection == null || connection == this.slaveConnection || connection == this.masterConnection) continue;
                    try {
                        connection.rollback();
                    }
                    catch (Exception ex) {
                        this.logError(ex);
                    }
                }
            }
        }
        if (this.masterConnection != null) {
            try {
                this.masterConnection.rollback();
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    public static final ConnectionSet newInstance(DefaultServerSetup setup, boolean autoCommit) {
        return new SetupConnectionSet(setup, autoCommit);
    }

    public static final ConnectionSet newInstance(DefaultServerSetup setup, Connection con, boolean autoCommit) {
        return new SetupConnectionSet(setup, con, autoCommit);
    }

    static final class TrashConnectionHolder {
        boolean inited;
        final Connection[] connections = new Connection[4];

        TrashConnectionHolder() {
        }
    }
}

