/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.tariff.directory;

import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.directory.tariff.client.DefaultDirectory;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public abstract class TableDirectory
extends DefaultDirectory {
    protected int moduleId = -1;

    @Override
    protected void loadDir(int moduleId) {
        this.moduleId = moduleId;
        Request request = this.getStandartRequest();
        request.setAttribute("title_column", this.getTitleColumn());
        request.setAttribute("command", "list");
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxParserFactory.newSAXParser();
            XMLReader parser = saxParser.getXMLReader();
            parser.setContentHandler(new DefaultHandler(){
                private boolean isData = false;
                private boolean isList = false;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (!this.isData && "data".equals(qName)) {
                        this.isData = true;
                    }
                    if (this.isData && !this.isList && "list".equals(qName)) {
                        this.isList = true;
                    }
                    if (this.isData && this.isList && "item".equals(qName)) {
                        IdTitle idTitle = new IdTitle();
                        idTitle.setId(Integer.parseInt(attributes.getValue("id")));
                        idTitle.setTitle(attributes.getValue("value"));
                        TableDirectory.this.items.add(idTitle);
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (this.isData && "data".equals(qName)) {
                        this.isData = false;
                    }
                    if (this.isList && "list".equals(qName)) {
                        this.isList = false;
                    }
                }
            });
            parser.parse(new InputSource(new StringReader(this.getString(request))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Request getStandartRequest() {
        Request request = new Request();
        request.setModule("admin");
        request.setModuleId(this.moduleId);
        request.setAction("PairsFromTable");
        request.setAttribute("table", this.getTableName());
        return request;
    }

    @Override
    public int addValue(String value) {
        Request request = this.getStandartRequest();
        request.setAttribute("command", "add");
        request.setAttribute("title", value);
        Document doc = this.getDoc(request);
        IdTitle di = new IdTitle();
        di.setId(Utils.parseInt(doc.getDocumentElement().getAttribute("id")));
        di.setTitle(value);
        this.items.add(0, di);
        return di.getId();
    }

    @Override
    public void removeValue(int code) {
        if (this.deleteByCode(code)) {
            Request request = this.getStandartRequest();
            request.setAttribute("command", "delete");
            request.setAttribute("id", String.valueOf(code));
            this.getDoc(request);
        }
    }

    @Override
    public void renameValue(int code, String newName) {
        IdTitle di = this.getItem(code);
        if (di != null) {
            di.setTitle(newName);
            Request request = this.getStandartRequest();
            request.setAttribute("command", "rename");
            request.setAttribute("title", newName);
            request.setAttribute("id", String.valueOf(code));
            this.getDoc(request);
        }
    }

    protected abstract String getTableName();

    protected String getTitleColumn() {
        return "title";
    }
}

