/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree.old;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.common.Utils;

public class ServiceUpLimitTariffTreeNode
extends DefaultTariffTreeNode {
    private static final boolean debug = false;
    private int lastCid = -1;
    private long lastContractAmount = 0L;
    private int mode;
    private long topAmount = 0L;
    private Map<Integer, Long> contractAmounts = Collections.synchronizedMap(new HashMap(100, 20.0f));

    @Override
    public void init(String dataStr, int deep, int nodeID) {
        super.init(dataStr, deep, nodeID);
        Map<String, String> data = this.getDataInHash();
        int type = Utils.parseInt(data.get("type"), -1);
        long col = Utils.parseLong(data.get("col"), -1L);
        this.mode = Utils.parseInt(data.get("mode"), 0);
        if (type >= 0 && col >= 0L) {
            this.topAmount = this.getServiceAmount(type, col);
        }
    }

    @Override
    public void processRequest(TariffRequest request) {
        String action = (String)request.getRequestParam("action");
        Integer cid = (Integer)request.getRequestParam("cid");
        Long amount = (Long)request.getRequestParam("amount");
        Float part = null;
        if (action != null && cid != null) {
            long topAmount = this.topAmount;
            if (this.mode == 1) {
                part = (Float)request.getRequestParam("part");
                if (part != null) {
                    topAmount = (long)((float)topAmount * part.floatValue());
                }
            } else if (this.mode == 2) {
                part = (Float)request.getRequestParam("part_tariff");
                if (part != null) {
                    topAmount = (long)((float)topAmount * part.floatValue());
                }
            } else if (this.mode == 3 && (part = (Float)request.getRequestParam("part_tariff_suspended")) != null) {
                topAmount = (long)((float)topAmount * part.floatValue());
            }
            if (action.equals("init")) {
                if (amount != null && amount > 0L) {
                    long amountRest;
                    Long contractAmount;
                    boolean cidNew = cid != this.lastCid;
                    Long l = contractAmount = cidNew ? this.contractAmounts.get(cid) : Long.valueOf(this.lastContractAmount);
                    if (contractAmount == null) {
                        contractAmount = 0L;
                    }
                    long takedAmount = (amountRest = topAmount - contractAmount) > amount || topAmount == 0L ? amount : amountRest;
                    contractAmount = contractAmount + takedAmount;
                    this.contractAmounts.put(cid, contractAmount);
                    this.lastCid = cid;
                    this.lastContractAmount = contractAmount;
                }
            } else if (action.equals("reset")) {
                this.contractAmounts.remove(cid);
                this.processForChilds(request);
            } else if (this.enableNodeForContract(cid, topAmount) && !request.wasAccepted()) {
                this.processForChilds(request);
            }
        } else {
            request.addError("Params error! ServiceUpLimitTariffTreeNode::processRequest()");
        }
    }

    private boolean enableNodeForContract(Integer cid, long topAmount) {
        boolean result = true;
        if (topAmount != 0L) {
            Long contractAmount;
            boolean cidNew = cid != this.lastCid;
            Long l = contractAmount = cidNew ? this.contractAmounts.get(cid) : Long.valueOf(this.lastContractAmount);
            if (contractAmount != null && contractAmount >= topAmount) {
                result = false;
            }
            this.lastCid = cid;
            this.lastContractAmount = contractAmount != null ? contractAmount : 0L;
        }
        return result;
    }
}

