/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.api;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.json.JSONObject;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonApiClient;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class MegafonApiToken {
    private static final ConcurrentMap<Integer, TokenData> TOKEN_HOLDER = new ConcurrentHashMap<Integer, TokenData>(2);

    private MegafonApiToken() {
    }

    private static MegafonApiToken getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public static String getToken(int moduleId) {
        return MegafonApiToken.getTokenData(moduleId).getToken();
    }

    public static TokenData getTokenData(int moduleId) {
        if (MegafonApiToken.getInstance().tokenIsNeedUpdate(moduleId)) {
            MegafonApiToken.getInstance().updateToken(moduleId);
        }
        return (TokenData)TOKEN_HOLDER.get(moduleId);
    }

    private boolean tokenIsNeedUpdate(int moduleId) {
        TokenData tokenData = (TokenData)TOKEN_HOLDER.get(moduleId);
        if (tokenData == null) {
            return true;
        }
        return (new Date().getTime() - tokenData.getTokenUpdateTime().getTime()) / 1000L >= (long)tokenData.expiresIn;
    }

    private void updateToken(int moduleId) {
        JSONObject resp = new MegafonApiClient(moduleId).getToken(this.getRequestBody(moduleId));
        TokenData tokenData = new TokenData(resp.optString("access_token"), resp.optInt("expires_in"), resp.optInt("refresh_expires_in"), resp.optString("refresh_token"), resp.optString("token_type"), resp.optInt("not-before-policy"), resp.optString("session_state"), resp.optString("scope"));
        TOKEN_HOLDER.put(moduleId, tokenData);
    }

    private String getRequestBody(int moduleId) {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        String username = moduleSetup.get("megafon.username");
        if (Utils.isBlankString((String)username)) {
            throw new RuntimeException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 username");
        }
        String password = moduleSetup.get("megafon.password");
        if (Utils.isBlankString((String)password)) {
            throw new RuntimeException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 password");
        }
        String clientId = moduleSetup.get("megafon.clientid");
        if (Utils.isBlankString((String)clientId)) {
            throw new RuntimeException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 clientId");
        }
        String secret = moduleSetup.get("megafon.secret");
        if (Utils.isBlankString((String)secret)) {
            throw new RuntimeException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 secret");
        }
        return this.buildBody(username, password, clientId, secret);
    }

    public String buildBody(String username, String password, String clientId, String secret) {
        return "username=" + URLEncoder.encode(username, StandardCharsets.UTF_8) + "&password=" + URLEncoder.encode(password, StandardCharsets.UTF_8) + "&grant_type=password&client_id=" + URLEncoder.encode(clientId, StandardCharsets.UTF_8) + "&client_secret=" + URLEncoder.encode(secret, StandardCharsets.UTF_8);
    }

    private static class InstanceHolder {
        private static final MegafonApiToken INSTANCE = new MegafonApiToken();

        private InstanceHolder() {
        }
    }

    public final class TokenData {
        private final String token;
        private final int expiresIn;
        private final int refreshExpiresIn;
        private final String refreshToken;
        private final String tokenType;
        private final int notBeforePolicy;
        private final String sessionState;
        private final String scope;
        private final Date tokenUpdateTime;

        public TokenData(String token, int expiresIn, int refreshExpiresIn, String refreshToken, String tokenType, int notBeforePolicy, String sessionState, String scope) {
            this.token = token;
            this.expiresIn = expiresIn;
            this.refreshExpiresIn = refreshExpiresIn;
            this.refreshToken = refreshToken;
            this.tokenType = tokenType;
            this.notBeforePolicy = notBeforePolicy;
            this.sessionState = sessionState;
            this.scope = scope;
            this.tokenUpdateTime = new Date();
        }

        public String getToken() {
            return this.token;
        }

        public int getExpiresIn() {
            return this.expiresIn;
        }

        public int getRefreshExpiresIn() {
            return this.refreshExpiresIn;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public int getNotBeforePolicy() {
            return this.notBeforePolicy;
        }

        public String getSessionState() {
            return this.sessionState;
        }

        public String getScope() {
            return this.scope;
        }

        public Date getTokenUpdateTime() {
            return this.tokenUpdateTime;
        }
    }
}

