/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.qiwi.server.bean;

import bitel.billing.server.contract.bean.ContractManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.qiwi.common.bean.Transaction;
import ru.bitel.bgbilling.modules.qiwi.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.qiwi.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;

public abstract class AbstractQiwiProtocol
extends BGLogger {
    protected ModuleSetup moduleSetup;
    protected int moduleId;
    protected Connection connection;
    protected ContractManager contractManager;

    public AbstractQiwiProtocol(Connection con, int moduleId, ModuleSetup moduleSetup) {
        this.connection = con;
        this.moduleId = moduleId;
        this.moduleSetup = moduleSetup;
        this.contractManager = new ContractManager(this.connection);
    }

    public abstract String beginTransaction(int var1, String var2, BigDecimal var3, String var4, String var5) throws BGException;

    public abstract void checkTransaction(Transaction var1) throws BGException;

    public abstract void cancelTransaction(Transaction var1) throws BGException;

    public abstract void refundTransaction(Transaction var1) throws BGException;

    public abstract void checkRefundStatus(Transaction var1) throws BGException;

    protected void addPayment(Transaction transaction, TransactionManager manager) throws Exception {
        boolean autoCommit = this.connection.getAutoCommit();
        this.connection.setAutoCommit(false);
        transaction.setStatus(TransactionStatus.PAIDED.getCode());
        transaction.setPaymentDate(new Date());
        Payment payment = Payment.builder().setDate(transaction.getPaymentDate()).setTypeId(this.moduleSetup.getInt("qiwi.payment.type.id", -1)).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(this.moduleSetup.get("qiwi.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0438\u0441 QIWI [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", transaction.getTransactionId())).build();
        new PaymentDao(this.connection).update((Object)payment);
        manager.update(transaction);
        this.connection.commit();
        try (BalanceUtils balanceUtils = new BalanceUtils(this.connection);){
            balanceUtils.updateBalance(new Date(), transaction.getContractId());
        }
        this.connection.commit();
        this.connection.setAutoCommit(autoCommit);
        EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
        EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
    }

    protected static enum QiwiResultCode {
        SUCCESS(0, "\u0423\u0441\u043f\u0435\u0445"),
        INCORRECT_REQUEST_DATA(5, "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0432 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u0445 \u0437\u0430\u043f\u0440\u043e\u0441\u0430"),
        SERVER_BUSY(13, "\u0421\u0435\u0440\u0432\u0435\u0440 \u0437\u0430\u043d\u044f\u0442, \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e\u0437\u0436\u0435"),
        INCORRECT_OPERATION(78, "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0430\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f"),
        AUTH_ERROR(150, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"),
        PROTOCOL_ERROR(152, "\u041d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u0438\u043b\u0438 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b"),
        BLOCKED_APIID(155, "\u0414\u0430\u043d\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430 (API ID) \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d"),
        BILL_NOT_FOUND(210, "\u0421\u0447\u0435\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d"),
        BILL_ALREADY_EXIST(215, "\u0421\u0447\u0435\u0442 \u0441 \u0442\u0430\u043a\u0438\u043c bill_id \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442"),
        SUMM_TOO_SMALL(241, "\u0421\u0443\u043c\u043c\u0430 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u0430\u043b\u0430"),
        SUMM_TOO_BIG(242, "\u0421\u0443\u043c\u043c\u0430 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0432\u0435\u043b\u0438\u043a\u0430"),
        WALLET_NOT_REGISTERED(298, "\u041a\u043e\u0448\u0435\u043b\u0435\u043a \u0441 \u0442\u0430\u043a\u0438\u043c \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u043d\u0435 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d"),
        TECHNICAL_ERROR(300, "\u0422\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430"),
        INCORRECT_PHONE(303, "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430"),
        BLOCKED_PROVIDER_AUTH(316, "\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u043c \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u043e\u043c"),
        UNAUTHORED(319, "\u041d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043d\u0430 \u0434\u0430\u043d\u043d\u0443\u044e \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e"),
        BLOCKED_IP(339, "\u0412\u0430\u0448 IP-\u0430\u0434\u0440\u0435\u0441 \u0438\u043b\u0438 \u043c\u0430\u0441\u0441\u0438\u0432 \u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d"),
        REQUIRED_PARAMETER_IS_EMPTY(341, "\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u043e \u0438\u043b\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0435"),
        MONTH_LIMIT_OVER(700, "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043c\u0435\u0441\u044f\u0447\u043d\u044b\u0439 \u043b\u0438\u043c\u0438\u0442 \u043d\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438"),
        WALLET_TEMPORARELY_BLOCKED(774, "\u041a\u043e\u0448\u0435\u043b\u0435\u043a \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d"),
        DENYED_CURRENCY(1001, "\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043d\u0430\u044f \u0432\u0430\u043b\u044e\u0442\u0430 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430"),
        CONVERT_COURCE_UNAVAILABLE(1003, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u0443\u0440\u0441 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u043f\u0430\u0440\u044b \u0432\u0430\u043b\u044e\u0442"),
        UNDEFINED_MOBILE_OPERATOR(1019, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0441\u043e\u0442\u043e\u0432\u043e\u0433\u043e \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u0434\u043b\u044f \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u043e\u0439 \u043a\u043e\u043c\u043c\u0435\u0440\u0446\u0438\u0438"),
        BILL_MODIFYING_DENYED(1419, "\u041d\u0435\u043b\u044c\u0437\u044f \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0441\u0447\u0435\u0442\u0430 \u2013 \u043e\u043d \u0443\u0436\u0435 \u043e\u043f\u043b\u0430\u0447\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0438\u043b\u0438 \u043e\u043f\u043b\u0430\u0447\u0435\u043d");

        private int code;
        private String title;

        private QiwiResultCode(int code, String title) {
            this.code = code;
            this.title = title;
        }

        public int getCode() {
            return this.code;
        }

        public String getTitle() {
            return this.title;
        }

        public static QiwiResultCode getResultCodeByCode(int code) {
            QiwiResultCode result = null;
            for (QiwiResultCode resultCode : QiwiResultCode.values()) {
                if (resultCode.getCode() != code) continue;
                result = resultCode;
                break;
            }
            return result;
        }
    }
}

