/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.flussonicwatcher;

import java.util.ArrayList;
import javax.swing.table.TableCellRenderer;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.smarthouse.client.flussonicwatcher.FlussonicWatcherBasePanel;
import ru.bitel.bgbilling.modules.smarthouse.common.service.FlussonicWatcherUserService;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.RowData;
import ru.bitel.common.model.SearchResult;

public class FlussonicWatcherUsersPanel
extends FlussonicWatcherBasePanel {
    private UserTableModel tableModel;
    private FlussonicWatcherUserService userService;

    @Override
    protected BGTableModel<RowData> getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new UserTableModel(UserTableModel.class.getName());
        }
        return this.tableModel;
    }

    @Override
    protected void doRefresh() throws BGException {
        SearchResult searchResult = this.getUserService().searchUsers();
        ArrayList data = new ArrayList();
        searchResult.getList().forEach(i -> data.add(new RowData(i)));
        this.getTableModel().setData(data);
    }

    protected void getPopupMenuItems() {
        this.popupMenu.add(this.getRecordDataMenuItem());
    }

    private FlussonicWatcherUserService getUserService() {
        if (this.userService == null) {
            this.userService = (FlussonicWatcherUserService)((ClientContext)this.getContext()).getPort(FlussonicWatcherUserService.class);
        }
        return this.userService;
    }

    class UserTableModel
    extends BGTableModel<RowData> {
        public UserTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041b\u043e\u0433\u0438\u043d", 100, 150, 200, "login", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0418\u043c\u044f", 100, 150, 200, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("E-mail", 100, 150, 200, "notification_email", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0435\u043b\u0435\u0444\u043e\u043d", 100, 150, 200, "phone", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0412\u043a\u043b\u044e\u0447\u0435\u043d", Boolean.class, 80, 80, 80, "enabled", true);
            this.addColumn("\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440", Boolean.class, 100, 150, 200, "is_admin", true);
            this.addColumn("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438", 100, 150, -1, "organizations", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValueAt(RowData rowData, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            JSONObject json = rowData.getJson();
            if ("id".equals(identifier)) {
                return json.optInt(identifier);
            }
            if ("enabled".equals(identifier) || "is_admin".equals(identifier)) {
                return json.optBoolean(identifier);
            }
            if ("login".equals(identifier) || "name".equals(identifier) || "notification_email".equals(identifier) || "phone".equals(identifier)) {
                return json.optString(identifier);
            }
            if ("organizations".equals(identifier)) {
                return json.optString(identifier);
            }
            return super.getValueAt((Object)rowData, column);
        }
    }
}

