/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.runtime;

import bitel.billing.server.contract.bean.ContractManager;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Application;
import ru.bitel.bgbilling.kernel.application.server.CommandListener;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.managed.ServerContextThreadFactory;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.contract.status.server.ContractStatusList;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusModifiedEvent;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.event.ContractTariffOptionChangedEvent;
import ru.bitel.bgbilling.kernel.tariff.server.event.ContractTariffChangedEvent;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.event.TvAccountModifiedEvent;
import ru.bitel.bgbilling.modules.tv.common.event.access.TvAccountDeviceStateAndOptionsModifiedEvent;
import ru.bitel.bgbilling.modules.tv.common.event.access.TvProductsDeviceStateModifiedEvent;
import ru.bitel.bgbilling.modules.tv.server.bean.TvAccountDao;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductRuntimeList;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.ServiceRuntimeList;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeLeaf;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeRoot;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountSpecRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvApplication;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.CopyOnWriteListMap;
import ru.bitel.common.util.CopyOnWriteRangeListMap;
import ru.bitel.common.util.Ranger;
import ru.bitel.common.worker.WorkerTask;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.event.ProductModifiedEvent;
import ru.bitel.oss.systems.inventory.product.common.event.ProductPeriodModifiedEvent;
import ru.bitel.oss.systems.inventory.product.common.event.ProductStateEntry;
import ru.bitel.oss.systems.inventory.product.server.ProductPeriodRuntimeList;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductDao;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductPeriodDao;
import ru.bitel.oss.systems.inventory.service.common.event.ServiceStateEntry;
import ru.bitel.oss.systems.inventory.service.server.bean.ServiceDao;

public class TvAccountRuntimeMap
implements EventListener<Event>,
CommandListener {
    private static final Logger logger = LogManager.getLogger();
    private final Ranger<TvAccountRuntime, Long> periodRanger = new Ranger<TvAccountRuntime, Long>(){

        public Long getMinValue(TvAccountRuntime r) {
            long result = r.dateFromMillis;
            if (result != 0L) {
                return result;
            }
            return null;
        }

        public Long getMaxValue(TvAccountRuntime r) {
            long result = r.dateToMillis;
            if (result != 0L) {
                return result;
            }
            return null;
        }
    };
    private final int moduleId;
    private final ContractRuntimeMap contractRuntimeMap;
    private final ReentrantLock lock = new ReentrantLock();
    private final ConcurrentMap<Integer, TvAccountRuntime> tvAccountMap = new ConcurrentHashMap<Integer, TvAccountRuntime>(512);
    private final CopyOnWriteListMap<Integer, TvAccountRuntime> contractMap = new CopyOnWriteListMap(128, 4);
    private final CopyOnWriteListMap<Integer, TvAccountRuntime> childrenServMap = new CopyOnWriteListMap(128, 4);
    private final CopyOnWriteRangeListMap<String, TvAccountRuntime, Long> usernameMap = new CopyOnWriteRangeListMap(this.periodRanger, 128, 4);
    private final Date dateFrom;
    private Ref childrenDeviceIds;
    private boolean eventListenerSet = false;

    public TvAccountRuntimeMap(int moduleId, ContractRuntimeMap contractRuntimeMap, Date dateFrom) throws BGException {
        this(moduleId, contractRuntimeMap, dateFrom, null);
    }

    public TvAccountRuntimeMap(int moduleId, ContractRuntimeMap contractRuntimeMap, Date dateFrom, final TvApplication tvApplication) throws BGException {
        this.moduleId = moduleId;
        this.contractRuntimeMap = contractRuntimeMap;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dateFrom);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
        ((Calendar)calendar).add(5, -3);
        this.dateFrom = calendar.getTime();
        if (tvApplication != null) {
            Application.getInstance().getCommandPortListener().addListener((CommandListener)this);
            this.childrenDeviceIds = new Ref(){

                @Override
                public Set<Integer> get() {
                    return tvApplication.childrenDeviceIds;
                }
            };
        } else {
            this.childrenDeviceIds = new Ref(){

                @Override
                public Set<Integer> get() {
                    return null;
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(TvApplication application, ConnectionSet connectionSet) throws Exception {
        Connection con = connectionSet.getConnection();
        this.lock.lock();
        try {
            if (!this.eventListenerSet) {
                this.eventListenerSet = true;
                EventProcessor ep = EventProcessor.getInstance();
                ep.addListener((EventListener)this, TvAccountModifiedEvent.class, this.moduleId, null);
                ep.addListener((EventListener)this, TvAccountDeviceStateAndOptionsModifiedEvent.class, this.moduleId, null);
                ep.addListener((EventListener)this, ContractStatusModifiedEvent.class);
                ep.addListener((EventListener)this, ContractTariffOptionChangedEvent.class);
                ep.addListener((EventListener)this, ContractTariffChangedEvent.class);
                ep.addListener((EventListener)this, ProductModifiedEvent.class, this.moduleId, null);
                ep.addListener((EventListener)this, ProductPeriodModifiedEvent.class, this.moduleId, null);
                ep.addListener((EventListener)this, TvProductsDeviceStateModifiedEvent.class, this.moduleId, null);
            }
            ExecutorService executorService = Executors.newFixedThreadPool(4, (ThreadFactory)new ServerContextThreadFactory(Setup.getSetup(), application.moduleId, "tvAccount-load", null));
            logger.info("Loading accounts from database.");
            TvAccountDao tvAccountDao = new TvAccountDao(con, this.moduleId);
            for (Integer deviceId : application.childrenDeviceIds) {
                List<TvAccount> tvAccountList = tvAccountDao.listRuntime(deviceId, null);
                if (tvAccountList.size() < 1000) {
                    this.load(executorService, tvAccountList);
                    continue;
                }
                Map<Integer, List<TvAccount>> map = tvAccountList.stream().collect(Collectors.groupingBy(a -> a.getContractId() % 24));
                for (List<TvAccount> list : map.values()) {
                    this.load(executorService, list);
                }
            }
            try {
                executorService.shutdown();
                executorService.awaitTermination(1L, TimeUnit.HOURS);
            }
            catch (InterruptedException ex) {
                Thread.interrupted();
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            logger.info("Load tvAccounts from database complete. Loaded " + this.tvAccountMap.size() + " tvAccounts.");
        }
        finally {
            this.lock.unlock();
        }
    }

    private void load(ExecutorService executorService, final List<TvAccount> tvAccountList) {
        executorService.execute((Runnable)new WorkerTask<ServerContext>(){

            protected void runImpl() throws Exception {
                try {
                    TvAccountRuntimeMap.this.load((ServerContext)this.context, tvAccountList, false);
                }
                catch (BGException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                logger.info("Loaded " + TvAccountRuntimeMap.this.tvAccountMap.size() + " tvAccounts.");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(ServerContext context, List<TvAccount> tvAccountList, boolean slave) throws Exception {
        ConnectionSet connectionSet = context.getConnectionSet();
        Connection con = slave ? connectionSet.getSlaveConnection() : connectionSet.getConnection();
        ContractManager contractManager = new ContractManager(con);
        ContractLabelManager labelManager = new ContractLabelManager(con);
        ContractStatusDao contractStatusDao = new ContractStatusDao(con);
        Set suspendStatusSet = StatusCache.getInstance().getModuleSuspendStatusSet(this.moduleId);
        ContractTariffOptionDao tariffOptionManager = new ContractTariffOptionDao(con);
        TvAccountSpecRuntimeMap servTypeRuntimeMap = TvAccountSpecRuntimeMap.getInstance(connectionSet, this.moduleId);
        TariffModuleTreeSetDao treeSetDao = new TariffModuleTreeSetDao(con);
        ProductDao productDao = new ProductDao(con);
        ServiceDao serviceDao = new ServiceDao(con);
        ProductPeriodDao productPeriodDao = new ProductPeriodDao(con, 0);
        GregorianCalendar utilCalendar = new GregorianCalendar();
        try {
            for (TvAccount tvAccount : tvAccountList) {
                try {
                    TvAccountRuntime runtime = this.newRuntime(connectionSet, contractManager, labelManager, contractStatusDao, suspendStatusSet, tariffOptionManager, servTypeRuntimeMap, treeSetDao, productDao, serviceDao, productPeriodDao, tvAccount, utilCalendar);
                    if (runtime == null) continue;
                    this.addRuntime(runtime);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        finally {
            treeSetDao.close();
            productDao.close();
            productPeriodDao.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TvAccountRuntime newRuntime(ConnectionSet connectionSet, ContractManager contractManager, ContractLabelManager labelManager, ContractStatusDao contractStatusDao, Set<Integer> suspendStatusSet, ContractTariffOptionDao tariffOptionManager, TvAccountSpecRuntimeMap servTypeRuntimeMap, TariffModuleTreeSetDao treeSetDao, ProductDao productDao, ServiceDao serviceDao, ProductPeriodDao productPeriodDao, TvAccount tvAccount, Calendar utilCalendar) {
        try {
            AtomicReference servTypeRef = servTypeRuntimeMap.getRef(tvAccount.getSpecId());
            if (tvAccount.getParentId() > 0) {
                TvAccountDao tvAccountDao;
                Object parent;
                TvAccountRuntime parentRuntime = (TvAccountRuntime)this.tvAccountMap.get(tvAccount.getParentId());
                if (parentRuntime == null && (parent = (TvAccount)(tvAccountDao = new TvAccountDao(connectionSet.getConnection(), this.moduleId)).get(tvAccount.getParentId())) != null && parent.getId() != tvAccount.getId()) {
                    parentRuntime = this.addRuntime(connectionSet, (TvAccount)parent);
                }
                if (parentRuntime == null) {
                    logger.error("Not found parent tvAccount with id=" + tvAccount.getParentId());
                    return null;
                }
                parentRuntime.lock();
                try {
                    TvAccountRuntimeLeaf runtime = new TvAccountRuntimeLeaf(tvAccount.getId(), servTypeRef, parentRuntime);
                    runtime.setTvAccount(tvAccount);
                    parent = runtime;
                    return parent;
                }
                finally {
                    parentRuntime.unlock();
                }
            }
            int contractId = tvAccount.getContractId();
            ContractRuntime contractRuntime = this.contractRuntimeMap.getContractRuntime(contractManager, labelManager, contractStatusDao, tariffOptionManager, productPeriodDao, Integer.valueOf(contractId));
            if (contractRuntime == null) {
                logger.error("Contract not found with id=" + contractId + " but TvAccount exist");
                return null;
            }
            TvAccountRuntimeRoot runtime = new TvAccountRuntimeRoot(tvAccount.getId(), (AtomicReference<TvAccountSpecRuntime>)servTypeRef, contractRuntime);
            runtime.setTvAccount(tvAccount);
            runtime.tariffTreeSet = treeSetDao.getRealtimeTariffTreeSet(tvAccount.getContractId(), this.dateFrom, "tv", this.moduleId, this.moduleId, tvAccount.getId());
            List suspendPeriodList = contractStatusDao.getStatusList(contractId, suspendStatusSet, this.dateFrom, null);
            runtime.contractSuspendPeriods = new ContractStatusList(suspendPeriodList, utilCalendar);
            runtime.productRuntimeList = ProductRuntimeList.newInstance(productDao.list(-1, contractId, tvAccount.getId(), true, null, null, this.dateFrom, null, true, false));
            runtime.serviceRuntimeList = ServiceRuntimeList.newInstance(serviceDao.list(-1, contractId, tvAccount.getId(), true, null, null, this.dateFrom, null, true, false));
            runtime.productPeriodItemList = ProductPeriodRuntimeList.newInstance((List)productPeriodDao.list(-1, contractId, tvAccount.getId(), true, null, this.dateFrom, true));
            return runtime;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private void addRuntime(TvAccountRuntime runtime) {
        block5: {
            TvAccount tvAccount;
            block4: {
                logger.info("Adding TvAccountRuntime: " + runtime.tvAccountId);
                logger.info((Object)runtime);
                tvAccount = runtime.getTvAccount();
                this.tvAccountMap.put(tvAccount.getId(), runtime);
                this.contractMap.add((Object)tvAccount.getContractId(), (Object)runtime);
                if (tvAccount.getParentId() <= 0) break block4;
                tvAccount.setLogin(tvAccount.getLogin());
                this.childrenServMap.add((Object)tvAccount.getParentId(), (Object)runtime);
                List children = this.childrenServMap.get((Object)runtime.tvAccountId);
                if (children == null || children.size() <= 0) break block5;
                int size = children.size();
                for (int i = 0; i < size; ++i) {
                    TvAccountRuntime child = (TvAccountRuntime)children.get(i);
                    child.parent = runtime;
                }
                break block5;
            }
            if (Utils.notEmptyString((String)tvAccount.getLogin())) {
                this.usernameMap.add((Object)tvAccount.getLogin(), (Object)runtime);
            }
            TvAccountRuntimeRoot root = (TvAccountRuntimeRoot)runtime;
            List children = this.childrenServMap.get((Object)runtime.tvAccountId);
            if (children != null && children.size() > 0) {
                int size = children.size();
                for (int i = 0; i < size; ++i) {
                    TvAccountRuntimeLeaf child = (TvAccountRuntimeLeaf)children.get(i);
                    child.parent = runtime;
                    this.setRoot(child, root);
                }
            }
        }
    }

    private void setRoot(TvAccountRuntimeLeaf runtime, TvAccountRuntimeRoot root) {
        runtime.root = root;
        List children = this.childrenServMap.get((Object)runtime.tvAccountId);
        if (children != null && children.size() > 0) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                this.setRoot((TvAccountRuntimeLeaf)children.get(i), root);
            }
        }
    }

    private TvAccountRuntime removeRuntime(int tvAccountId) {
        logger.info("Removing accountRuntime: " + tvAccountId);
        TvAccountRuntime oldInetServInstance = (TvAccountRuntime)this.tvAccountMap.remove(tvAccountId);
        if (oldInetServInstance != null) {
            TvAccount oldInetServ = oldInetServInstance.getTvAccount();
            this.contractMap.remove((Object)oldInetServ.getContractId(), (Object)oldInetServInstance);
            if (oldInetServ.getParentId() > 0) {
                this.childrenServMap.remove((Object)oldInetServ.getParentId(), (Object)oldInetServInstance);
            }
            if (oldInetServ.getParentId() <= 0 && Utils.notEmptyString((String)oldInetServ.getLogin())) {
                this.usernameMap.remove((Object)oldInetServ.getLogin(), (Object)oldInetServInstance);
            }
        }
        return oldInetServInstance;
    }

    public void notify(Event e, EventListenerContext ctx) throws Exception {
        this.lock.lock();
        try {
            logger.info("Caught event: " + e);
            if (e instanceof TvAccountModifiedEvent) {
                if (((TvAccountModifiedEvent)e).getNewTvAccount() != null) {
                    this.onTvAccountModified(ctx.getConnectionSet(), (TvAccountModifiedEvent)e);
                }
            } else if (e instanceof TvAccountDeviceStateAndOptionsModifiedEvent) {
                this.onTvAccountDeviceStateAndOptionsModified((TvAccountDeviceStateAndOptionsModifiedEvent)e);
            } else if (e instanceof ProductPeriodModifiedEvent) {
                this.onProductPeriodModified((ProductPeriodModifiedEvent)e);
            } else if (e instanceof TvProductsDeviceStateModifiedEvent) {
                this.onProductsStateModified((TvProductsDeviceStateModifiedEvent)e);
            } else if (e instanceof ProductModifiedEvent) {
                this.onProductModified((ProductModifiedEvent)e, (ServerContext)ctx);
            } else if (e instanceof ContractStatusModifiedEvent) {
                this.onContractStatusModifiedEvent((ContractStatusModifiedEvent)e);
            } else if (e instanceof ContractTariffOptionChangedEvent) {
                this.onTariffOptionModified(e.getContractId());
            } else if (e instanceof ContractTariffChangedEvent) {
                this.onTariffListChanged((ServerContext)ctx, (ContractTariffChangedEvent)e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onProductPeriodModified(ProductPeriodModifiedEvent e) {
        if (e.getModuleId() != this.moduleId && e.getModuleId() == 0) {
            return;
        }
        int accountId = e.getAccountId();
        TvAccountRuntimeRoot runtime = (TvAccountRuntimeRoot)this.tvAccountMap.get(accountId);
        if (runtime == null) {
            logger.warn("TvAccount not found with id=" + accountId);
            return;
        }
        runtime.lock();
        try {
            if (e.getNewProductPeriodTimeTo() != null) {
                runtime.productRuntimeList = runtime.productRuntimeList.update(e.getProductSpecId(), e.getProductId(), e.getActivationModeId(), e.getProductTimeFrom(), e.getProductTimeTo(), (short)-1000);
                runtime.productPeriodItemList = runtime.productPeriodItemList.update(e.getProductSpecId(), e.getProductId(), e.getProductPeriodId(), e.getNewProductPeriodTimeFrom(), e.getNewProductPeriodTimeTo(), e.getProlongationTime());
            } else {
                runtime.productPeriodItemList = runtime.productPeriodItemList.remove(e.getProductSpecId(), e.getProductId(), e.getProductPeriodId(), e.getOldProductPeriodTimeFrom(), e.getOldProductPeriodTimeTo(), e.getProlongationTime());
            }
        }
        finally {
            runtime.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onProductModified(ProductModifiedEvent e, ServerContext ctx) throws Exception {
        Product oldProduct = e.getOldProduct();
        Product newProduct = e.getNewProduct();
        int accountId = oldProduct != null ? oldProduct.getAccountId() : newProduct.getAccountId();
        int productSpecId = oldProduct != null ? oldProduct.getProductSpecId() : newProduct.getProductSpecId();
        ProductSpecRuntime productSpecRuntime = (ProductSpecRuntime)ProductSpecRuntimeMap.getInstance(ctx.getConnectionSet()).get(productSpecId);
        ProductSpec productSpec = productSpecRuntime.getProductSpec();
        if (productSpec.getModuleId() != this.moduleId && productSpec.getModuleId() != 0) {
            return;
        }
        TvAccountRuntimeRoot runtime = (TvAccountRuntimeRoot)this.tvAccountMap.get(accountId);
        if (runtime == null) {
            logger.warn("TvAccount not found with id=" + accountId);
            return;
        }
        runtime.lock();
        try {
            if (newProduct != null) {
                runtime.productRuntimeList = runtime.productRuntimeList.update(newProduct.getProductSpecId(), newProduct.getId(), newProduct.getActivationModeId(), newProduct.getTimeFrom(), newProduct.getTimeTo(), newProduct.getDeviceState());
                runtime.serviceRuntimeList.update(newProduct.getId(), newProduct.getServiceList());
            } else {
                runtime.productRuntimeList = runtime.productRuntimeList.remove(oldProduct.getProductSpecId(), oldProduct.getId(), oldProduct.getActivationModeId(), oldProduct.getTimeFrom(), oldProduct.getTimeTo());
                runtime.serviceRuntimeList.update(oldProduct.getId(), null);
            }
        }
        finally {
            runtime.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onProductsStateModified(TvProductsDeviceStateModifiedEvent e) {
        TvAccountRuntimeRoot runtime = (TvAccountRuntimeRoot)this.tvAccountMap.get(e.getTvAccountId());
        if (runtime == null) {
            logger.warn("TvAccount not found with id=" + e.getTvAccountId());
            return;
        }
        runtime.lock();
        try {
            for (ProductStateEntry entry : e.getProductEntryList()) {
                runtime.productRuntimeList.updateState(entry.productId, entry.deviceState);
                if (entry.serviceEntryList == null) continue;
                for (ServiceStateEntry serviceEntry : entry.serviceEntryList) {
                    runtime.serviceRuntimeList.updateState(serviceEntry.serviceId, serviceEntry.deviceState);
                }
            }
        }
        finally {
            runtime.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onContractStatusModifiedEvent(ContractStatusModifiedEvent e) {
        List tvAccountRuntimeList = this.contractMap.get((Object)e.getContractId());
        if (tvAccountRuntimeList == null) {
            return;
        }
        ContractStatus oldContractStatus = e.getOldContractStatus();
        ContractStatus newContractStatus = e.getNewContractStatus();
        Set suspendedStatuses = StatusCache.getInstance().getModuleSuspendStatusSet(this.moduleId);
        if (oldContractStatus != null && !suspendedStatuses.contains(oldContractStatus.getStatus())) {
            oldContractStatus = null;
        }
        if (newContractStatus != null && !suspendedStatuses.contains(newContractStatus.getStatus())) {
            newContractStatus = null;
        }
        if (oldContractStatus == null && newContractStatus == null) {
            return;
        }
        ContractStatusList newContractSuspendPeriods = null;
        int size = tvAccountRuntimeList.size();
        for (int i = 0; i < size; ++i) {
            TvAccountRuntime runtime = (TvAccountRuntime)tvAccountRuntimeList.get(i);
            runtime.lock();
            try {
                ContractStatusList contractSuspendPeriods = runtime.contractSuspendPeriods;
                if (contractSuspendPeriods == null) continue;
                if (newContractSuspendPeriods == null) {
                    long millisTo;
                    long millisFrom;
                    newContractSuspendPeriods = contractSuspendPeriods;
                    GregorianCalendar utilCalendar = new GregorianCalendar();
                    if (oldContractStatus != null) {
                        millisFrom = TimeUtils.convertDateToMillisFrom((Calendar)utilCalendar, (Date)oldContractStatus.getDateFrom());
                        millisTo = TimeUtils.convertDateToMillisTo((Calendar)utilCalendar, (Date)oldContractStatus.getDateTo());
                        newContractSuspendPeriods = newContractSuspendPeriods.remove(oldContractStatus.getId(), millisFrom, millisTo);
                    }
                    if (newContractStatus != null) {
                        millisFrom = TimeUtils.convertDateToMillisFrom((Calendar)utilCalendar, (Date)newContractStatus.getDateFrom());
                        millisTo = TimeUtils.convertDateToMillisTo((Calendar)utilCalendar, (Date)newContractStatus.getDateTo());
                        newContractSuspendPeriods = newContractSuspendPeriods.update(newContractStatus.getId(), millisFrom, millisTo);
                    }
                    logger.debug("New contract suspended status list:\n" + newContractSuspendPeriods);
                }
                runtime.contractSuspendPeriods = newContractSuspendPeriods;
                continue;
            }
            finally {
                runtime.unlock();
            }
        }
    }

    private void onTariffListChanged(ServerContext context, ContractTariffChangedEvent e) {
        List tvAccountRuntimeList = this.contractMap.get((Object)e.getContractId());
        if (tvAccountRuntimeList != null) {
            Date now = new Date();
            try (TariffModuleTreeSetDao treeSetDao = new TariffModuleTreeSetDao(context.getConnection());){
                for (TvAccountRuntime tvAccountRuntime : tvAccountRuntimeList) {
                    if (!(tvAccountRuntime instanceof TvAccountRuntimeRoot)) continue;
                    ((TvAccountRuntimeRoot)tvAccountRuntime).tariffTreeSet = treeSetDao.getRealtimeTariffTreeSet(tvAccountRuntime.getTvAccount().getContractId(), now, "tv", this.moduleId, this.moduleId, tvAccountRuntime.getTvAccount().getId());
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void onTariffOptionModified(int contractId) throws BGException {
    }

    private void onTvAccountDeviceStateAndOptionsModified(TvAccountDeviceStateAndOptionsModifiedEvent e) {
        TvAccountRuntime instance = (TvAccountRuntime)this.tvAccountMap.get(e.getTvAccountId());
        if (instance != null) {
            instance.setDeviceStateAndOptionIds(e.getDeviceAccountId(), e.getDeviceState(), e.getDeviceOptionIds());
            if (e.getDeviceState() == -1) {
                this.tvAccountMap.remove(e.getTvAccountId());
            }
        }
    }

    private void onTvAccountModified(ConnectionSet connectionSet, TvAccountModifiedEvent e) {
        this.onTvAccountModified(connectionSet, e.getNewTvAccount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TvAccountRuntime addRuntime(ConnectionSet connectionSet, TvAccount tvAccount) {
        this.lock.lock();
        try {
            TvAccountRuntime tvAccountRuntime = this.onTvAccountModified(connectionSet, tvAccount);
            return tvAccountRuntime;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void load(ConnectionSet connectionSet, int contractId) throws Exception {
        if (this.contractMap.containsKey((Object)contractId)) {
            return;
        }
        TvAccountDao tvAccountDao = new TvAccountDao(connectionSet.getConnection(), this.moduleId);
        for (TvAccount tvAccount : tvAccountDao.list(contractId)) {
            this.onTvAccountModified(connectionSet, tvAccount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TvAccountRuntime onTvAccountModified(ConnectionSet connectionSet, TvAccount tvAccount) {
        Set<Integer> childrenDeviceIds = this.childrenDeviceIds.get();
        if (childrenDeviceIds != null && !childrenDeviceIds.contains(tvAccount.getDeviceId())) {
            this.removeRuntime(tvAccount.getId());
            return null;
        }
        TvAccountRuntime runtime = (TvAccountRuntime)this.tvAccountMap.get(tvAccount.getId());
        if (runtime == null) {
            logger.info("Adding new accountRuntime: " + tvAccount.getId());
            try {
                runtime = this.newRuntime(connectionSet, tvAccount);
                if (runtime != null) {
                    this.addRuntime(runtime);
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        } else {
            logger.info("Reload accountRuntime: " + tvAccount.getId());
            runtime.lock();
            try {
                TvAccount oldTvAccount;
                TvAccountRuntime oldRuntime = this.removeRuntime(runtime.tvAccountId);
                TvAccount tvAccount2 = oldTvAccount = oldRuntime != null ? oldRuntime.getTvAccount() : null;
                if (tvAccount.getChildren() != null && tvAccount.getChildren().isEmpty()) {
                    tvAccount.setChildren(Collections.emptyList());
                }
                runtime.setTvAccount(tvAccount);
                if (oldTvAccount != null) {
                    runtime.setDeviceStateAndOptionIds(oldTvAccount.getDeviceAccountId(), oldTvAccount.getDeviceState(), oldTvAccount.getDeviceOptionIds());
                }
                this.addRuntime(runtime);
            }
            finally {
                runtime.unlock();
            }
        }
        return runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TvAccountRuntime newRuntime(ConnectionSet connectionSet, TvAccount newTvAccount) throws Exception {
        Connection con = connectionSet.getConnection();
        ContractManager contractManager = new ContractManager(con);
        ContractLabelManager labelManager = new ContractLabelManager(con);
        ContractStatusDao contractStatusDao = new ContractStatusDao(con);
        Set suspendStatusSet = StatusCache.getInstance().getModuleSuspendStatusSet(this.moduleId);
        ContractTariffOptionDao tariffOptionManager = new ContractTariffOptionDao(con);
        TvAccountSpecRuntimeMap tvAccountSpecRuntimeMap = TvAccountSpecRuntimeMap.getInstance(connectionSet, this.moduleId);
        TariffModuleTreeSetDao treeSetDao = new TariffModuleTreeSetDao(con);
        ProductDao productDao = new ProductDao(con);
        ServiceDao serviceDao = new ServiceDao(con);
        ProductPeriodDao productPeriodDao = new ProductPeriodDao(con, 0);
        GregorianCalendar utilCalendar = new GregorianCalendar();
        logger.info("Loading TvAccount from database.");
        TvAccountRuntime result = null;
        try {
            result = this.newRuntime(connectionSet, contractManager, labelManager, contractStatusDao, suspendStatusSet, tariffOptionManager, tvAccountSpecRuntimeMap, treeSetDao, productDao, serviceDao, productPeriodDao, newTvAccount, utilCalendar);
        }
        finally {
            treeSetDao.close();
            productDao.close();
            productPeriodDao.close();
        }
        return result;
    }

    public TvAccount getTvAccount(Integer id) {
        TvAccountRuntime instance = (TvAccountRuntime)this.tvAccountMap.get(id);
        if (instance != null) {
            return instance.getTvAccount();
        }
        return null;
    }

    public TvAccountRuntime get(Integer id) {
        return (TvAccountRuntime)this.tvAccountMap.get(id);
    }

    public List<TvAccountRuntime> listChildren(Integer id) {
        return this.childrenServMap.get((Object)id);
    }

    public List<TvAccountRuntime> listChildren(Integer id, long millis) {
        List children = this.childrenServMap.get((Object)id);
        if (children == null || children.size() == 0) {
            return children;
        }
        ArrayList<TvAccountRuntime> result = new ArrayList<TvAccountRuntime>(children.size());
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            TvAccountRuntime child = (TvAccountRuntime)children.get(i);
            if (child.dateFromMillis != 0L && child.dateFromMillis > millis || child.dateToMillis != 0L && child.dateToMillis < millis) continue;
            result.add(child);
        }
        return result;
    }

    public TvAccountRuntime getByUsername(String username, Date date) throws BGException {
        return (TvAccountRuntime)this.usernameMap.get((Object)username, (Comparable)Long.valueOf(date.getTime()));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this);
    }

    public String executeCommand(String cmd, String param) {
        String result;
        block10: {
            result = null;
            try {
                if (!"servmap".equals(cmd)) break block10;
                StringBuilder sb = new StringBuilder(1000);
                ConvergenceBalanceManager convergenceBalanceManager = ConvergenceBalanceManager.getInstance();
                try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)Setup.getSetup(), (boolean)true);){
                    for (Map.Entry m : this.contractMap.entrySet()) {
                        List tvAccountRuntimeList = (List)m.getValue();
                        for (TvAccountRuntime tvAccount : tvAccountRuntimeList) {
                            sb.append(tvAccount);
                            ConvergenceBalance balance = convergenceBalanceManager.getBalance(connectionSet, Integer.valueOf(tvAccount.getTvAccount().getContractId()), System.currentTimeMillis());
                            sb.append("\n\tBalance: ").append(balance).append("\n");
                        }
                    }
                }
                result = sb.toString();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                result = e.getMessage();
            }
        }
        return result;
    }

    public String getCommandsHelp() {
        return "servmap - show service cache\n";
    }

    public Iterable<TvAccountRuntime> values() {
        return this.tvAccountMap.values();
    }

    public List<TvAccountRuntime> list(int contractId) {
        return this.contractMap.get((Object)contractId);
    }

    public List<TvAccountRuntime> list(Integer contractId, long millis) {
        List children = this.contractMap.get((Object)contractId);
        if (children == null || children.size() == 0) {
            return children;
        }
        ArrayList<TvAccountRuntime> result = new ArrayList<TvAccountRuntime>(children.size());
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            TvAccountRuntime child = (TvAccountRuntime)children.get(i);
            if (child.dateFromMillis != 0L && child.dateFromMillis > millis || child.dateToMillis != 0L && child.dateToMillis < millis) continue;
            result.add(child);
        }
        return result;
    }

    private static interface Ref {
        public Set<Integer> get();
    }
}

