/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.datalog.hourly.HourlyDataLogger;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.log.common.bean.ConnectionLogEntry;
import ru.bitel.bgbilling.kernel.log.server.event.RequestLogGetEvent;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusUtils;
import ru.bitel.bgbilling.kernel.network.radius.datalog.RadiusDataLogReader;
import ru.bitel.bgbilling.kernel.network.radius.datalog.hourly.RadiusHourlyDataLog;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceApplication;
import ru.bitel.bgbilling.modules.voice.server.runtime.device.VoiceDeviceRuntime;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.concurrent.ConcurrentUtils;

public class RequestLogEventProcessor
extends BGLogger
implements EventListener<RequestLogGetEvent> {
    private final DefaultServerSetup setup;
    private final VoiceApplication application;
    private final int moduleId;

    public RequestLogEventProcessor(DefaultServerSetup setup, VoiceApplication app) throws BGException {
        this.setup = setup;
        this.moduleId = SetupParam.getModuleId((ParameterMap)setup);
        this.application = app;
        EventProcessor.getInstance().addListener((EventListener)this, RequestLogGetEvent.class, this.moduleId, "applicationId=" + SetupParam.getApplicationId((ParameterMap)setup));
    }

    public void notify(RequestLogGetEvent e, EventListenerContext ctx) throws BGException {
        List list = e.getLogEntryList();
        HashSet<Long> accessFlush = new HashSet<Long>();
        HashSet accountFlush = new HashSet();
        e.setLogEntryResultList(new ArrayList());
        HourlyDataLogger accessDataLogger = null;
        try {
            accessDataLogger = (HourlyDataLogger)DefaultServerSetup.getEnvironment().lookup("accessDataLogger");
        }
        catch (Exception exception) {
            // empty catch block
        }
        HourlyDataLogger accountingDataLogger = null;
        try {
            accountingDataLogger = (HourlyDataLogger)DefaultServerSetup.getEnvironment().lookup("accountingDataLogger");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<Future> futures = new ArrayList<Future>();
        for (ConnectionLogEntry coord : list) {
            Long hourPart;
            HourlyDataLogger dataLogger = null;
            HashSet<Long> flush = null;
            switch (coord.getLogType()) {
                case 1: {
                    dataLogger = accessDataLogger;
                    flush = accessFlush;
                    break;
                }
                case 2: {
                    dataLogger = accountingDataLogger;
                    flush = accountFlush;
                }
            }
            if (dataLogger == null || !flush.add(hourPart = dataLogger.getHourPart(coord.getTime().getTime()))) continue;
            futures.add(dataLogger.flushHourPart(hourPart));
        }
        try {
            ConcurrentUtils.awaitFutures(futures, (long)4L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            this.logError(ex);
        }
        VoiceDeviceRuntime deviceRuntime = this.application.getDeviceRuntimeMap().get(e.getDeviceId());
        byte[] secret = null;
        if (deviceRuntime != null) {
            secret = Utils.maskNull((String)deviceRuntime.getDevice().getSecret()).getBytes(StandardCharsets.UTF_8);
        }
        for (ConnectionLogEntry coord : list) {
            String key = null;
            switch (coord.getLogType()) {
                case 1: {
                    key = "datalog.radius.access.dir";
                    break;
                }
                case 2: {
                    key = "datalog.radius.accounting.dir";
                    break;
                }
            }
            if (key == null) continue;
            this.getLogger().debug("Coord time: " + coord.getTime());
            RadiusHourlyDataLog dataLog = new RadiusHourlyDataLog(this.setup, key, e.getDeviceId(), TimeUtils.convertDateToCalendar((Date)coord.getTime()));
            this.addToLog(e, dataLog, coord, secret);
            dataLog.close();
        }
    }

    private void addToLog(RequestLogGetEvent e, int id, long[] millisRef, Object packet) {
        if (packet != null) {
            String str = packet.toString();
            StringBuilder buf = new StringBuilder(str.length() + 100);
            str = XMLUtils.prepareString((StringBuilder)buf, (String)str);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Add to result " + id + " " + millisRef[0] + ":\n" + str);
            }
            e.getLogEntryResultList().add(new RequestLogGetEvent.LogEntryResult(id, millisRef[0], str));
        } else {
            this.getLogger().warn("Packet not found!");
        }
    }

    private void addToLog(RequestLogGetEvent e, RadiusHourlyDataLog dataLog, ConnectionLogEntry coord, byte[] secret) {
        this.getLogger().debug("Searching " + coord.getRequestDataLogId() + ":" + coord.getRequestChunkId() + ":" + coord.getRequestPosition());
        RadiusDataLogReader reader = dataLog.find(null, coord.getRequestDataLogId(), coord.getRequestChunkId(), coord.getRequestPosition());
        if (reader != null) {
            long[] millisRef = new long[1];
            RadiusPacket packet = reader.read(millisRef);
            if (coord.getLogType() == 1 && secret != null) {
                try {
                    RadiusUtils.decryptPassword((RadiusPacket)packet, (byte[])secret);
                }
                catch (Exception ex) {
                    this.getLogger().debug(ex.getMessage(), (Throwable)ex);
                }
            }
            this.addToLog(e, coord.getId(), millisRef, packet);
            reader = dataLog.find(reader, coord.getResponseDataLogId(), coord.getResponseChunkId(), coord.getResponsePosition());
            if (reader != null) {
                packet = reader.read(millisRef);
                this.addToLog(e, coord.getId(), millisRef, packet);
            }
        }
    }
}

