/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.export;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.datalog.RadiusDataLogReader;
import ru.bitel.bgbilling.kernel.network.radius.datalog.hourly.RadiusHourlyDataLog;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceNas;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceRadiusProcessor;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class RadiusExport {
    private final VoiceRadiusProcessor processor;
    private final Setup setup;
    private int deviceId = 0;
    private Date timeFrom = null;
    private Date timeTo = null;
    private String phoneFrom = null;
    private String phoneTo = null;
    private String fileName = null;
    private String directory = null;
    private VoiceNas nas;
    int timeZoneDelta;

    public RadiusExport(VoiceRadiusProcessor processor, Setup setup) {
        this.processor = processor;
        this.setup = setup;
    }

    public void export(String command) throws IOException, BGException {
        ArrayList<String> args = new ArrayList<String>();
        Matcher m = Pattern.compile("(?:\\A|[\\s]*)(?:(?:\"(.+?)\")|(?:(.+?)))(?:[\\s]|\\z)").matcher(command);
        while (m.find()) {
            String k = m.group(1);
            if (k == null) {
                k = m.group(2);
            }
            args.add(k);
        }
        this.export((ParameterMap)this.setup, args.toArray(new String[args.size()]));
    }

    protected void export(ParameterMap setup, String[] args) throws IOException, BGException {
        String timeZoneName = null;
        int size = args.length - 1;
        for (int i = 0; i < size; ++i) {
            String k = args[i];
            String v = args[i + 1].trim();
            if ("-d".equals(k)) {
                this.deviceId = Utils.parseInt((String)v);
                continue;
            }
            if ("-h".equals(k)) {
                this.timeFrom = TimeUtils.parseDate((String)v, (String)"yyyy-MM-dd-HH");
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(this.timeFrom);
                ((Calendar)calendar).add(11, 1);
                ((Calendar)calendar).add(14, -1);
                this.timeTo = calendar.getTime();
                continue;
            }
            if ("-tFrom".equals(k)) {
                this.timeFrom = TimeUtils.parseDate((String)v, (String)"yyyy-MM-dd'T'HH:mm:ss");
                continue;
            }
            if ("-tTo".equals(k)) {
                this.timeTo = TimeUtils.parseDate((String)v, (String)"yyyy-MM-dd'T'HH:mm:ss");
                continue;
            }
            if ("-pFrom".equals(k)) {
                this.phoneFrom = v;
                continue;
            }
            if ("-pTo".equals(k)) {
                this.phoneTo = v;
                continue;
            }
            if ("-f".equals(k)) {
                this.fileName = v;
                continue;
            }
            if ("-dir".equals(k)) {
                this.directory = v;
                continue;
            }
            if (!"-tZone".equals(k)) continue;
            timeZoneName = v;
        }
        if (setup == null && Utils.isBlankString((String)this.directory)) {
            throw new BGException("Parameter -dir must not be empty. For example, -dir data/flow");
        }
        if (Utils.isBlankString((String)this.fileName)) {
            throw new BGException("Parameter -f must not be empty.");
        }
        if (this.deviceId <= 0) {
            throw new BGException("Parameter -s must not be empty.");
        }
        if (this.timeFrom == null || this.timeTo == null) {
            throw new BGException("Parameter -h (or -tFrom and -tTo) must not be empty.");
        }
        this.nas = (VoiceNas)this.processor.getNasList().get(this.deviceId);
        this.timeZoneDelta = 0;
        if (!Utils.isEmptyString(timeZoneName)) {
            TimeZone processTimeZone = TimeZone.getTimeZone(timeZoneName);
            TimeZone currentTimeZone = TimeZone.getDefault();
            this.timeZoneDelta = processTimeZone.getRawOffset() - currentTimeZone.getRawOffset();
        }
        this.export();
    }

    private void export() throws IOException {
        SortedSet<Calendar> hours = RadiusExport.getLogHours(this.timeFrom, this.timeTo);
        try (FileWriter fileWriter = new FileWriter(this.fileName);){
            for (Calendar hour : hours) {
                this.exportHour(hour.getTime(), fileWriter);
            }
            fileWriter.flush();
        }
    }

    private void exportHour(Date hour, Writer writer) {
        Setup setup = Setup.getSetup();
        RadiusHourlyDataLog dataLog = new RadiusHourlyDataLog((DefaultServerSetup)setup, "datalog.radius.accounting.dir", this.deviceId, TimeUtils.convertDateToCalendar((Date)hour));
        try {
            RadiusDataLogReader radiusReader;
            while ((radiusReader = (RadiusDataLogReader)dataLog.nextReader(null, true)) != null) {
                RadiusPacket packet;
                long[] millisArr = new long[1];
                while ((packet = radiusReader.read(millisArr)) != null) {
                    long millis = millisArr[0] + (long)this.timeZoneDelta;
                    if (!this.checkpacket(packet, millis)) continue;
                    this.writePacket(packet, millis, writer);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void writePacket(RadiusPacket packet, long millis, Writer writer) throws IOException {
        Date time = new Date(millis);
        writer.write("time:" + TimeUtils.format((Date)time, (String)"dd.MM.yyyy HH:mm:ss") + "\n");
        writer.write(packet + "\n");
    }

    private boolean checkpacket(RadiusPacket packet, long millis) {
        String callingStationId = this.nas.getCallingStationId(packet);
        if (this.phoneFrom != null && !callingStationId.contains(this.phoneFrom)) {
            return false;
        }
        if (this.phoneTo != null && callingStationId.contains(this.phoneTo)) {
            return false;
        }
        return this.timeFrom.getTime() <= millis && this.timeTo.getTime() >= millis;
    }

    protected static SortedSet<Calendar> getLogHours(Date timeFrom, Date timeTo) {
        TreeSet<Calendar> result = new TreeSet<Calendar>();
        Calendar hour = new GregorianCalendar();
        hour.setTime(timeFrom);
        TimeUtils.clear_MIN_MIL_SEC((Calendar)hour);
        GregorianCalendar end = new GregorianCalendar();
        end.setTime(timeTo);
        while (TimeUtils.hourDelta((Calendar)hour, (Calendar)end) >= 0) {
            result.add(hour);
            hour = (Calendar)hour.clone();
            hour.add(11, 1);
        }
        return result;
    }
}

