/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.tariff;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class ServiceSetTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"services");
    private JPanel editor;
    private BGComboBox<IdTitle> serviceCombo;
    private BGTextField regexpTf;
    private Directory serviceDir;
    private String numberRegexp = "";
    private int serviceId;
    private String serviceTitle;
    private JLabel view;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        this.serviceDir = this.getDirManager().getDirectory("services");
    }

    protected JPanel getEditorPanel() throws Exception {
        if (this.editor == null) {
            this.regexpTf = new BGTextField(10);
            this.regexpTf.setHorizontalAlignment(0);
            this.serviceCombo = new BGComboBox();
            this.buildDirectoryCombo(this.serviceDir, (JComboBox)this.serviceCombo);
            GridBagConstraints constraints = new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0);
            this.editor = new JPanel(new GridBagLayout());
            this.editor.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.editor.add((Component)new JLabel("REGEXP B: "), constraints);
            this.editor.add((Component)this.regexpTf, constraints);
            this.editor.add((Component)new JLabel(" => "), constraints);
            this.editor.add((Component)this.serviceCombo, constraints);
        }
        return this.editor;
    }

    public Component getView() throws Exception {
        if (this.view == null) {
            this.view = new JLabel();
            this.view.setIcon(icon);
        }
        this.extractData();
        StringBuilder sb = new StringBuilder();
        if (Utils.notBlankString((String)this.numberRegexp)) {
            sb.append("REGEXP: ").append(this.numberRegexp);
        }
        if (this.serviceId > 0) {
            sb.append(" => ").append(this.serviceTitle);
        }
        this.view.setText(sb.toString());
        return this.view;
    }

    private void extractData() throws Exception {
        Map data = this.getDataInHash();
        this.numberRegexp = (String)data.get("regexp");
        this.serviceId = Utils.parseInt((String)((String)data.get("sid")));
        this.serviceTitle = this.serviceDir.getValue(this.serviceId);
    }

    protected void loadData() throws Exception {
        this.extractData();
        this.regexpTf.setText(this.numberRegexp);
        this.setDirectoryItemSelection((JComboBox)this.serviceCombo, this.serviceId);
    }

    protected void editOk() {
        this.numberRegexp = this.regexpTf.getText();
        this.serviceId = this.getIdFromDirectoryCombo((JComboBox)this.serviceCombo);
        try {
            Pattern.compile(this.numberRegexp);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0440\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435!");
            return;
        }
        super.editOk();
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("sid", String.valueOf(this.serviceId));
        data.put("regexp", this.numberRegexp);
        this.setDataInHash(data);
    }

    public void serializeToXML(Element el) throws Exception {
        this.extractData();
        super.serializeToXML(el);
        el.setAttribute("sid", String.valueOf(this.serviceId));
        el.setAttribute("regexp", this.numberRegexp);
        this.serializeChildsToXML(el);
    }

    public void loadFromXML(Element el) throws Exception {
        this.serviceId = Utils.parseInt((String)el.getAttribute("sid"));
        this.numberRegexp = el.getAttribute("regexp");
        this.serializeData();
        this.saveData();
        this.loadChildsFromXML(el);
    }
}

