/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.VoiceRecordArray;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.VoiceRecordProcessor;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.ErrorTask;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.TarifficationTask;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.DataProcessRecord;

public class VoiceHourSessionProcessor {
    private final VoiceRecordProcessor recordProcessor;
    private final List<BlockingQueue<TarifficationTask>> tarifficationTasks;
    private final List<BlockingQueue<TarifficationTask>> flushTasks;
    private final BlockingQueue<ErrorTask> errorTaskQueue;
    private static TarifficationTask TARIFF_QUEUE_END = new TarifficationTask(-1);
    private static ErrorTask ERROR_QUEUE_END = new ErrorTask();
    private final DataProcessRecord record;
    private final Date hour;

    public VoiceHourSessionProcessor(VoiceRecordProcessor recordProcessor, int tarificatorCount, int arraySize, int errorSize, DataProcessRecord record, Date hour) {
        this.recordProcessor = recordProcessor;
        this.record = record;
        this.hour = hour;
        this.tarifficationTasks = new ArrayList<BlockingQueue<TarifficationTask>>();
        this.flushTasks = new ArrayList<BlockingQueue<TarifficationTask>>();
        this.errorTaskQueue = new ArrayBlockingQueue<ErrorTask>(errorSize);
        for (int i = 0; i < tarificatorCount; ++i) {
            this.tarifficationTasks.add(new ArrayBlockingQueue(arraySize));
            this.flushTasks.add(new ArrayBlockingQueue(arraySize));
        }
    }

    public synchronized VoiceRecordArray takeNextRecordArray(List<TarifficationTask> tarificationTasks) throws InterruptedException {
        VoiceRecordArray array = this.recordProcessor.take();
        if (array == null) {
            for (BlockingQueue<TarifficationTask> queue : this.tarifficationTasks) {
                queue.put(TARIFF_QUEUE_END);
            }
        } else {
            for (BlockingQueue<TarifficationTask> queue : this.tarifficationTasks) {
                TarifficationTask task = new TarifficationTask(array.getId());
                tarificationTasks.add(task);
                queue.put(task);
            }
        }
        return array;
    }

    public void returnRecordArray(VoiceRecordArray array) throws InterruptedException {
        this.recordProcessor.put(array);
    }

    public TarifficationTask takeNextTarifficationTask(int index) throws InterruptedException, BGException {
        if (index >= this.tarifficationTasks.size()) {
            throw new BGException("Index is out of range");
        }
        TarifficationTask result = this.tarifficationTasks.get(index).take();
        if (result == TARIFF_QUEUE_END) {
            result = null;
        }
        return result;
    }

    public void addAddFlushTask(int index, TarifficationTask task) throws InterruptedException, BGException {
        this.flushTasks.get(index).put(task);
    }

    public TarifficationTask takeNextFlushTask(int index) throws InterruptedException, BGException {
        if (index >= this.flushTasks.size()) {
            throw new BGException("Index is out of range");
        }
        TarifficationTask result = this.flushTasks.get(index).take();
        if (result == TARIFF_QUEUE_END) {
            result = null;
        }
        return result;
    }

    public void finishFlushTasks(int index) throws BGException, InterruptedException {
        this.flushTasks.get(index).put(TARIFF_QUEUE_END);
    }

    public void finishErrorTasks() throws InterruptedException {
        this.errorTaskQueue.put(ERROR_QUEUE_END);
    }

    public int getDeviceId() {
        return this.record.getDeviceId();
    }

    public Date getHour() {
        return this.hour;
    }

    public void addErrorTask(ErrorTask errorTask) throws InterruptedException {
        this.errorTaskQueue.put(errorTask);
    }

    public ErrorTask getNextErrorTask() throws InterruptedException {
        ErrorTask task = this.errorTaskQueue.take();
        if (task == ERROR_QUEUE_END) {
            task = null;
        }
        return task;
    }
}

