package ru.bitel.bgbilling.modules.bill.dyn.export;

import java.sql.Connection;

import ru.bitel.bgbilling.modules.bill.common.bean.BillListFilter;
import ru.bitel.bgbilling.modules.bill.common.export.BillDocumentExport;
import ru.bitel.bgbilling.modules.bill.common.export.BillExportSaveFile;
import ru.bitel.bgbilling.modules.bill.server.bean.export.ExportBillUtils;

public class BillCsvExport
	implements BillDocumentExport
{
    @Override
    public String getTitle()
    {
        return "CSV";
    }
    
    @Override
    public BillExportSaveFile getSaveFile()
    {
        return new BillExportSaveFile().setFileExt( "csv" ).setFilterName( "*.csv" );
    }
    
    @Override
    public String getDescription()
    {
        return "Экспорт документов в формате CSV\n\nНабор полей, задается через xslt шаблон";
    }

	@Override
	public String doExport( Connection con, int moduleId, BillListFilter billListFilter, boolean saveOnServer )
		throws Exception
	{
		return new ExportBillUtils( con, moduleId ).doExport( billListFilter, saveOnServer );
	}
}
