/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server;

import java.sql.Connection;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.DigitalTVServiceActivator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.drecrypt.DreCryptCon;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.drecrypt.DreException;
import ru.bitel.common.DateTimeUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class DreCryptServiceActivator
extends DigitalTVServiceActivator {
    private DreCryptCon con = null;
    private static LocalDate INF_TERM_DATE_DEFAULT = LocalDate.of(2049, 12, 31);
    private LocalDate infiniteDate = INF_TERM_DATE_DEFAULT;

    private DreCryptCon getConnection(int serverId, UserCard userCard) throws BGException {
        ParameterMap moduleSetup = this.getModuleSetup(userCard);
        ParameterMap connectionSetup = moduleSetup.sub("server." + serverId + ".");
        this.infiniteDate = connectionSetup.getLocalDate("infinite.date", INF_TERM_DATE_DEFAULT);
        if (this.con == null) {
            try {
                this.con = new DreCryptCon(connectionSetup, serverId, this.sequentialIdManager);
                this.con.connect();
            }
            catch (BGException e) {
                try {
                    this.con.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.con = null;
                throw e;
            }
        }
        return this.con;
    }

    @Override
    public void destroy() {
        if (this.con != null) {
            try {
                this.con.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.con = null;
        }
    }

    @Override
    public void checkSynchronizerBeforeDestroy() throws BGException {
        if (this.con != null) {
            try {
                this.con.waitForResult();
            }
            catch (DreException e) {
                throw new BGMessageException(e.getMessage());
            }
        }
    }

    public DreCryptServiceActivator(ParameterMap moduleSetup, Connection conMaster, Connection conSlave, int mid, Calendar time) throws BGException {
        super(moduleSetup, conMaster, conSlave, mid, time);
    }

    private void smartSynchronize(DreCryptCon con, long cardNumber, List<DigitalTVServiceActivator.CardPacketCodePair> billingSubscription) throws Exception {
        List<DreCryptCon.DreSubscriptionInfo> casSubscription = con.getSubscriptionCurrentState(cardNumber);
        ArrayList<DigitalTVServiceActivator.CardPacketCodePair> toAdd = new ArrayList<DigitalTVServiceActivator.CardPacketCodePair>();
        ArrayList toCancel = new ArrayList();
        DreCryptServiceActivator.subscribeEqualizer(billingSubscription, casSubscription, toAdd, toCancel, new DreCryptSubscriptionComparator(this.infiniteDate));
        if (!toCancel.isEmpty()) {
            if (toCancel.equals(casSubscription)) {
                con.deleteSubscriptionAll(cardNumber);
            } else {
                for (DreCryptCon.DreSubscriptionInfo c : toCancel) {
                    con.deleteSubscription(cardNumber, c.CLASS_ID);
                }
            }
        }
        for (DigitalTVServiceActivator.CardPacketCodePair pairCardPacketPacketCode : toAdd) {
            CardPacket cardPacket = pairCardPacketPacketCode.cardpacket;
            int packetCode = Integer.parseInt(pairCardPacketPacketCode.packetCode);
            Date date1 = cardPacket.getDateFrom();
            Date now = new Date();
            if (date1.getTime() < now.getTime()) {
                date1 = now;
            }
            Date date2 = cardPacket.getDateTo() != null ? cardPacket.getDateTo() : DateTimeUtils.toOldDate((LocalDate)this.infiniteDate);
            date2 = TimeUtils.getEndDay((Date)date2);
            con.addSubscription(cardNumber, packetCode, date1, date2);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult modifyImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        DreCryptCon con = null;
        try {
            con = this.getConnection(0, card);
            List<DigitalTVServiceActivator.CardPacketCodePair> cpcl = this.getCardPacketCodePairList(cardPacketList, false, true);
            this.smartSynchronize(con, card.getNumber(), cpcl);
        }
        catch (Exception ex) {
            this.getLogger().error("Exception in modifyImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        this.getLogger().info("Closing card: " + card.getNumber() + ", cardPackets count: " + cardPacketList.size());
        DreCryptCon con = null;
        try {
            con = this.getConnection(0, card);
            this.smartSynchronize(con, card.getNumber(), Collections.emptyList());
        }
        catch (Exception ex) {
            this.getLogger().error("Exception in cancelImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(long cardNumber) throws BGException {
        this.getLogger().info("Closing card " + cardNumber);
        DreCryptCon con = null;
        try {
            con = this.getConnection(0, null);
            this.smartSynchronize(con, cardNumber, Collections.emptyList());
        }
        catch (Exception ex) {
            this.getLogger().error("Exception in cancelImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult sendMessagesImpl(List<Long> cardNumbers, String title, String message, boolean ismail) throws BGException {
        DreCryptCon con = null;
        try {
            if (cardNumbers == null) {
                con = this.getConnection(0, null);
                con.sendBroadcastInfocas(message);
            } else {
                for (Long cardNumber : cardNumbers) {
                    UserCard userCard = this.userCardManager.getUserCard((long)cardNumber, new Date());
                    con = this.getConnection(0, userCard);
                    con.sendPersonalInfocas(cardNumber, message);
                }
            }
            con.waitForResult();
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        catch (Exception ex) {
            this.getLogger().error("Exception sendMessagesImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f", ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult getSubscribeInfoImpl(long cardNumber) throws BGException {
        StringBuilder infotext = new StringBuilder(64);
        String logline1 = "get subscribe card: " + cardNumber;
        this.getLogger().info(logline1);
        infotext.append(logline1).append("\n");
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, new Date());
            DreCryptCon con = this.getConnection(0, userCard);
            List<DreCryptCon.DreSubscriptionInfo> packages = con.getSubscriptionCurrentState(cardNumber);
            if (packages.size() == 0) {
                infotext.append("none\n");
            } else {
                infotext.append(DreCryptCon.DreSubscriptionInfo.getHeader()).append("\n");
                for (DreCryptCon.DreSubscriptionInfo info : packages) {
                    infotext.append(info.toString()).append("\n");
                }
            }
        }
        catch (Exception ex) {
            infotext.append("error: " + ex.getMessage());
            this.getLogger().error("Exception getSubscribeInfoImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return new DigitalTVServiceActivator.ServiceActivationResult(true, infotext.toString(), null, null);
    }

    @Override
    public DigitalTVServiceActivator.ServiceActivationResult customCommandImpl(long cardNumber, String action, String[] params) throws BGException {
        if ("repeatSubscription".equals(action)) {
            return this._repeatSubscription(cardNumber);
        }
        throw new UnsupportedOperationException();
    }

    private DigitalTVServiceActivator.ServiceActivationResult _repeatSubscription(long cardNumber) throws BGException {
        this.getLogger().info("repeat subscription card: " + cardNumber);
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, new Date());
            DreCryptCon con = this.getConnection(0, userCard);
            con.retrySubscription(cardNumber);
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        catch (Exception ex) {
            this.getLogger().error("Exception repeatSubscription", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    public static class DreCryptSubscriptionComparator
    implements DigitalTVServiceActivator.SubscriptionComparatorForEqualizer<DreCryptCon.DreSubscriptionInfo> {
        private LocalDate infiniteDate;

        public DreCryptSubscriptionComparator(LocalDate infiniteDate) {
            this.infiniteDate = infiniteDate;
        }

        @Override
        public boolean subscriptionEquals(DigitalTVServiceActivator.CardPacketCodePair cardpacket, DreCryptCon.DreSubscriptionInfo casPacket) {
            int bg_packet_code = Utils.parseInt((String)cardpacket.packetCode, (int)-1);
            LocalDate bg_term_date = cardpacket.cardpacket.getDateTo() != null ? DateTimeUtils.toLocalDate((Date)cardpacket.cardpacket.getDateTo()) : this.infiniteDate;
            LocalDate cas_term_date = DateTimeUtils.toLocalDate((Date)casPacket.STOPSEC);
            return bg_term_date.equals(cas_term_date) && bg_packet_code == casPacket.CLASS_ID;
        }
    }
}

