/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client.tariff;

import bitel.billing.module.common.BGControlPanelListSelect;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.model.IdTitle;

public class PacketsAutosyncTariffTreeNode
extends DefaultTariffTreeNode {
    private static final Icon icon = ClientUtils.getIcon((String)"silk/cog_go.png");
    private JLabel view;
    private Directory packetDir;
    private List<Integer> values = new ArrayList<Integer>();
    private boolean on_card_add;
    private boolean on_tariff_change;
    private JCheckBox onCardAdd;
    private JCheckBox onTariffChange;
    private JPanel editor;
    private BGControlPanelListSelect packets;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        this.packetDir = this.getDirManager().getDirectory("packets");
    }

    protected JPanel getEditorPanel() {
        return new JPanel();
    }

    public Component getEditor() throws Exception {
        if (this.editor == null) {
            BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
            okCancel.addActionListener(e -> {
                if (e.getActionCommand().equals("ok")) {
                    this.serializeData();
                    this.saveData();
                }
                this.tree.getViewableTree().stopEditing();
            });
            this.onCardAdd = new JCheckBox("\u041f\u0440\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u043a\u0430\u0440\u0442\u044b");
            this.onTariffChange = new JCheckBox("\u041f\u0440\u0438 \u0441\u043c\u0435\u043d\u0435 \u0442\u0430\u0440\u0438\u0444\u0430");
            this.packets = new BGControlPanelListSelect();
            for (IdTitle di : this.packetDir.getItems()) {
                this.packets.getListModel().addElement(new BGUListItem(di.getId(), di.getTitle()));
            }
            this.editor = new JPanel(new GridBagLayout());
            this.editor.setMinimumSize(new Dimension(400, 400));
            this.editor.setPreferredSize(new Dimension(400, 400));
            this.editor.add((Component)new JLabel("\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u0443\u0435\u043c\u044b\u0435 \u043f\u0430\u043a\u0435\u0442\u044b:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.add((Component)this.packets, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.add((Component)this.onCardAdd, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.add((Component)this.onTariffChange, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.add((Component)okCancel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        }
        return this.editor;
    }

    protected void loadData() throws Exception {
        this._extractData();
        this.getEditor();
        this.packets.setListValues(Utils.toString(this.values));
        this.onCardAdd.setSelected(this.on_card_add);
        this.onTariffChange.setSelected(this.on_tariff_change);
    }

    protected void serializeData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("packets", this.packets.getListValues());
        data.put("on_card_add", this.onCardAdd.isSelected());
        data.put("on_tariff_change", this.onTariffChange.isSelected());
        this.setDataInHash(data);
    }

    public Component getView() throws Exception {
        if (this.view == null) {
            this.view = new JLabel();
            this.view.setIcon(icon);
        }
        this._extractData();
        StringBuilder sb = new StringBuilder();
        sb.append("<html>\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u0443\u0435\u043c\u044b\u0435 \u0441 \u0442\u0430\u0440\u0438\u0444\u043e\u043c \u043f\u0430\u043a\u0435\u0442\u044b (");
        sb.append(Utils.toString((Iterable)new ArrayList<String>(){
            {
                if (PacketsAutosyncTariffTreeNode.this.on_card_add) {
                    this.add("\u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043a\u0430\u0440\u0442\u044b");
                }
                if (PacketsAutosyncTariffTreeNode.this.on_tariff_change) {
                    this.add("\u0441\u043c\u0435\u043d\u0430 \u0442\u0430\u0440\u0438\u0444\u0430");
                }
            }
        }, (String)", "));
        sb.append("):");
        for (Integer code : this.values) {
            String packetTitle = this.packetDir.getValue(code.intValue());
            if (packetTitle == null) continue;
            sb.append("<br> \u2022 ").append(packetTitle);
        }
        this.view.setText(sb.toString());
        return this.view;
    }

    private void _extractData() {
        Map data = this.getDataInHash();
        this.values.clear();
        this.values.addAll(Utils.toIntegerList((String)((String)data.get("packets"))));
        this.on_card_add = Utils.parseBoolean((String)((String)data.get("on_card_add")), (boolean)true);
        this.on_tariff_change = Utils.parseBoolean((String)((String)data.get("on_tariff_change")), (boolean)true);
    }
}

