/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.recalculate.day;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.SessionRecalculateTarifficationManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.TrafficMaxRecalculateManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.TrafficMaxTarifficationManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMax;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxKey;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TrafficMaxRecalculateDayManager
extends TrafficMaxRecalculateManager {
    protected PreparedStatement selectSumMaxTraffsPS;

    public TrafficMaxRecalculateDayManager(Connection con, Date dateFrom, Date dateTo, int moduleId, TrafficMaxManager manager) throws SQLException {
        super(con, dateFrom, dateTo, moduleId, manager);
    }

    @Override
    public void flushContract(int contractId) throws SQLException, BGException {
        InetTariffWorkerContext workerContext = (InetTariffWorkerContext)ServerContext.get();
        if (this.selectSumMaxTraffsPS == null) {
            String query = "SELECT SUM(amountMax),SUM(amount1),SUM(amount2), treeNodeId, maxKey  FROM " + this.trafficMaxDetailTableName + " WHERE contractId = ?  GROUP BY treeNodeId, maxKey";
            this.selectSumMaxTraffsPS = this.con.prepareStatement(query);
        }
        int idx = 1;
        this.selectSumMaxTraffsPS.setInt(idx++, contractId);
        ResultSet rs = this.selectSumMaxTraffsPS.executeQuery();
        HashSet<Long> affectedKeys = new HashSet<Long>();
        HashSet<Long> affectedNodes = new HashSet<Long>();
        while (rs.next()) {
            long amountMax = rs.getLong(1);
            long amount1 = rs.getLong(2);
            long amount2 = rs.getLong(3);
            long treeNodeId = rs.getLong(4);
            long maxKey = rs.getLong(5);
            TrafficMax prevMax = ((TrafficMaxTarifficationManager)this.manager).getPrevMonthTraffic(workerContext, contractId, treeNodeId, maxKey);
            TrafficMax value = new TrafficMax(0, amountMax += prevMax.amountMax, amount1 += prevMax.amount1, amount2 += prevMax.amount2);
            TrafficMaxKey key = new TrafficMaxKey(treeNodeId, maxKey);
            this.updateMaxTraffic(contractId, key, value);
            affectedKeys.add(key.getKey());
            affectedNodes.add(key.getTreeNodeId());
        }
        rs.close();
        if (affectedNodes.size() == 0) {
            affectedNodes.add(-1L);
        }
        if (affectedKeys.size() == 0) {
            affectedKeys.add(-1L);
        }
        this.deleteInvalidMaxTraffs(contractId, affectedKeys, affectedNodes);
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.selectSumMaxTraffsPS != null) {
            this.selectSumMaxTraffsPS.close();
        }
    }

    @Override
    public void removeAllExtraData(Date month, Set<Integer> cids, int idDivizor, int idRemainder, Set<Integer> affectedContracts) throws BGException, SQLException {
        int yy = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(1);
        int mm = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(2) + 1;
        String andCidPartWithAffected = SessionRecalculateTarifficationManager.getSqlAndcidPartWithAffected(cids, affectedContracts);
        String query = " SELECT contractId, treeNodeId, maxKey, SUM(amountMax) as amountMax,SUM(amount1) as amount1,SUM(amount2) as amount2  FROM " + this.trafficMaxDetailTableName + " WHERE 1=1 " + andCidPartWithAffected.replace("cid", "contractId") + " GROUP BY contractId,treeNodeId, maxKey";
        PreparedStatement ps = this.con.prepareStatement(query);
        SessionRecalculateTarifficationManager.setDivizorAndRemainder(ps, 1, cids, idDivizor, idRemainder);
        HashSet<Long> affectedKeys = new HashSet<Long>();
        HashSet<Long> affectedNodes = new HashSet<Long>();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            long amountMax = rs.getLong("amountMax");
            long amount1 = rs.getLong("amount1");
            long amount2 = rs.getLong("amount2");
            long treeNodeId = rs.getLong("treeNodeId");
            long maxKey = rs.getLong("maxKey");
            int contractId = rs.getInt("contractId");
            TrafficMax value = new TrafficMax(0, amountMax, amount1, amount2);
            TrafficMaxKey key = new TrafficMaxKey(treeNodeId, maxKey);
            this.updateMaxTraffic(contractId, key, value);
            affectedKeys.add(key.getKey());
            affectedNodes.add(key.getTreeNodeId());
        }
        rs.close();
        ps.close();
        if (affectedNodes.size() == 0) {
            affectedNodes.add(-1L);
        }
        if (affectedKeys.size() == 0) {
            affectedKeys.add(-1L);
        }
        int idx = 1;
        PreparedStatement deleteInvalidMaxTraffsForContractPS = this.con.prepareStatement("DELETE FROM " + this.trafficMaxTableName + " WHERE 1=1 " + andCidPartWithAffected.replace("cid", "contractId") + " AND yy = ? AND mm = ?  AND ( treeNodeId NOT IN (" + Utils.toString(affectedNodes) + ")  OR maxKey not IN(" + Utils.toString(affectedKeys) + ") )");
        idx = SessionRecalculateTarifficationManager.setDivizorAndRemainder(deleteInvalidMaxTraffsForContractPS, idx, cids, idDivizor, idRemainder);
        deleteInvalidMaxTraffsForContractPS.setInt(idx++, yy);
        deleteInvalidMaxTraffsForContractPS.setInt(idx++, mm);
        deleteInvalidMaxTraffsForContractPS.executeUpdate();
        deleteInvalidMaxTraffsForContractPS.close();
    }
}

