/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.ModelPeriod;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

class BGPeriodModeButton
extends JButton {
    private Calendar dateFrom;
    private Calendar dateTo;
    private JPopupMenu popup;
    ModelPeriod model;

    public BGPeriodModeButton(ModelPeriod model) {
        this.model = model;
        this.setText("-");
        this.setMargin(new Insets(0, 7, 0, 7));
        this.jbInit();
        this.menuInit();
    }

    private void jbInit() {
        this.popup = new JPopupMenu();
        this.popup.setSize(100, 300);
        BGPeriodModeButton th = this;
        this.addActionListener(e -> this.popup.show(th, 0, th.getHeight()));
    }

    public LocalDate getDateFrom() {
        return this.dateFrom != null ? TimeUtils.convertDateToLocalDate(this.dateFrom.getTime()) : null;
    }

    public LocalDate getDateTo() {
        return this.dateTo != null ? TimeUtils.convertDateToLocalDate(this.dateTo.getTime()) : null;
    }

    private void menuInit() {
        ActionListener popupMenuListener = e -> {
            try {
                JMenuItem item = (JMenuItem)e.getSource();
                int mode = Utils.parseInt(item.getName(), -1);
                this.model.setMode(mode);
                int subMode = Utils.parseInt(item.getActionCommand(), -1);
                this.model.setSubMode(subMode);
                this.dateFrom = this.model.getDateSubMode(Calendar.getInstance(), true);
                this.dateTo = this.model.getDateSubMode(Calendar.getInstance(), false);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            this.firePropertyChange("setCalendar", true, false);
        };
        JMenu weekMenu = new JMenu("\u041d\u0435\u0434\u0435\u043b\u044f");
        this.popup.add(weekMenu);
        JMenuItem prevWeek = new JMenuItem("\u041f\u0440\u043e\u0448\u043b\u0430\u044f");
        prevWeek.addActionListener(popupMenuListener);
        prevWeek.setName(String.valueOf(1));
        prevWeek.setActionCommand(String.valueOf(1));
        weekMenu.add(prevWeek);
        JMenuItem currentWeek = new JMenuItem("\u0422\u0435\u043a\u0443\u0449\u0430\u044f");
        currentWeek.addActionListener(popupMenuListener);
        currentWeek.setName(String.valueOf(1));
        currentWeek.setActionCommand(String.valueOf(2));
        weekMenu.add(currentWeek);
        JMenuItem nextWeek = new JMenuItem("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f");
        nextWeek.addActionListener(popupMenuListener);
        nextWeek.setName(String.valueOf(1));
        nextWeek.setActionCommand(String.valueOf(3));
        weekMenu.add(nextWeek);
        JMenu monthMenu = new JMenu("\u041c\u0435\u0441\u044f\u0446");
        this.popup.add(monthMenu);
        JMenuItem prevMonth = new JMenuItem("\u041f\u0440\u043e\u0448\u043b\u044b\u0439");
        prevMonth.addActionListener(popupMenuListener);
        prevMonth.setName(String.valueOf(2));
        prevMonth.setActionCommand(String.valueOf(4));
        monthMenu.add(prevMonth);
        JMenuItem currentMonth = new JMenuItem("\u0422\u0435\u043a\u0443\u0449\u0438\u0439");
        currentMonth.addActionListener(popupMenuListener);
        currentMonth.setName(String.valueOf(2));
        currentMonth.setActionCommand(String.valueOf(5));
        monthMenu.add(currentMonth);
        JMenuItem nextMonth = new JMenuItem("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439");
        nextMonth.addActionListener(popupMenuListener);
        nextMonth.setName(String.valueOf(2));
        nextMonth.setActionCommand(String.valueOf(6));
        monthMenu.add(nextMonth);
        JMenu yearMenu = new JMenu("\u0413\u043e\u0434");
        this.popup.add(yearMenu);
        JMenuItem prevYear = new JMenuItem("\u041f\u0440\u043e\u0448\u043b\u044b\u0439");
        prevYear.addActionListener(popupMenuListener);
        prevYear.setName(String.valueOf(3));
        prevYear.setActionCommand(String.valueOf(7));
        yearMenu.add(prevYear);
        JMenuItem currentYear = new JMenuItem("\u0422\u0435\u043a\u0443\u0449\u0438\u0439");
        currentYear.addActionListener(popupMenuListener);
        currentYear.setName(String.valueOf(3));
        currentYear.setActionCommand(String.valueOf(8));
        yearMenu.add(currentYear);
        JMenuItem nextYear = new JMenuItem("C\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439");
        nextYear.addActionListener(popupMenuListener);
        nextYear.setName(String.valueOf(3));
        nextYear.setActionCommand(String.valueOf(9));
        yearMenu.add(nextYear);
    }
}

