/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin.resource;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public abstract class CategoryEditor
extends BGPanel {
    private int parentId;
    private BGTextField titleTf = new BGTextField();
    private JTextArea commentTa = new JTextArea();
    protected String actionPrefix;

    public CategoryEditor() {
        this.jbInit();
        this.init();
    }

    public void setParentId(int id) {
        this.parentId = id;
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.titleTf, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JScrollPane(this.commentTa), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        this.add((Component)okCancel, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        this.setPreferredSize(new Dimension(100, 250));
        this.setMinimumSize(new Dimension(100, 250));
    }

    protected abstract void init();

    @Override
    public void setData() throws Exception {
        this.titleTf.setText("");
        this.commentTa.setText("");
        if (!this.id.equals("0")) {
            Request req = new Request();
            req.setModule(this.module);
            req.setAction(this.actionPrefix + "Get");
            req.setModuleId(this.getModuleId());
            req.setAttribute("id", this.id);
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus(doc)) {
                this.titleTf.setText(XMLUtils.selectText(doc, "//category/@title"));
                this.commentTa.setText(ClientUtils.linesToString(XMLUtils.selectElement(doc, "//category/comment")));
            }
        }
    }

    private void stopEdit(boolean save) {
        if (save) {
            String title = this.titleTf.getText();
            String comment = this.commentTa.getText();
            if (Utils.isBlankString(title)) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438!");
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setAction(this.actionPrefix + "Update");
            request.setModuleId(this.getModuleId());
            request.setAttribute("id", this.id);
            request.setAttribute("parent_id", this.parentId);
            request.setAttribute("title", title);
            request.setAttribute("comment", comment);
            this.setVisible(!ClientUtils.checkStatus(this.getDocument(request)));
        }
        this.setVisible(false);
    }
}

