/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import java.awt.Dimension;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import javax.swing.JTextField;
import ru.bitel.common.Utils;

public class DateTextField
extends JTextField {
    private Calendar calendar = null;

    public DateTextField() {
        this.setEditable(false);
        this.setHorizontalAlignment(0);
        this.setMinimumSize(new Dimension(75, 21));
        this.setPreferredSize(new Dimension(75, 21));
        this.setMaximumSize(new Dimension(75, 21));
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        if (calendar == null) {
            this.setText("");
        } else {
            int dd = calendar.get(5);
            int mm = calendar.get(2) + 1;
            int yy = calendar.get(1);
            this.setText((dd < 10 ? "0" + dd : "" + dd) + "." + (mm < 10 ? "0" + mm : "" + mm) + "." + yy);
        }
    }

    public void setCalendar(String str) {
        GregorianCalendar calendar = null;
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, ".");
            int dd = Utils.parseInt(st.nextToken(), 0);
            int mm = Utils.parseInt(st.nextToken(), 0) - 1;
            int yy = Utils.parseInt(st.nextToken(), 0);
            if (dd > 0 && dd < 32 && mm >= 0 && mm < 12 && yy > 0) {
                calendar = new GregorianCalendar(yy, mm, dd);
            }
        }
        this.setCalendar(calendar);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }
}

