/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.client.filter;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGComboBoxWithSearch;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.contract.AddressUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.FocusManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.model.Page;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;
import ru.bitel.oss.kernel.entity.client.filter.FilterEntityAttrDefaultPanel;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttr;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrAddress;

public class FilterEntityAttrAddressPanel
extends FilterEntityAttrDefaultPanel<FilterEntityAttrAddress> {
    protected BGComboBox<ComboBoxItem> street = new BGComboBox();
    protected BGComboBoxWithSearch house = new BGComboBoxWithSearch(0);
    protected IntTextField pod_TF = new IntTextField();
    protected BGTextField flat_TF = new BGTextField();
    protected BGTextField room_TF = new BGTextField();
    private JPanel topPanel = null;
    protected int selectedStreetId = -1;
    protected int selectedHouseId = -1;
    Iterable<Element> houses = null;

    public FilterEntityAttrAddressPanel(Supplier<Map<Integer, List<EntitySpecAttr>>> parameterTypeMap) {
        super(EntitySpecAttrType.ADDRESS.getCode(), parameterTypeMap);
    }

    @Override
    protected void jbInit() {
        super.jbInit();
        final JTextComponent editor = (JTextComponent)this.street.getEditor().getEditorComponent();
        final JTextComponent editorHouse = (JTextComponent)this.house.getEditor().getEditorComponent();
        editor.addKeyListener(new KeyAdapter(){
            private String previousEnteredText = "";

            @Override
            public void keyReleased(KeyEvent e) {
                editorHouse.setText("");
                FilterEntityAttrAddressPanel.this.flat_TF.setText("");
                FilterEntityAttrAddressPanel.this.room_TF.setText("");
                FilterEntityAttrAddressPanel.this.selectedHouseId = -1;
                FilterEntityAttrAddressPanel.this.selectedStreetId = -1;
                if (e.getKeyChar() == '\n') {
                    FilterEntityAttrAddressPanel.this.streetEntered();
                    return;
                }
                if (e.getKeyChar() == '\u001b') {
                    editor.setText("");
                    FilterEntityAttrAddressPanel.this.street.hidePopup();
                    return;
                }
                if (e.getKeyCode() != 40 && e.getKeyCode() != 38) {
                    int caretPosition = editor.getCaretPosition();
                    String enteredText = editor.getText();
                    if (!enteredText.equals(this.previousEnteredText)) {
                        if (enteredText.length() > 2) {
                            FilterEntityAttrAddressPanel.this.fillStreetList(enteredText);
                            FilterEntityAttrAddressPanel.this.street.hidePopup();
                            FilterEntityAttrAddressPanel.this.street.showPopup();
                            editor.setCaretPosition(caretPosition);
                        }
                        if (enteredText.length() <= 2) {
                            FilterEntityAttrAddressPanel.this.initStreetPopup(enteredText);
                            FilterEntityAttrAddressPanel.this.street.hidePopup();
                        }
                    }
                    this.previousEnteredText = enteredText;
                }
            }
        });
        this.street.addActionListener(e -> {
            int streetId = Utils.parseInt(this.street.getSelectedId());
            if (streetId > 0) {
                this.streetEntered();
            }
        });
        editorHouse.addKeyListener(new KeyAdapter(){
            private String previousEnteredText = "";

            @Override
            public void keyReleased(KeyEvent e) {
                FilterEntityAttrAddressPanel.this.selectedHouseId = -1;
                FilterEntityAttrAddressPanel.this.flat_TF.setText("");
                FilterEntityAttrAddressPanel.this.room_TF.setText("");
                if (e.getKeyChar() == '\n') {
                    FilterEntityAttrAddressPanel.this.houseEntered();
                    return;
                }
                if (e.getKeyChar() == '\u001b') {
                    editorHouse.setText("");
                    FilterEntityAttrAddressPanel.this.house.hidePopup();
                    return;
                }
                if (e.getKeyCode() != 40 && e.getKeyCode() != 38) {
                    int caretPosition = editorHouse.getCaretPosition();
                    String enteredText = editorHouse.getText();
                    if (!enteredText.equals(this.previousEnteredText)) {
                        FilterEntityAttrAddressPanel.this.fillHouseList(enteredText);
                        FilterEntityAttrAddressPanel.this.house.hidePopup();
                        FilterEntityAttrAddressPanel.this.house.showPopup();
                        editorHouse.setCaretPosition(caretPosition);
                    }
                    this.previousEnteredText = enteredText;
                }
            }
        });
        this.house.addActionListener(e -> {
            if (((long)e.getModifiers() & 0x10L) > 0L) {
                this.houseEntered();
            }
        });
        this.house.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("fillText")) {
                this.fillHouseList(String.valueOf(e.getNewValue()));
            } else if (e.getPropertyName().equals("textEntered")) {
                this.houseEntered();
            } else if (e.getPropertyName().equals("resetAllText")) {
                this.selectedHouseId = -1;
                this.flat_TF.setText("");
                this.room_TF.setText("");
            }
        });
        this.flat_TF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                FilterEntityAttrAddressPanel.this.room_TF.setText("");
                if (e.getKeyChar() == '\n') {
                    FocusManager.getCurrentManager().focusNextComponent();
                    return;
                }
            }
        });
        this.room_TF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    FocusManager.getCurrentManager().focusNextComponent();
                    return;
                }
            }
        });
        JPanel addressParams = new JPanel(new GridBagLayout());
        addressParams.add((Component)new JLabel("\u0423\u043b\u0438\u0446\u0430:"), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 3, 3, 3), 0, 0));
        addressParams.add(this.street, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 3, 3, 3), 0, 0));
        addressParams.add((Component)new JLabel("\u0414\u043e\u043c [\u0434\u0440\u043e\u0431\u044c]:"), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 3, 3, 3), 0, 0));
        addressParams.add((Component)this.house, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 3, 3, 3), 0, 0));
        addressParams.add((Component)new JLabel("\u041a\u0432\u0430\u0440\u0442\u0438\u0440\u0430:"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 3, 3, 3), 0, 0));
        addressParams.add((Component)this.flat_TF, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 3, 3, 3), 0, 0));
        addressParams.add((Component)new JLabel("\u043a\u043e\u043c."), new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 3, 3), 0, 0));
        addressParams.add((Component)this.room_TF, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 3, 3), 0, 0));
        this.street.setEditable(true);
        this.house.setEditable(true);
        this.topPanel = new JPanel(new GridBagLayout());
        this.topPanel.setBorder(new BGTitleBorder(" \u0423\u0441\u043b\u043e\u0432\u0438\u0435 "));
        this.topPanel.add((Component)addressParams, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.wrapBorder(this.paramsList, " \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b ");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.paramsList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initStreetPopup(String streetTitle) {
        this.street.removeAllItems();
        this.street.addItem(new ComboBoxItem(0, streetTitle));
    }

    private void fillStreetList(String streetTitle) {
        this.tryCall(() -> {
            String searchStreet;
            String searchCity;
            int idx = streetTitle.indexOf(40);
            if (idx >= 0) {
                searchCity = streetTitle.substring(idx + 1);
                searchStreet = streetTitle.substring(0, idx);
            } else {
                searchStreet = streetTitle;
                searchCity = null;
            }
            AddressService addressService = ((ClientContext)this.getContext()).getWebService(AddressService.class, 0);
            List streetList = addressService.streetSearch(0, searchStreet.replaceAll("\\(", " "), searchCity, new Page(1, 20));
            this.initStreetPopup(streetTitle);
            for (Street street : streetList) {
                this.street.addItem(new ComboBoxItem(street.getId(), street.getTitle() + " (" + street.getCity().getTitle() + ")"));
            }
        });
    }

    private void fillHouseList(String houseTitle) {
        this.house.removeAllItems();
        if (this.houses != null) {
            ComboBoxItem selected = null;
            for (Element s : this.houses) {
                String houseItemTitle = XMLUtils.getAttribute(s, "house");
                if (houseTitle == null || houseItemTitle == null || !houseItemTitle.contains(houseTitle)) continue;
                ComboBoxItem comboBoxItem = new ComboBoxItem(Integer.valueOf(XMLUtils.getAttribute(s, "id")), houseItemTitle);
                this.house.addItem(comboBoxItem);
                if (!houseItemTitle.equalsIgnoreCase(houseTitle)) continue;
                selected = comboBoxItem;
            }
            if (selected != null) {
                this.house.setSelectedItem(selected);
            } else {
                this.house.insertItemAt(new ComboBoxItem(0, houseTitle), 0);
                this.house.setSelectedIndex(0);
            }
        } else {
            this.house.addItem(new ComboBoxItem(0, houseTitle));
            this.house.setSelectedIndex(0);
        }
    }

    private void streetEntered() {
        this.tryCall(() -> {
            if (!this.street.getSelectedId().equals("")) {
                this.selectedStreetId = Integer.valueOf(this.street.getSelectedId());
                FocusManager.getCurrentManager().focusNextComponent();
                this.fillListByHouses(this.selectedStreetId);
            }
        });
    }

    private void houseEntered() {
        if (!this.house.getSelectedId().equals("")) {
            this.selectedHouseId = Integer.valueOf(this.house.getSelectedId());
            FocusManager.getCurrentManager().focusNextComponent();
        }
    }

    private void fillListByHouses(int streetId) throws Exception {
        if (streetId > 0) {
            Request request = new Request().setModule("admin").setAction("FilterHouse").setAttribute("street", streetId);
            Document doc = ((ClientContext)this.getContext()).getDocument(request);
            this.houses = XMLUtils.selectElements(doc, "data/list/item");
        }
    }

    @Override
    public FilterEntityAttrAddress getFilter() {
        if (this.selectedStreetId > 0 && this.selectedHouseId > 0) {
            int cityId = Utils.parseInt((String)this.street.getSelectedItem().get("cityId"), 0);
            return new FilterEntityAttrAddress(this.paramsList.getSelectedIds(), cityId, this.selectedStreetId, this.selectedHouseId, AddressUtil.getHouse(((ComboBoxItem)this.house.getSelectedItem()).toString()), AddressUtil.getHouseFrac(((ComboBoxItem)this.house.getSelectedItem()).toString()), (int)this.pod_TF.getValue(), this.flat_TF.getText(), this.room_TF.getText());
        }
        return null;
    }

    @Override
    public void clearFilter() {
        BGSwingUtilites.clearFields(this.street, this.house, this.pod_TF, this.flat_TF, this.room_TF);
        this.selectedStreetId = 0;
        this.selectedHouseId = 0;
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> this.updateParameters());
    }
}

