/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.security.server;

import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.ActionExpressionData;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.ActionExpressionDataDao;
import ru.bitel.bgbilling.kernel.container.security.server.HttpAction;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleInfo;
import ru.bitel.bgbilling.kernel.container.security.server.ServiceAction;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.kernel.module.server.event.ModulesChangedEvent;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ModuleActionMap {
    private static final Logger logger = LogManager.getLogger();
    private Map<String, ModuleInfo> moduleInfoMap = this.loadModulesActions();
    private volatile Module kernelModule;
    private volatile Map<String, Module> moduleMap;
    private volatile List<Module> moduleList;

    ModuleActionMap() {
        try {
            EventProcessor.getInstance().addListener(new EventListener<ModulesChangedEvent>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void notify(ModulesChangedEvent e, EventListenerContext ctx) throws BGException {
                    if (e.isNeedReloadActionsXml()) {
                        1 var3_3 = this;
                        synchronized (var3_3) {
                            ModuleActionMap.this.moduleInfoMap.clear();
                            ModuleActionMap.this.moduleInfoMap = ModuleActionMap.this.loadModulesActions();
                        }
                    }
                    ModuleActionMap.this.reload();
                }
            }, ModulesChangedEvent.class);
        }
        catch (BGException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.reload();
    }

    public static ModuleActionMap getInstance() {
        return InstanceHolder.instance;
    }

    Module getModule(String moduleId) {
        return this.moduleMap.get(moduleId);
    }

    Module getKernel() {
        return this.kernelModule;
    }

    List<Module> getModuleList() {
        return this.moduleList;
    }

    Map<String, ModuleInfo> getModuleInfoMap() {
        return this.moduleInfoMap;
    }

    public ModuleAction getModuleAction(String moduleId, int id) {
        Module module = this.moduleMap.get(moduleId);
        if (module == null) {
            return null;
        }
        return module.moduleInfo.moduleActionMap.get(id);
    }

    public ModuleAction getModuleAction(String moduleId, String id, String[] moduleTitle) {
        Module module = this.moduleMap.get(moduleId);
        if (module == null) {
            return null;
        }
        moduleTitle[0] = module.title;
        return module.moduleInfo.moduleActionMap.get(id);
    }

    synchronized void reload() {
        logger.info("Load modules");
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            this.moduleMap = this.loadModules(con);
            this.kernelModule = this.moduleMap.get("0");
            this.moduleList = new ArrayList<Module>(this.moduleMap.values());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private Map<String, ModuleInfo> loadModulesActions() {
        HashMap<String, ModuleInfo> result = new HashMap<String, ModuleInfo>();
        try {
            this.loadModulesActions0(result);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    private void loadModulesActions0(Map<String, ModuleInfo> moduleMap) throws Exception {
        logger.info("Load module actions");
        File actionsCatalog = new File("actions");
        if (!actionsCatalog.exists() || !actionsCatalog.isDirectory()) {
            logger.error("Catalog BGBillingServer/actions not found!");
            return;
        }
        List<Object> actionExpressionDatas = new ArrayList();
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            actionExpressionDatas = new ActionExpressionDataDao(con).list();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        for (File file : actionsCatalog.listFiles()) {
            String moduleName;
            if (file.isDirectory() || !(moduleName = file.getName()).endsWith(".xml") || moduleName.endsWith(".custom.xml")) continue;
            int pos = moduleName.lastIndexOf(".");
            if (pos >= 0) {
                moduleName = moduleName.substring(0, pos);
            }
            HashMap<String, ModuleAction> moduleActionMap = new HashMap<String, ModuleAction>();
            ArrayList<HttpAction> webActionList = new ArrayList<HttpAction>();
            HashMap<String, List<ServiceAction>> serviceActionMap = new HashMap<String, List<ServiceAction>>();
            File customFile = new File("actions" + File.separatorChar + moduleName + ".custom.xml");
            Document doc = XMLUtils.parseDocument((InputSource)new InputSource(new FileInputStream(file)));
            Document customDoc = customFile.exists() ? XMLUtils.parseDocument((InputSource)new InputSource(new FileInputStream(customFile))) : null;
            for (Element actionElement : XMLUtils.selectElements((Node)doc, (String)"//action")) {
                try {
                    String id = actionElement.getAttribute("id");
                    if (Utils.notBlankString((String)id)) {
                        this.updateCustomAttr(XMLUtils.selectElement((Node)customDoc, (String)("//action[@id=" + id + "]")), actionElement);
                    }
                    HttpAction action = new HttpAction(actionElement);
                    moduleActionMap.put(action.getId(), action);
                    webActionList.add(action);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            String moduleNameF = moduleName;
            actionExpressionDatas.forEach(a -> {
                if (a.getComponentId().equals(moduleNameF)) {
                    ServiceAction action = new ServiceAction((ActionExpressionData)((Object)a));
                    moduleActionMap.put(action.getId(), action);
                    ArrayList<ServiceAction> list = (ArrayList<ServiceAction>)serviceActionMap.get(action.name);
                    if (list == null) {
                        list = new ArrayList<ServiceAction>();
                        serviceActionMap.put(action.name, list);
                    }
                    list.add(action);
                }
            });
            for (Element serviceElement : XMLUtils.selectElements((Node)doc, (String)"//service")) {
                try {
                    String id = serviceElement.getAttribute("id");
                    if (Utils.notBlankString((String)id)) {
                        this.updateCustomAttr(XMLUtils.selectElement((Node)customDoc, (String)("//service[@id=" + id + "]")), serviceElement);
                    }
                    ServiceAction action = new ServiceAction(serviceElement);
                    moduleActionMap.put(action.getId(), action);
                    ArrayList<ServiceAction> list = (ArrayList<ServiceAction>)serviceActionMap.get(action.name);
                    if (list == null) {
                        list = new ArrayList<ServiceAction>();
                        serviceActionMap.put(action.name, list);
                    }
                    list.add(action);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            moduleMap.put(moduleName, new ModuleInfo(moduleActionMap, webActionList, serviceActionMap));
        }
    }

    private void updateCustomAttr(Element custom, Element element) {
        if (custom != null) {
            for (String name : new String[]{"name", "mask", "operation", "title"}) {
                String value = custom.getAttribute(name);
                if (!Utils.notBlankString((String)value)) continue;
                element.setAttribute(name, value);
            }
        }
    }

    private Map<String, Module> loadModules(Connection con) throws Exception {
        HashMap<String, Module> result = new HashMap<String, Module>();
        ModuleManager moduleManager = new ModuleManager(con);
        for (Map.Entry<String, ModuleInfo> e : this.moduleInfoMap.entrySet()) {
            String moduleName = e.getKey();
            ModuleInfo moduleInfo = e.getValue();
            if ("kernel".equals(moduleName)) {
                result.put("0", new Module("\u042f\u0434\u0440\u043e", moduleInfo));
                continue;
            }
            BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin(moduleName);
            if (plugin != null) {
                result.put("p" + plugin.getPluginUID(), new Module(plugin.getName(), moduleInfo));
                continue;
            }
            for (BGModule module : moduleManager.getModules(moduleName)) {
                result.put(String.valueOf(module.getId()), new Module(module.getTitle(), moduleInfo));
            }
        }
        return result;
    }

    static class InstanceHolder {
        static ModuleActionMap instance = new ModuleActionMap();

        InstanceHolder() {
        }
    }

    final class Module {
        final String title;
        final ModuleInfo moduleInfo;

        public Module(String title, ModuleInfo moduleInfo) {
            this.title = title;
            this.moduleInfo = moduleInfo;
        }
    }
}

