/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree.npay;

import bitel.billing.module.common.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.TariffPanelEditor;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVar;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarType;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;

public class MonthModeCostTariffTreeNode
extends DefaultTariffTreeNode {
    protected static Icon icon = ClientUtils.getIcon((String)"coin");
    protected JLabel view;
    protected String cost;
    protected String costMode;
    protected String type;
    protected FloatTextField costTf;
    protected ButtonGroup costButtonGroup;
    protected JRadioButton constCostMode;
    protected JRadioButton varCostMode;
    private List<TariffVar> vars = new ArrayList<TariffVar>();
    protected BGUComboBox<KeyValue> typeCombo = new BGUComboBox();
    protected BGUComboBox<TariffVar> tariffVars = new BGUComboBox();
    private List<KeyValue> types = Arrays.asList(new KeyValue("0", "\u0431\u0435\u0437\u0443\u0441\u043b\u043e\u0432\u043d\u043e"), new KeyValue("1", "\u043f\u0440\u043e\u043f\u043e\u0440\u0446. \u043f\u0435\u0440\u0438\u043e\u0434\u0443"), new KeyValue("2", "\u043f\u0440\u043e\u043f\u043e\u0440\u0446. \u043e\u0431\u044a\u0435\u043c\u0443"), new KeyValue("3", "\u043a\u0430\u043a \u0432\u044b\u0433\u043e\u0434\u043d\u0435\u0435"), new KeyValue("4", "\u043f\u0440\u043e\u043f\u043e\u0440\u0446. \u0442\u0430\u0440\u0438\u0444\u0443"));

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        try {
            TariffVar tariffVar = new TariffVar();
            tariffVar.setId(0);
            tariffVar.setTitle("---");
            this.vars.add(tariffVar);
            if (tree.getParent() instanceof TariffPanelEditor) {
                int moduleId = this.getModuleId(parent);
                TariffPanelEditor tariffPanelEditor = (TariffPanelEditor)((Object)tree.getParent());
                this.vars.addAll(tariffPanelEditor.getTariffService().tariffVars(TariffVarType.COST, Arrays.asList(tariffPanelEditor.getTariffPlanId(), 0)).stream().filter(a -> a.getModuleId() == moduleId || a.getModuleId() == 0).collect(Collectors.toList()));
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    protected void initEdit() {
        if (this.costTf == null) {
            this.costTf = new FloatTextField(10);
            this.typeCombo.setData(this.types);
            this.constCostMode = new JRadioButton("\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0438\u0437 \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u044b", true);
            this.constCostMode.setActionCommand("const");
            this.varCostMode = new JRadioButton("\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0438\u0437 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439");
            this.varCostMode.setActionCommand("var");
            this.costButtonGroup = new ButtonGroup();
            this.costButtonGroup.add(this.constCostMode);
            this.costButtonGroup.add(this.varCostMode);
            this.tariffVars.setData(this.vars);
        }
    }

    @Override
    protected JPanel getEditorPanel() {
        this.initEdit();
        JPanel edit = new JPanel(new GridBagLayout());
        edit.add((Component)this.getCostConstPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        edit.add((Component)this.getCostVarPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 10), 0, 0));
        edit.add((Component)this.getModePanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 10), 0, 0));
        return edit;
    }

    private JPanel getModePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.typeCombo, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getCostConstPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.constCostMode, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.costTf, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getCostVarPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.varCostMode, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.tariffVars, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    @Override
    public Component getView() {
        this.extractData();
        StringBuffer title = new StringBuffer();
        if ("const".equals(this.costMode)) {
            title.append("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c: ");
            title.append(this.cost);
        } else if ("var".equals(this.costMode)) {
            title.append("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0438\u0437 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439: ");
            title.append((String)(this.tariffVar != null ? "< " + this.tariffVar.getTitle() + " [" + this.getTariffVarValue(this.tariffVar) + "] >" : "???"));
        }
        title.append("; \u0420\u0435\u0436\u0438\u043c \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f: ");
        title.append(this.types.stream().filter(a -> a.getKey().equals(this.type)).findAny().orElse(new KeyValue("", "")).getValue());
        if (this.view == null) {
            this.view = new JLabel(icon, 2);
        }
        this.view.setText(title.toString());
        return this.view;
    }

    protected void extractData() {
        Map<String, String> data = this.getDataInHash();
        this.cost = data.getOrDefault("cost", "0.00");
        this.costMode = data.getOrDefault("costMode", "const");
        this.type = Utils.maskNull((String)data.get("type"));
        int tariffVarId = Utils.parseInt((String)data.getOrDefault("tariffVarId", "0"), (int)0);
        this.tariffVar = this.vars.isEmpty() ? null : this.vars.stream().filter(a -> a.getId() == tariffVarId || a.getTopId() == tariffVarId).findFirst().orElse(this.vars.get(0));
    }

    @Override
    protected void loadData() {
        this.extractData();
        this.costButtonGroup.getElements().asIterator().forEachRemaining(a -> {
            if (a.getActionCommand().equals(this.costMode)) {
                a.setSelected(true);
            }
        });
        this.costTf.setText(this.cost);
        this.typeCombo.setSelectedItem((Object)this.types.stream().filter(a -> a.getKey().equals(this.type)).findFirst().orElse(this.types.get(0)));
        this.tariffVars.setSelectedItem((Object)this.tariffVar);
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("cost", this.costTf.getText());
        data.put("costMode", this.costButtonGroup.getSelection().getActionCommand());
        data.put("tariffVarId", String.valueOf(((TariffVar)this.tariffVars.getSelectedItem()).getId()));
        data.put("type", ((KeyValue)this.typeCombo.getSelectedItem()).getKey());
        this.setDataInHash(data);
    }

    @Override
    protected void editOk() {
        if ("var".equals(this.costButtonGroup.getSelection().getActionCommand()) && ((TariffVar)this.tariffVars.getSelectedItem()).getId() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e");
            return;
        }
        super.editOk();
    }
}

