/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import jakarta.activation.DataSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.BGClientInit;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.bean.Writable;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.io.Base64;
import ru.bitel.common.security.EyelessHostnameVerifier;
import ru.bitel.common.security.EyelessSSLSocketFactory;

public class TransferData {
    private static final String ERROR_MSG = "Unexpected IO exception occured when posting the request!";
    private static final String ENCODING = "UTF-8";
    private URL url = null;
    private byte[] inBytes;
    private boolean debug = false;
    private String userName = null;
    private String userPswd = null;
    private Map<String, String> cookies = new HashMap<String, String>();
    private String str = "";
    private String encoding = "UTF-8";
    private String contentType = null;
    private String error = null;
    private String message = null;
    private long reqStartTime = 0L;
    private static final Pattern charsetPattern;
    private static final String CHARACTER_SURROGATE_REGEXP = "&#55296;|&#55297;|&#55298;|&#55299;|&#553\\d\\d;|&#554\\d\\d;|&#555\\d\\d;|&#556\\d\\d;|&#557\\d\\d;|&#558\\d\\d;|&#559\\d\\d;|&#56\\d\\d\\d;|&#570\\d\\d;|&#571\\d\\d;|&#572\\d\\d;|&#573\\d\\d;";
    private static final Pattern CHARACTER_ENTITY_INVALID_REGEXP;

    public TransferData(URL url) {
        this.url = url;
        this.debug = Boolean.valueOf(System.getProperty("bgbilling.transfer.debug", "false"));
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setUser(String name, String pswd) {
        this.userName = name;
        this.userPswd = pswd;
    }

    public void postData(Request request) throws IOException {
        this.postData(request, this.debug);
    }

    private HttpURLConnection doConnection(Request request) throws IOException {
        String userAndPswd = this.userName + ":" + this.userPswd;
        HttpURLConnection con = (HttpURLConnection)this.url.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        con.setRequestProperty("Authorization", "Basic " + Base64.encode(userAndPswd));
        con.setRequestProperty("bgbilling-client-version", BGClientInit.getClientVersion());
        for (String string : this.cookies.keySet()) {
            String value = this.cookies.get(string);
            con.setRequestProperty("cookie", string + "=" + value);
        }
        con.setDoOutput(true);
        con.setDoInput(true);
        PrintStream ps = new PrintStream(con.getOutputStream(), true);
        for (String key : request.keys()) {
            ps.print(key);
            ps.print('=');
            Object o = request.getValue(key);
            if (o instanceof Writable) {
                Writable writable = (Writable)o;
                if (writable.getWriterClass() == OutputStream.class) {
                    writable.write(ps);
                } else if (writable.getWriterClass() == Writer.class) {
                    writable.write(new URLWriter(ps));
                }
            } else {
                ps.print(Utils.htmlEncode(request.getValue(key).toString(), ENCODING));
            }
            ps.print('&');
        }
        if (request.isSendServerURL()) {
            ps.print("serverURL");
            ps.print("=");
            ps.print(Utils.htmlEncode(this.url.toString(), ENCODING));
        }
        if (ps.checkError()) {
            throw new IOException(ERROR_MSG);
        }
        if (this.debug) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String key : request.keys()) {
                stringBuilder.append(key);
                stringBuilder.append('=');
                Object o = request.getValue(key);
                if (o instanceof Writable) {
                    stringBuilder.append("...");
                } else {
                    stringBuilder.append(Utils.htmlEncode(request.getValue(key).toString(), ENCODING));
                }
                stringBuilder.append('&');
            }
            if (request.isSendServerURL()) {
                stringBuilder.append("serverURL");
                stringBuilder.append("=");
                stringBuilder.append(Utils.htmlEncode(this.url.toString(), ENCODING));
            }
            System.err.println(this.url + "?" + (stringBuilder.length() < 20000 ? stringBuilder.toString() : stringBuilder.substring(0, 20000)));
            Object var5_8 = null;
        }
        request.clear();
        return con;
    }

    private void parseCookieEtc(HttpURLConnection con) {
        String key;
        this.contentType = null;
        this.encoding = ENCODING;
        int n = 1;
        while ((key = con.getHeaderFieldKey(n)) != null) {
            if (key.equalsIgnoreCase("Set-Cookie")) {
                int i;
                String cookie = con.getHeaderField(n);
                if (cookie != null && (i = cookie.indexOf(59)) > -1) {
                    cookie = cookie.substring(0, i);
                }
                if (cookie != null && (i = cookie.indexOf(61)) > -1) {
                    String name = cookie.substring(0, i);
                    String value = cookie.substring(i + 1);
                    this.cookies.put(name, value);
                }
            } else if (key.equalsIgnoreCase("Content-Type")) {
                this.contentType = con.getHeaderField(n);
                Matcher m = charsetPattern.matcher(this.contentType);
                if (m.find()) {
                    this.encoding = m.group(1);
                }
            }
            ++n;
        }
        this.error = con.getHeaderField("bgbilling-error");
        this.message = con.getHeaderField("bgbilling-message");
    }

    public void postData(Request request, boolean debug) throws IOException {
        this.reqStartTime = System.currentTimeMillis();
        HttpURLConnection con = this.doConnection(request);
        this.str = "";
        if (con.getResponseCode() == 200) {
            this.checkVersion(con);
            this.parseCookieEtc(con);
            int b = 0;
            Vector<byte[]> blocks = new Vector<byte[]>();
            int length = 0;
            byte[] in = new byte[1024];
            BufferedInputStream bis = new BufferedInputStream(con.getInputStream());
            while ((b = bis.read(in, 0, 1024)) != -1) {
                length += b;
                byte[] block = new byte[b];
                System.arraycopy(in, 0, block, 0, b);
                blocks.add(block);
            }
            bis.close();
            con.disconnect();
            this.inBytes = new byte[length];
            int pos = 0;
            for (int i = 0; i < blocks.size(); ++i) {
                byte[] block = (byte[])blocks.get(i);
                System.arraycopy(block, 0, this.inBytes, pos, block.length);
                pos += block.length;
            }
            this.str = new String(this.inBytes, this.encoding);
        }
    }

    private void checkVersion(HttpURLConnection con) {
        String serverVersion = con.getHeaderField("bgbilling-server-version");
        if (serverVersion != null && BGClientBase.getFrame() != null) {
            BGClientBase.getFrame().checkClientVersion(serverVersion);
        }
    }

    public InputStream getInputStream(Request request) throws Exception {
        this.reqStartTime = System.currentTimeMillis();
        final HttpURLConnection con = this.doConnection(request);
        if (con.getResponseCode() == 200) {
            this.checkVersion(con);
            this.parseCookieEtc(con);
            this.str = "";
            BufferedInputStream bis = new BufferedInputStream(con.getInputStream()){

                @Override
                public void close() throws IOException {
                    super.close();
                    con.disconnect();
                }
            };
            return bis;
        }
        return null;
    }

    public HTTPDataSource getDataSource(Request request) throws Exception {
        this.reqStartTime = System.currentTimeMillis();
        HttpURLConnection con = this.doConnection(request);
        if (con.getResponseCode() == 200) {
            this.checkVersion(con);
            this.parseCookieEtc(con);
            this.str = "";
            return new HTTPDataSource(con, this.contentType, this.error != null);
        }
        return null;
    }

    public Document getDocument(boolean debug) {
        Document doc = null;
        try {
            int len = this.str.length();
            if (debug) {
                long time = System.currentTimeMillis() - this.reqStartTime;
                String message = "[l=" + len + ",t=" + (double)time / 1000.0 + "] ";
                int debugMessageMaxLength = Utils.parseInt(System.getProperty("debug.message.max.length", "1500"), 1500);
                if (len > debugMessageMaxLength) {
                    message = message + this.str.substring(0, debugMessageMaxLength);
                    message = message + "...";
                } else {
                    message = message + this.str;
                }
                System.err.println(message);
            }
            this.str = TransferData.replaceCharacterEntity(this.str);
            doc = XMLUtils.parseDocument(new InputSource(new StringReader(this.str.toString())));
        }
        catch (Exception ex) {
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 xml \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430", ex);
        }
        return doc;
    }

    private static String replaceCharacterEntity(String xml) {
        return CHARACTER_ENTITY_INVALID_REGEXP.matcher(xml).replaceAll("?");
    }

    public Document getDocument() {
        return this.getDocument(this.debug);
    }

    public byte[] getBytes() {
        return this.inBytes;
    }

    public String getString() {
        return this.str;
    }

    public String getMessage() {
        return this.message;
    }

    public String getError() {
        return this.error;
    }

    public int uploadFile(String handler, BGServerFile bgServerFile, File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            int n = this.uploadFile(handler, bgServerFile, inputStream);
            return n;
        }
    }

    public int uploadFile(String handler, BGServerFile bgServerFile, InputStream inputStream) throws IOException {
        if (this.debug) {
            System.err.println("uploadFile " + handler);
        }
        String userAndPswd = this.userName + ":" + this.userPswd;
        HttpURLConnection con = (HttpURLConnection)new URL(this.url.toString() + "/upload").openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/octet-stream");
        con.setRequestProperty("Authorization", "Basic " + Base64.encode(userAndPswd));
        con.setRequestProperty("bgbilling-client-version", BGClientInit.getClientVersion());
        con.setRequestProperty("bgbilling-handler", handler);
        JSONObject jsonObject = new JSONObject();
        BGServerFile.toJSON(bgServerFile, jsonObject);
        con.setRequestProperty("bgbilling-file-info", Base64.encode(jsonObject.toString(), "utf-8"));
        for (String name : this.cookies.keySet()) {
            String value = this.cookies.get(name);
            con.setRequestProperty("cookie", name + "=" + value);
        }
        con.setDoOutput(true);
        con.setDoInput(true);
        OutputStream outputStream = con.getOutputStream();
        Utils.flush(inputStream, outputStream);
        int id = -1;
        if (con.getResponseCode() == 200) {
            this.checkVersion(con);
            this.parseCookieEtc(con);
            id = Utils.parseInt(con.getHeaderField("bgbilling-file-id"), -1);
        }
        outputStream.close();
        con.disconnect();
        if (this.debug) {
            System.err.println("<- file id = " + id);
        }
        return id;
    }

    public BGServerFile downloadFile(String handler, int fileId, int contractId, File file) throws IOException {
        if (this.debug) {
            System.err.println("downloadFile " + handler + "; fileId=" + fileId);
        }
        String userAndPswd = this.userName + ":" + this.userPswd;
        HttpURLConnection con = (HttpURLConnection)new URL(this.url.toString() + "/download").openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("Authorization", "Basic " + Base64.encode(userAndPswd));
        con.setRequestProperty("bgbilling-client-version", BGClientInit.getClientVersion());
        con.setRequestProperty("bgbilling-handler", handler);
        con.setRequestProperty("bgbilling-file-id", String.valueOf(fileId));
        con.setRequestProperty("bgbilling-contract-id", String.valueOf(contractId));
        for (String name : this.cookies.keySet()) {
            String value = this.cookies.get(name);
            con.setRequestProperty("cookie", name + "=" + value);
        }
        con.setDoOutput(false);
        con.setDoInput(true);
        BGServerFile bgServerFile = null;
        if (con.getResponseCode() == 200) {
            this.checkVersion(con);
            this.parseCookieEtc(con);
            String bgbillingFileInfo = con.getHeaderField("bgbilling-file-info");
            if (bgbillingFileInfo != null) {
                bgServerFile = new BGServerFile();
                BGServerFile.fromJSON(new JSONObject(Base64.decode(bgbillingFileInfo)), bgServerFile);
            }
            FileOutputStream outputStream = new FileOutputStream(file);
            InputStream inputStream = con.getInputStream();
            Utils.flush(inputStream, outputStream);
            inputStream.close();
            outputStream.close();
        }
        con.disconnect();
        if (this.debug) {
            System.err.println("<- file id = " + bgServerFile.getId());
        }
        return bgServerFile;
    }

    static {
        try {
            HttpsURLConnection.setDefaultSSLSocketFactory(EyelessSSLSocketFactory.INSTANCE);
            HttpsURLConnection.setDefaultHostnameVerifier(EyelessHostnameVerifier.INSTANCE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        charsetPattern = Pattern.compile("charset=([\\w\\d\\-]+)[\\s;]*.*$");
        CHARACTER_ENTITY_INVALID_REGEXP = Pattern.compile("&#0;|&#1;|&#2;|&#3;|&#4;|&#5;|&#6;|&#7;|&#8;|&#11;|&#12;|&#14;|&#15;|&#16;|&#17;|&#18;|&#19;|&#20;|&#21;|&#22;|&#23;|&#24;|&#25;|&#26;|&#27;|&#28;|&#29;|&#30;|&#31;|&#55296;|&#55297;|&#55298;|&#55299;|&#553\\d\\d;|&#554\\d\\d;|&#555\\d\\d;|&#556\\d\\d;|&#557\\d\\d;|&#558\\d\\d;|&#559\\d\\d;|&#56\\d\\d\\d;|&#570\\d\\d;|&#571\\d\\d;|&#572\\d\\d;|&#573\\d\\d;");
    }

    private class URLWriter
    extends Writer {
        private int i = 0;
        protected StringBuilder buf = new StringBuilder(2042);
        private PrintStream out;

        public URLWriter(PrintStream o) {
            this.out = o;
        }

        @Override
        public void flush() {
            if (this.buf.length() > 0) {
                this.out.print(Utils.htmlEncode(this.buf.toString(), TransferData.ENCODING));
                this.buf.setLength(0);
                this.i = 0;
            }
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }

        public void fl() {
            if (this.i >= 1024) {
                this.out.print(Utils.htmlEncode(this.buf.toString(), TransferData.ENCODING));
                this.buf.setLength(0);
                this.i = 0;
            }
        }

        @Override
        public void write(int c) {
            this.buf.append((char)c);
            ++this.i;
            this.fl();
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            this.buf.append(cbuf, off, len);
            this.i += len;
            this.fl();
        }

        @Override
        public void write(String str) {
            this.buf.append(str);
            this.i += str.length();
            this.fl();
        }

        @Override
        public void write(String str, int off, int len) {
            this.buf.append(str.substring(off, off + len));
            this.i += len;
            this.fl();
        }
    }

    public class HTTPDataSource
    implements DataSource {
        private String contentType;
        private InputStream is;
        private boolean error = false;

        private HTTPDataSource(final HttpURLConnection con, String contentType, boolean error) {
            this.contentType = contentType;
            this.error = error;
            try {
                this.is = new BufferedInputStream(con.getInputStream()){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        con.disconnect();
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430", e);
            }
        }

        public boolean isError() {
            return this.error;
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() throws IOException {
            return this.is;
        }

        public String getName() {
            return null;
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean isContentType(String contentType) {
            return contentType == null && this.contentType == null || this.contentType != null && this.contentType.contains(contentType);
        }

        public boolean isContentTypeTextXml() {
            return this.isContentType("text/xml");
        }
    }
}

