/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import ru.bitel.bgbilling.kernel.event.MessageHandler;
import ru.bitel.bgbilling.kernel.event.common.Event;

abstract class PoolEventList<E extends Event>
extends Event {
    private static final long serialVersionUID = -822408077195720838L;
    @XmlAttribute(name="class")
    final Class<E> clazz;
    @XmlElements(value={@XmlElement(name="i")})
    final List<E> list;
    final transient MessageHandler messageHandler;

    protected PoolEventList() {
        this.clazz = null;
        this.list = null;
        this.messageHandler = null;
    }

    public PoolEventList(int moduleId, int pluginId, Class<E> clazz, List<E> list, MessageHandler messageHandler) {
        super(moduleId, pluginId, -1, -1);
        this.clazz = clazz;
        this.list = list;
        this.messageHandler = messageHandler;
    }

    @Override
    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        if (this.messageHandler != null) {
            this.messageHandler.prepareMessage(message);
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(50).append("Event[");
        result.append("pool:").append(this.clazz.getName());
        result.append("] timestamp: ").append(this.getTimestamp());
        result.append("; moduleId: ").append(this.getModuleId());
        result.append("; pluginId: ").append(this.getPluginId());
        result.append("; cid: ").append(this.getContractId());
        result.append("; scid: ").append(this.getSuperContractId());
        result.append("; userId: ").append(this.getUserId());
        this.toString(result);
        return result.toString();
    }
}

