/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class ServiceConfigRule
extends ServiceConfigTabbedPanel {
    private BGTable table = new BGTable();
    private JPanel editorPanel = new JPanel();
    private IntTextField number = new IntTextField();
    private BGTextField toNumber = new BGTextField();
    private BGTextField toNumber164 = new BGTextField();
    private BGControlPanelPeriodNoB period = new BGControlPanelPeriodNoB();
    private BGComboBox<ComboBoxItem> service = new BGComboBox();
    private BGComboBox<ComboBoxItem> source = new BGComboBox();
    private BGTextField outPorts = new BGTextField();
    private BGTextField categories = new BGTextField();
    private JTextArea comment = new JTextArea();
    private BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
    private int currentID = 0;

    public ServiceConfigRule() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.table.setHeader(this.rb_name, this.moduleDoc, "rules");
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editorPanel.setLayout(new GridBagLayout());
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new GridBagLayout());
        leftPanel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440 \u043f\u0440\u0430\u0432\u0438\u043b\u0430"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        leftPanel.add((Component)this.number, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        leftPanel.add((Component)new JLabel("REGEXP #B"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        leftPanel.add((Component)this.toNumber, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        leftPanel.add((Component)new JLabel("REGEXP #B.164"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        leftPanel.add((Component)this.toNumber164, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        leftPanel.add((Component)new JLabel("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 (\u0447\u0435\u0440\u0435\u0437 ,)"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        leftPanel.add((Component)this.categories, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this.service, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.period, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.setBorder((Border)new BGTitleBorder(" \u0423\u0441\u043b\u0443\u0433\u0430 "));
        leftPanel.add((Component)panel, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a "));
        panel.add((Component)new JLabel("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.source, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0435 \u043f\u043e\u0440\u0442\u044b (\u0447\u0435\u0440\u0435\u0437 ,)"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.outPorts, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        leftPanel.add((Component)panel, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPanel.add((Component)leftPanel, new GridBagConstraints(0, 0, 1, 1, 0.4, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.comment);
        panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
        scrollPane.setMinimumSize(new Dimension(200, 100));
        scrollPane.setPreferredSize(new Dimension(200, 100));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.editorPanel.add((Component)panel, new GridBagConstraints(1, 0, 1, 1, 0.6, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.editorPanel.add((Component)this.okCancel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editorPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 "));
        this.add(this.editorPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ServiceConfigRule.this.editItem();
                }
            }
        });
        this.okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        this.editorPanel.setVisible(false);
        this.editorPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ServiceConfigRule.this.setData();
            }
        });
    }

    public void startEdit() {
        Request request = new Request();
        request.setModule("load");
        request.setModuleId(this.getModuleId());
        request.setAction("SourceList");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildComboBox(this.source, (Node)XMLUtils.getElement((Document)doc, (String)"list"), null);
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.source.getModel();
        ComboBoxItem item = new ComboBoxItem(0, "\u041b\u044e\u0431\u043e\u0439");
        model.insertElementAt(item, 0);
        model.setSelectedItem(item);
        try {
            DefaultComboBoxModel<ComboBoxItem> comboBoxModel = new DefaultComboBoxModel<ComboBoxItem>();
            for (Service service : ((ModuleService)this.getContext().getPort(ModuleService.class, 0)).moduleUsedServiceList(this.getModuleId())) {
                comboBoxModel.addElement(new ComboBoxItem(service.getId(), service.getGuiTitle()));
            }
            this.service.setModel(comboBoxModel);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        if (this.currentID > 0) {
            request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("RuleGet");
            request.setAttribute("id", this.currentID);
            doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                Element rule = XMLUtils.getElement((Document)doc, (String)"rule");
                this.number.setText(rule.getAttribute("number"));
                this.toNumber.setText(rule.getAttribute("toNumber"));
                this.toNumber164.setText(rule.getAttribute("toNumber164"));
                this.categories.setText(rule.getAttribute("categories"));
                this.period.setDateString1(rule.getAttribute("date1"));
                this.period.setDateString2(rule.getAttribute("date2"));
                this.outPorts.setText(rule.getAttribute("outPorts"));
                this.comment.setText(rule.getAttribute("comment"));
                ClientUtils.setComboBoxSelection(this.service, (Object)rule.getAttribute("serviceId"));
                ClientUtils.setComboBoxSelection(this.source, (Object)rule.getAttribute("sourceId"));
            }
        } else {
            this.number.setText("");
            this.toNumber.setText("");
            this.toNumber164.setText("");
            this.categories.setText("");
            this.period.setDateCalendar1((Calendar)new GregorianCalendar());
            this.period.setDateCalendar2(null);
            this.outPorts.setText("");
            this.comment.setText("");
        }
        this.editorPanel.setVisible(true);
    }

    public void stopEdit(boolean save) {
        if (save) {
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("RuleUpdate");
            request.setAttribute("id", this.currentID);
            request.setAttribute("number", this.number.getText());
            request.setAttribute("toNumber", this.toNumber.getText());
            request.setAttribute("toNumber164", this.toNumber164.getText());
            request.setAttribute("categories", this.categories.getText());
            ComboBoxItem item = (ComboBoxItem)this.service.getSelectedItem();
            request.setAttribute("serviceId", item.getObject());
            if (Utils.isEmptyString((String)this.period.getDateString1())) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
                return;
            }
            request.setAttribute("date1", this.period.getDateString1());
            request.setAttribute("date2", this.period.getDateString2());
            item = (ComboBoxItem)this.source.getSelectedItem();
            request.setAttribute("sourceId", item.getObject());
            request.setAttribute("outPorts", this.outPorts.getText());
            request.setAttribute("comment", this.comment.getText());
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.editorPanel.setVisible(false);
            }
        } else {
            this.editorPanel.setVisible(false);
        }
    }

    public void deleteItem() {
        this.currentID = Utils.parseInt((String)ClientUtils.getRowId((BGTable)this.table), (int)-1);
        if (this.currentID > 0 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0440\u0430\u0432\u0438\u043b\u043e?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("RuleDelete");
            request.setAttribute("id", this.currentID);
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.setData();
            }
        }
    }

    public void newItem() {
        this.currentID = 0;
        this.startEdit();
    }

    public void editItem() {
        this.currentID = Utils.parseInt((String)ClientUtils.getRowId((BGTable)this.table), (int)-1);
        if (this.currentID > 0) {
            this.startEdit();
        }
    }

    public void setData() {
        Request req = new Request();
        req.setModule(this.module);
        req.setModuleId(this.getModuleId());
        req.setAction("Rule");
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.table.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
        }
    }
}

