/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sberbank.server.bean;

import java.io.FileInputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.BGTransactionType;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.common.bean.emuns.PaymentType;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.sberbank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.sberbank.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.sberbank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.sberbank.server.bean.OAuthToken;
import ru.bitel.bgbilling.modules.sberbank.server.bean.OrderStatus;
import ru.bitel.bgbilling.modules.sberbank.server.event.SberbankAutopaymentSumEvent;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.KeyStoreUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    private static final String PARAM_ORDER_ID = "orderId";

    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "sberbank_transaction");
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("status", "status");
        this.fields.put("createDatetime", "create_date");
        this.fields.put("transactionDatetime", "transaction_date");
        this.fields.put("sum", "sum");
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        String transactionType = rs.getString("transaction_type");
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("id"))).setContractId(rs.getInt("contract_id"))).setContractTitle(rs.getString("contract_title"))).setPaymentId(rs.getInt("payment_id"))).setCreateDate((Date)rs.getTimestamp("create_date"))).setTransactionId(rs.getString("order_id"))).setTransactionDate((Date)rs.getTimestamp("transaction_date"))).setStatus(rs.getString("status"))).setParameters(rs.getString("params"))).setSum(rs.getBigDecimal("sum"))).setAutopayment(rs.getBoolean("autopayment"))).setTransactionType(transactionType != null ? BGTransactionType.valueOf((String)transactionType) : BGTransactionType.CARD)).build();
    }

    protected String getQueryById() {
        return "SELECT pt.*, c.title AS contract_title FROM " + this.tableName + " AS pt LEFT JOIN contract AS c ON c.id=pt.contract_id WHERE pt.id=?";
    }

    public boolean update(Transaction transaction, TransactionStatus newTransactionStatus) throws SQLException {
        Objects.requireNonNull(transaction);
        Objects.requireNonNull(newTransactionStatus);
        boolean result = false;
        StringBuilder query = new StringBuilder("UPDATE ").append(this.tableName).append(" SET ").append("status=?").append(" WHERE ").append("status=? AND id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
            int index = 1;
            ps.setString(index++, newTransactionStatus.getCode());
            ps.setString(index++, transaction.getStatus());
            ps.setInt(index++, transaction.getId());
            boolean bl = result = ps.executeUpdate() > 0;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("updateTransactionStatus: " + result);
                this.getLogger().debug("\ttransaction.getId() = " + transaction.getId());
                this.getLogger().debug("\ttransaction.getStatus() = " + transaction.getStatus());
                this.getLogger().debug("\tnewTransactionStatus = " + newTransactionStatus.getCode());
            }
            if (result) {
                transaction.setStatus(newTransactionStatus.getCode());
            }
        }
        return result;
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        String querySet = "contract_id=?, payment_id=?, create_date=?, transaction_date=?, order_id=?, status=?, params=?, sum=?, autopayment=?, transaction_type=?";
        try (PreparedStatement ps = this.prepareStatement((Id)transaction, querySet);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setInt(index++, transaction.getPaymentId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            ps.setString(index++, transaction.getTransactionId());
            ps.setString(index++, transaction.getStatus());
            ps.setString(index++, transaction.getParameters());
            ps.setBigDecimal(index++, transaction.getSum());
            ps.setBoolean(index++, transaction.isAutopayment());
            ps.setString(index++, transaction.getTransactionType().name());
            this.executeUpdate((Id)transaction, index, ps);
        }
    }

    public void doCheckRequest(int contractId, boolean autopaymentTransaction) throws Exception {
        Page page = new Page(1, this.moduleSetup.getInt("sberbank.transaction.status.check.count", 5));
        String[] sort = new String[]{"createDate:1"};
        SearchParam searchParam = new SearchParam().setContractId(contractId).setStatus(TransactionStatus.NEW.getCode()).setType((PaymentType)(autopaymentTransaction ? PaymentType.AUTO : null));
        SearchResult searchResult = new SearchResult(page, sort);
        this.searchTransaction(searchResult, searchParam);
        for (Transaction transaction : searchResult.getList()) {
            this.doCheckRequest(transaction);
        }
    }

    public boolean doCheckRequest(Transaction transaction) throws Exception {
        String orderId = transaction.getTransactionId();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("sberbankTransactionId = " + transaction.getId());
            this.getLogger().debug("sberbankTransactionOrderId = " + orderId);
        }
        if (orderId == null) {
            if (System.currentTimeMillis() - transaction.getCreateDate().getTime() > 86400000L) {
                transaction.setStatus(TransactionStatus.ERROR.getCode());
                this.update(transaction);
            }
            return false;
        }
        boolean error = false;
        if (transaction.getTransactionType().equals((Object)BGTransactionType.CARD)) {
            error = this.checkTransactionStatus(transaction, transaction.isAutopayment());
        } else if (transaction.getTransactionType().equals((Object)BGTransactionType.QR_SBP)) {
            error = this.checkSbpTransactionStatus(transaction);
        }
        if (error) {
            transaction.setStatus(TransactionStatus.ERROR.getCode());
            transaction.setTransactionDate(new Date());
            this.update(transaction);
        }
        return true;
    }

    public boolean checkTransactionStatus(Transaction transaction, boolean autopaymentTransaction) throws Exception {
        String orderId = transaction.getTransactionId();
        HashMap<String, Object> requestProperties = new HashMap<String, Object>();
        String statusUrl = null;
        String query = null;
        String outputText = null;
        String method = null;
        String mode = this.moduleSetup.get("sberbank.mode", "1");
        if ("1".equals(mode)) {
            statusUrl = this.moduleSetup.get("sberbank.rest.order.status.url", "https://securepayments.sberbank.ru/payment/rest/getOrderStatusExtended.do");
            if ("https://securepayments.sberbank.ru/payment/rest/getOrderStatus.do".equalsIgnoreCase(statusUrl)) {
                this.getLogger().error("\u041f\u0420\u041e\u0412\u0415\u0420\u041a\u0410 \u0421\u0422\u0410\u0422\u0423\u0421\u0410 \u041e\u0422\u041c\u0415\u041d\u0415\u041d\u0410!!! \u0423\u0421\u0422\u0410\u0420\u0415\u0412\u0428\u0415\u0415 \u0417\u041d\u0410\u0427\u0415\u041d\u0418\u0415 \u041f\u0410\u0420\u0410\u041c\u0415\u0422\u0420\u0410: sberbank.rest.order.status.url=" + statusUrl);
                return true;
            }
            try {
                orderId = URLEncoder.encode(orderId, "UTF-8");
            }
            catch (Exception ex) {
                this.logError(ex);
                return true;
            }
            method = "GET";
            query = "language=" + this.moduleSetup.get("sberbank.rest.language", "ru") + "&orderId=" + orderId + "&userName=" + this.getRestUserName(autopaymentTransaction) + "&password=" + this.getRestUserPswd(autopaymentTransaction);
        } else if ("2".equals(mode)) {
            JSONObject json = new JSONObject();
            json.put("userName", (Object)this.getEcommUserName());
            json.put("password", (Object)this.getEcommUserPswd());
            json.put(PARAM_ORDER_ID, (Object)orderId);
            json.put("language", (Object)this.moduleSetup.get("sberbank.ecomm.language", "ru"));
            method = "POST";
            statusUrl = this.moduleSetup.get("sberbank.ecomm.order.status.url", "https://ecommerce.sberbank.ru/ecomm/gw/partner/api/v1/getOrderStatusExtended.do");
            requestProperties.put("Content-Type", "application/json");
            requestProperties.put("x-idempotencyKey", transaction.getContractId() + "_" + transaction.getId());
            outputText = json.toString();
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("URL: " + statusUrl);
            this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: query = {}; outputText = {}", query, outputText);
        }
        StringBuilder resultJson = null;
        try {
            resultJson = this.doConnection(statusUrl + (String)(query != null ? "?" + query : ""), method, true, outputText, requestProperties);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\t\u041e\u0442\u0432\u0435\u0442: " + String.valueOf(resultJson));
            }
        }
        catch (Exception ex) {
            this.getLogger().error(ex.getMessage());
        }
        boolean error = false;
        JSONObject resultJsonObject = null;
        if (resultJson != null) {
            resultJsonObject = new JSONObject(resultJson.toString());
            String errorCode = resultJsonObject.optString("errorCode", null);
            if (errorCode == null || "0".equals(errorCode)) {
                String orderStatus = resultJsonObject.optString("orderStatus", null);
                if (!(orderStatus == null || OrderStatus.AUTHORIZATION.getCode().equals(orderStatus) || OrderStatus.REGISTER.getCode().equals(orderStatus) || OrderStatus.APPROVED.getCode().equals(orderStatus))) {
                    if (OrderStatus.DEPOSITED.getCode().equals(orderStatus)) {
                        String status = transaction.getStatus();
                        if (!status.equals(TransactionStatus.NEW.getCode()) && !status.equals(TransactionStatus.ERROR.getCode())) {
                            this.getLogger().error("SKIP Transaction for ID = {} has status {}", (Object)transaction.getId(), (Object)status);
                        } else if (transaction.getPaymentId() > 0) {
                            this.getLogger().error("SKIP Transaction for ID = {} has paymentId > 0", (Object)transaction.getId());
                        } else {
                            this.addTransactionPayment(transaction, TransactionManager.getParamString((JSONObject)resultJsonObject));
                            JSONObject bindingInfoJsonObject = resultJsonObject.optJSONObject("bindingInfo");
                            if (bindingInfoJsonObject != null) {
                                PeriodWithTime period;
                                AutopaymentManager autopaymentManager;
                                Autopayment autopayment;
                                String clientId = bindingInfoJsonObject.optString("clientId", null);
                                String bindingId = bindingInfoJsonObject.optString("bindingId", null);
                                if (clientId != null && bindingId != null && (autopayment = (autopaymentManager = new AutopaymentManager(this.con, this.moduleId)).getCurrentAutopayment(transaction.getContractId())) != null && (period = autopayment.getPeriod()) != null && period.getDateFrom() == null) {
                                    period.setLocalDateTimeFrom(LocalDateTime.now());
                                    autopayment.setAccessToken(bindingId);
                                    autopaymentManager.updateAutopayment(autopayment);
                                }
                            }
                        }
                    } else if (OrderStatus.REVERSED.getCode().equals(orderStatus) || OrderStatus.REFUNDED.getCode().equals(orderStatus)) {
                        if (!transaction.getStatus().equals(TransactionStatus.APPROVED.getCode())) {
                            this.getLogger().error("Transaction for ID = " + transaction.getId() + " has status != 'ok'");
                        } else if (transaction.getPaymentId() < 1) {
                            this.getLogger().error("Transaction for ID = " + transaction.getId() + " has paymentId < 1");
                        } else {
                            PaymentDao paymentDao = new PaymentDao(this.con);
                            Payment payment = (Payment)paymentDao.get(transaction.getPaymentId());
                            paymentDao.delete(transaction.getPaymentId());
                            transaction.setStatus(TransactionStatus.ERROR.getCode());
                            transaction.setPaymentId(0);
                            this.update(transaction);
                            if (payment != null) {
                                try (BalanceUtils bu = new BalanceUtils(this.con);){
                                    bu.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
                                }
                                EventProcessor.getInstance().publishAfterCommit((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum().negate()));
                            }
                        }
                    } else {
                        error = true;
                    }
                }
            } else {
                error = true;
            }
        }
        TransactionManager.addTransactionParameters(transaction, TransactionManager.getParamString(resultJsonObject));
        return error;
    }

    public boolean checkSbpTransactionStatus(Transaction transaction) throws Exception {
        boolean error = false;
        OAuthToken oAuthToken = this.getOAuthToken(this.moduleSetup.get("sberbank.auth.token.scope.status", "https://api.sberbank.ru/qr/order.status"));
        if (oAuthToken == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0442\u043e\u043a\u0435\u043d\u0430");
        }
        String result = this.sbpOrderStatus(oAuthToken.getAccessToken(), transaction);
        JSONObject resultJson = new JSONObject(result);
        if ("000000".equals(resultJson.optString("error_code"))) {
            String orderState = resultJson.optString("order_state");
            if ("CREATED".equals(orderState)) {
                int timeout = this.moduleSetup.getInt("sberbank.transaction.status.error.timeout", 60);
                if (System.currentTimeMillis() - transaction.getCreateDate().getTime() > (long)(timeout * 60) * 1000L) {
                    this.getLogger().error("SKIP Transaction for ID={} has orderState={} timeout>{} min", new Object[]{transaction.getId(), orderState, timeout});
                    error = true;
                }
            } else if ("PAID".equals(orderState)) {
                String status = transaction.getStatus();
                if (!status.equals(TransactionStatus.NEW.getCode()) && !status.equals(TransactionStatus.ERROR.getCode())) {
                    this.getLogger().error("SKIP Transaction for ID={} has status {}", (Object)transaction.getId(), (Object)status);
                } else if (transaction.getPaymentId() > 0) {
                    this.getLogger().error("Transaction for ID = " + transaction.getId() + " has paymentId > 0");
                } else {
                    this.addTransactionPayment(transaction, TransactionManager.getParamString((JSONObject)resultJson));
                }
            } else if ("REVERSED".equals(orderState) || "REFUNDED".equals(orderState)) {
                if (!transaction.getStatus().equals(TransactionStatus.APPROVED.getCode())) {
                    this.getLogger().error("Transaction for ID = " + transaction.getId() + " has status != 'ok'");
                    error = true;
                } else if (transaction.getPaymentId() < 1) {
                    this.getLogger().error("Transaction for ID = " + transaction.getId() + " has paymentId < 1");
                    error = true;
                } else {
                    PaymentDao paymentDao = new PaymentDao(this.con);
                    Payment payment = (Payment)paymentDao.get(transaction.getPaymentId());
                    paymentDao.delete(transaction.getPaymentId());
                    transaction.setStatus(TransactionStatus.ERROR.getCode());
                    transaction.setPaymentId(0);
                    this.update(transaction);
                    if (payment != null) {
                        try (BalanceUtils bu = new BalanceUtils(this.con);){
                            bu.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
                        }
                        EventProcessor.getInstance().publishAfterCommit((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum().negate()));
                    }
                }
            } else {
                error = true;
            }
        } else {
            error = true;
        }
        TransactionManager.addTransactionParameters(transaction, TransactionManager.getParamString((JSONObject)resultJson));
        return error;
    }

    public Transaction newTransaction(int contractId, BigDecimal sum, boolean autopaymentTransaction, BGTransactionType transactionType) throws Exception {
        Date date = new Date();
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setSum(sum)).setContractId(contractId)).setCreateDate(date)).setTransactionDate(date)).setAutopayment(autopaymentTransaction)).setTransactionType(transactionType)).build();
        this.update(transaction);
        return transaction;
    }

    public Transaction registerOrder(int contractId, String contractTitle, String customerAddress, BigDecimal sum, Map<String, Object> dataMap, boolean autopaymentTransaction, boolean requestBindingId, String returnUrl) throws Exception {
        if (autopaymentTransaction || requestBindingId) {
            SberbankAutopaymentSumEvent event = new SberbankAutopaymentSumEvent(this.moduleId, contractId, sum);
            BigDecimal newSum = ((SberbankAutopaymentSumEvent)EventProcessor.getInstance().request((QueueEvent)event)).getSum();
            if (newSum != null) {
                sum = newSum;
            }
        }
        Transaction transaction = this.newTransaction(contractId, sum, autopaymentTransaction, BGTransactionType.CARD);
        HashMap<String, Object> requestProperties = new HashMap<String, Object>();
        String url = null;
        String query = null;
        String outputText = null;
        String method = null;
        String mode = this.moduleSetup.get("sberbank.mode", "1");
        if ("1".equals(mode)) {
            description = this.moduleSetup.get("sberbank.rest.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116 {CONTRACT_TITLE}");
            description = description.replace("{CONTRACT_TITLE}", contractTitle);
            if (Utils.isBlankString((String)returnUrl)) {
                returnUrl = this.moduleSetup.get("sberbank.rest.return.url", "");
            }
            returnUrl = URLEncoder.encode(returnUrl, "UTF-8");
            method = "GET";
            url = this.moduleSetup.get("sberbank.rest.register.url", "https://securepayments.sberbank.ru/payment/rest/register.do");
            query = this.buildRegisterRequest(contractId, transaction.getId(), sum, URLEncoder.encode(description, "UTF-8"), returnUrl, customerAddress, contractTitle, this.getRestUserName(autopaymentTransaction), this.getRestUserPswd(autopaymentTransaction), requestBindingId, autopaymentTransaction);
        } else if ("2".equals(mode)) {
            description = this.moduleSetup.get("sberbank.ecomm.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116 {CONTRACT_TITLE}");
            description = description.replace("{CONTRACT_TITLE}", contractTitle);
            if (Utils.isBlankString((String)returnUrl)) {
                returnUrl = this.moduleSetup.get("sberbank.ecomm.return.url", "");
            }
            method = "POST";
            url = this.moduleSetup.get("sberbank.ecomm.register.url", "https://ecommerce.sberbank.ru/ecomm/gw/partner/api/v1/register.do");
            requestProperties.put("Content-Type", "application/json");
            requestProperties.put("x-idempotencyKey", contractId + "_" + transaction.getId());
            outputText = this.buildRegisterBody(contractId, transaction.getId(), sum, description, returnUrl, this.getEcommUserName(), this.getEcommUserPswd(), requestBindingId, autopaymentTransaction).toString();
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("URL: " + url);
            this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: query = {}; outputText = {}", query, outputText);
        }
        StringBuilder resultJson = null;
        try {
            resultJson = this.doConnection(url + (String)(query != null ? "?" + query : ""), method, true, outputText, requestProperties);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442: " + String.valueOf(resultJson));
            }
        }
        catch (Exception ex) {
            this.getLogger().error(ex.getMessage());
        }
        if (resultJson != null) {
            try {
                JSONObject resultJsonObject = new JSONObject(resultJson.toString());
                for (String key : new String[]{PARAM_ORDER_ID, "formUrl", "errorCode", "errorMessage"}) {
                    if (!resultJsonObject.has(key)) continue;
                    dataMap.put(key, resultJsonObject.get(key));
                }
            }
            catch (JSONException ex) {
                this.getLogger().error(ex.getMessage());
                ex.printStackTrace();
            }
        } else {
            this.getLogger().error("resultJson = " + resultJson);
        }
        if (dataMap.containsKey(PARAM_ORDER_ID)) {
            String orderId = String.valueOf(dataMap.get(PARAM_ORDER_ID));
            TransactionManager.addTransactionParameters(transaction, "orderId=" + orderId);
            transaction.setTransactionId(orderId);
            this.update(transaction);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\torderId = " + orderId);
                this.getLogger().debug("\ttransaction.getTransactionId() = " + transaction.getTransactionId());
                this.getLogger().debug("\ttransaction.getParameters() = " + transaction.getParameters());
            }
        } else if (dataMap.containsKey("errorCode")) {
            transaction.setStatus(TransactionStatus.ERROR.getCode());
            TransactionManager.addTransactionParameters(transaction, "errorCode=" + dataMap.get("errorCode") + "\nerrorMessage=" + dataMap.get("errorMessage"));
            this.update(transaction);
        } else {
            transaction.setStatus(TransactionStatus.ERROR.getCode());
            TransactionManager.addTransactionParameters(transaction, "resultJson=" + (resultJson == null ? "" : resultJson.toString()));
            this.update(transaction);
        }
        return transaction;
    }

    public String paymentOrderBinding(Transaction transaction, Autopayment autopayment) throws Exception {
        String result = null;
        if (transaction != null && autopayment != null) {
            String bindingId = autopayment.getAccessToken();
            if (bindingId != null) {
                HashMap<String, String> requestProperties = new HashMap<String, String>();
                String url = null;
                String outputText = null;
                String method = null;
                String mode = this.moduleSetup.get("sberbank.mode", "1");
                if ("1".equals(mode)) {
                    method = "POST";
                    url = this.moduleSetup.get("sberbank.rest.order.binding.url", "https://securepayments.sberbank.ru/payment/rest/paymentOrderBinding.do");
                    outputText = "language=" + this.moduleSetup.get("sberbank.rest.language", "ru") + "&mdOrder=" + transaction.getTransactionId() + "&bindingId=" + URLEncoder.encode(bindingId, "UTF-8") + "&userName=" + this.getRestUserName(true) + "&password=" + this.getRestUserPswd(true);
                } else if ("2".equals(mode)) {
                    JSONObject json = new JSONObject();
                    json.put("userName", (Object)this.getEcommUserName());
                    json.put("password", (Object)this.getEcommUserPswd());
                    json.put("mdOrder", (Object)transaction.getTransactionId());
                    json.put("bindingId", (Object)bindingId);
                    json.put("ip", (Object)"127.0.0.1");
                    method = "POST";
                    requestProperties.put("Content-Type", "application/json");
                    url = this.moduleSetup.get("sberbank.ecomm.order.binding.url", "https://ecommerce.sberbank.ru/ecomm/gw/partner/api/v1/paymentOrderBinding.do");
                    outputText = json.toString();
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("URL: " + url);
                    this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: outputText = {}", outputText);
                }
                StringBuilder resultJson = null;
                try {
                    resultJson = this.doConnection(url, method, true, outputText, requestProperties);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("\t\u041e\u0442\u0432\u0435\u0442: " + String.valueOf(resultJson));
                    }
                }
                catch (Exception ex) {
                    this.getLogger().error(ex.getMessage());
                }
                if (resultJson != null) {
                    StringBuilder resultData = new StringBuilder();
                    JSONObject resultJsonObject = new JSONObject(resultJson.toString());
                    if (resultJsonObject != null) {
                        if (resultJsonObject.has("errorCode")) {
                            resultData.append("errorCode=").append(resultJsonObject.getInt("errorCode")).append("\n");
                        }
                        if (resultJsonObject.has("info")) {
                            resultData.append("info=").append(resultJsonObject.getString("info")).append("\n");
                        }
                        if (resultJsonObject.has("redirect")) {
                            resultData.append("redirect=").append(resultJsonObject.getString("redirect")).append("\n");
                        }
                        result = resultData.toString();
                    }
                }
            } else {
                this.getLogger().error("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d, \u0442\u0430\u043a \u043a\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d bindingId = " + bindingId);
            }
        }
        return result;
    }

    public void addTransactionPayment(Transaction transaction, String transactionParameters) throws Exception {
        if (this.update(transaction, TransactionStatus.APPROVED)) {
            int typeId = this.moduleSetup.getInt("sberbank.payment.type.id", 0);
            if (transaction.getTransactionType() == BGTransactionType.QR_SBP) {
                typeId = this.moduleSetup.getInt("sberbank.payment.sbp.type.id", typeId);
            }
            Payment payment = Payment.builder().setDate(new Date()).setTypeId(typeId).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(this.moduleSetup.get("sberbank.payment.comment", "\u041f\u043b\u0430\u0442\u0435\u0436 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u0421\u0431\u0435\u0440\u0431\u0430\u043d\u043a\u0430").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId()))).build();
            try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
                new PaymentDao(this.con).update((Object)payment);
                balanceUtils.updateBalance(payment.getDate(), payment.getContractId());
            }
            transaction.setPaymentId(payment.getId());
            transaction.setTransactionDate(new Date());
            TransactionManager.addTransactionParameters(transaction, transactionParameters);
            this.update(transaction);
            EventProcessor.getInstance().publishAfterCommit((Event)new PaymentEvent(0, payment));
            EventProcessor.getInstance().publishAfterCommit((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getDate(), payment.getSum()));
        }
    }

    public static void addTransactionParameters(Transaction transaction, String params) {
        if (transaction != null && Utils.notBlankString((String)params)) {
            Object newParams = transaction.getParameters();
            if (newParams != null && !((String)newParams).endsWith("\n")) {
                newParams = (String)newParams + "\n";
            }
            transaction.setParameters((String)newParams + params);
        }
    }

    protected void setConnectionTimeout(HttpsURLConnection connection) {
        connection.setConnectTimeout(this.moduleSetup.getInt("sberbank.request.timeout", 10000));
        connection.setReadTimeout(this.moduleSetup.getInt("sberbank.request.read.timeout", 5000));
    }

    private String getRestUserName(boolean autopayment) throws BGException {
        String userName = autopayment ? this.moduleSetup.get("sberbank.autopayment.rest.user.name", "autopaymentUser") : this.moduleSetup.get("sberbank.rest.user.name", "user");
        try {
            return URLEncoder.encode(userName, "UTF-8");
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGException("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430", "system.error");
        }
    }

    private String getRestUserPswd(boolean autopayment) throws BGException {
        String userPswd = autopayment ? this.moduleSetup.get("sberbank.autopayment.rest.user.pswd", "autopaymentPassword") : this.moduleSetup.get("sberbank.rest.user.pswd", "password");
        try {
            return URLEncoder.encode(userPswd, "UTF-8");
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGException("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430", "system.error");
        }
    }

    private String getEcommUserName() {
        return this.moduleSetup.get("sberbank.ecomm.user.name", "user");
    }

    private String getEcommUserPswd() {
        return this.moduleSetup.get("sberbank.ecomm.user.pswd", "password");
    }

    public OAuthToken getOAuthToken(String scope) throws BGException {
        OAuthToken authToken = null;
        try {
            HttpClient httpClient;
            HttpResponse<String> httpResponse;
            String oauthTotenUri = this.moduleSetup.get("sberbank.sbp.token.url", "https://mc.api.sberbank.ru/prod/tokens/v3/oauth");
            String clientId = this.moduleSetup.get("sberbank.sbp.client.id", "");
            String clientSecret = this.moduleSetup.get("sberbank.sbp.client.secret", "");
            String rquid = UUID.randomUUID().toString().replace("-", "");
            String authorization = "Basic " + Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes("UTF-8"));
            String data = "grant_type=" + URLEncoder.encode("client_credentials", "UTF-8") + "&scope=" + URLEncoder.encode(scope, "UTF-8");
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(new URI(oauthTotenUri)).header("Accept", "application/json").header("Content-Type", this.moduleSetup.get("sberbank.sbp.token.content.type", "application/x-www-form-urlencoded")).header("Rquid", rquid).header("Authorization", authorization).POST(HttpRequest.BodyPublishers.ofString(data)).build();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Token request:");
                this.getLogger().debug("\t uri: {}", (Object)oauthTotenUri);
                this.getLogger().debug("\t headers:");
                for (Map.Entry<String, List<String>> entry : httpRequest.headers().map().entrySet()) {
                    this.getLogger().debug("\t\t {} = {}", (Object)entry.getKey(), (Object)entry.getValue().stream().map(Object::toString).collect(Collectors.joining(", ")));
                }
                this.getLogger().debug("\t data = {}", (Object)data);
            }
            if ((httpResponse = (httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).sslContext(this.getSSLContext()).build()).send(httpRequest, HttpResponse.BodyHandlers.ofString())).statusCode() == 200) {
                String body = httpResponse.body();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Token response:");
                    this.getLogger().debug("\t {}", (Object)body);
                }
                authToken = OAuthToken.parse(new JSONObject(body));
            } else {
                this.getLogger().error("HTTP code: {}; body: {}", (Object)httpResponse.statusCode(), (Object)httpResponse.body());
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return authToken;
    }

    public String sbpOrderStatus(String oauthToken, Transaction transaction) throws BGException {
        try {
            String statusUri = this.moduleSetup.get("sberbank.sbp.status.url", "https://mc.api.sberbank.ru/prod/qr/order/v3/status");
            String authorization = "Bearer " + oauthToken;
            String rqUID = UUID.randomUUID().toString().replace("-", "");
            String terminalId = this.moduleSetup.get("sberbank.sbp.terminal.id", "");
            JSONObject data = new JSONObject();
            data.put("rq_uid", (Object)rqUID);
            data.put("rq_tm", (Object)LocalDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS).atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT));
            data.put("order_id", (Object)String.valueOf(transaction.getTransactionId()));
            data.put("tid", (Object)terminalId);
            data.put("partner_order_number", (Object)String.valueOf(transaction.getId()));
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(new URI(statusUri)).header("Accept", "application/json").header("Content-Type", "application/json").header("Authorization", authorization).header("RqUID", rqUID).timeout(Duration.ofSeconds(5L)).POST(HttpRequest.BodyPublishers.ofString(data.toString())).build();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Order status request:");
                this.getLogger().debug("\t uri: {}", (Object)statusUri);
                this.getLogger().debug("\t headers:");
                for (Map.Entry<String, List<String>> entry : httpRequest.headers().map().entrySet()) {
                    this.getLogger().debug("\t\t {} = {}", (Object)entry.getKey(), (Object)entry.getValue().stream().map(Object::toString).collect(Collectors.joining(", ")));
                }
                this.getLogger().debug("\t data = {}", (Object)data);
            }
            String result = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).sslContext(this.getSSLContext()).build().send(httpRequest, HttpResponse.BodyHandlers.ofString()).body();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Order status response:");
                this.getLogger().debug("\t {}", (Object)result);
            }
            return result;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public String sbpOrderCreation(String oauthToken, int contractId, BigDecimal sum) throws BGException {
        try {
            Transaction transaction = this.newTransaction(contractId, sum, false, BGTransactionType.QR_SBP);
            String creationUri = this.moduleSetup.get("sberbank.sbp.creation.url", "https://mc.api.sberbank.ru/prod/qr/order/v3/creation");
            String authorization = "Bearer " + oauthToken;
            String rqUID = UUID.randomUUID().toString().replace("-", "");
            String terminalId = this.moduleSetup.get("sberbank.sbp.terminal.id", "");
            String description = this.moduleSetup.get("sberbank.sbp.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT}");
            LocalDateTime createDate = LocalDateTime.ofEpochSecond(transaction.getCreateDate().getTime() / 1000L, 0, ZoneOffset.UTC);
            if (description.contains("{CONTRACT}")) {
                try (ContractDao contractDao = new ContractDao(this.con, -1);){
                    Contract contract = (Contract)contractDao.get(contractId);
                    if (contract != null) {
                        description = description.replace("{CONTRACT}", contract.getTitle());
                    }
                }
            }
            JSONObject data = new JSONObject();
            data.put("rq_uid", (Object)rqUID);
            data.put("rq_tm", (Object)LocalDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS).atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT));
            data.put("member_id", (Object)String.valueOf(transaction.getContractId()));
            data.put("order_number", (Object)String.valueOf(transaction.getId()));
            data.put("order_create_date", (Object)createDate.atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT));
            data.put("id_qr", (Object)terminalId);
            data.put("order_sum", transaction.getSum().multiply(new BigDecimal(100)).setScale(0).intValue());
            data.put("currency", (Object)"643");
            data.put("description", (Object)description);
            data.put("sbp_member_id", (Object)"100000000111");
            String dataText = data.toString();
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(new URI(creationUri)).header("Accept", "application/json").header("Content-Type", "application/json").header("Authorization", authorization).header("RqUID", rqUID).timeout(Duration.ofSeconds(5L)).POST(HttpRequest.BodyPublishers.ofString(dataText)).build();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("sbpOrderCreation.query request:");
                this.getLogger().debug("\t uri: {}", (Object)creationUri);
                this.getLogger().debug("\t headers:");
                for (Map.Entry<String, List<String>> entry : httpRequest.headers().map().entrySet()) {
                    this.getLogger().debug("\t\t {} = {}", (Object)entry.getKey(), (Object)entry.getValue().stream().map(Object::toString).collect(Collectors.joining(", ")));
                }
                this.getLogger().debug("\t data = {}", (Object)dataText);
            }
            String result = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).sslContext(this.getSSLContext()).build().send(httpRequest, HttpResponse.BodyHandlers.ofString()).body();
            this.getLogger().debug("sbpOrderCreation.result = {}", (Object)result);
            JSONObject resultJson = new JSONObject(result);
            if ("000000".equals(resultJson.optString("error_code")) && "CREATED".equalsIgnoreCase(resultJson.optString("order_state"))) {
                transaction.setTransactionId(resultJson.optString("order_id"));
                this.update(transaction);
                return resultJson.optString("order_form_url");
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return null;
    }

    private SSLContext getSSLContext() throws Exception {
        char[] pswd = Setup.getSetup().get("keystore.password", "bgbilling").toCharArray();
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(new FileInputStream(KeyStoreUtils.getKeyStoreFile()), pswd);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, pswd);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    private String buildRegisterRequest(int contractId, int transactionId, BigDecimal sum, String description, String returnUrl, String customerAddress, String contractTitle, String userName, String userPswd, boolean requestBindingId, boolean autopaymentTransaction) {
        int currency = this.moduleSetup.getInt("sberbank.rest.currency", 0);
        StringBuilder spec = new StringBuilder().append("amount=").append(sum.multiply(new BigDecimal(100)).setScale(0)).append(currency > 0 ? "&currency=" : "").append(currency > 0 ? Integer.valueOf(currency) : "").append("&language=").append(this.moduleSetup.get("sberbank.rest.language", "ru")).append("&orderNumber=").append(transactionId).append("&userName=").append(userName).append("&password=").append(userPswd).append("&description=").append(description).append("&returnUrl=").append(returnUrl);
        String features = this.moduleSetup.get(autopaymentTransaction ? "sberbank.autopayment.features" : "sberbank.payment.features", null);
        if (!Utils.isBlankString((String)features)) {
            spec.append("&features=").append(features);
        }
        if (requestBindingId) {
            StringBuilder clientId = new StringBuilder();
            String billingName = this.moduleSetup.get("sberbank.billing.name", Setup.getSetup().get("billing.name"));
            if (billingName != null) {
                clientId.append(billingName).append("_");
            }
            clientId.append(this.moduleId).append("_").append(contractId);
            spec.append("&clientId=").append(clientId.toString());
        }
        if (this.moduleSetup.getBoolean("sberbank.fiscalization.enable", false)) {
            try {
                spec.append("&orderBundle=").append(URLEncoder.encode(this.buildOrderBundle(customerAddress, contractTitle, transactionId, sum).toString(), "UTF-8"));
                spec.append("&taxSystem=").append(this.moduleSetup.getInt("sberbank.fiscalization.receipt.tax.system", 0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return spec.toString();
    }

    private JSONObject buildRegisterBody(int contractId, int transactionId, BigDecimal sum, String description, String returnUrl, String userName, String userPswd, boolean requestBindingId, boolean autopaymentTransaction) {
        int currency = this.moduleSetup.getInt("sberbank.rest.currency", 0);
        String features = this.moduleSetup.get(autopaymentTransaction ? "sberbank.autopayment.features" : "sberbank.payment.features", null);
        JSONObject body = new JSONObject().put("userName", (Object)userName).put("password", (Object)userPswd).put("orderNumber", (Object)String.valueOf(transactionId)).put("amount", (Object)sum.multiply(new BigDecimal(100)).setScale(0)).put("description", (Object)description).put("returnUrl", (Object)returnUrl);
        if (currency > 0) {
            body.put("currency", (Object)String.valueOf(currency));
        }
        if (!Utils.isBlankString((String)features)) {
            body.put("features", (Object)features);
        }
        if (requestBindingId) {
            StringBuilder clientId = new StringBuilder();
            String billingName = this.moduleSetup.get("sberbank.billing.name", Setup.getSetup().get("billing.name"));
            if (billingName != null) {
                clientId.append(billingName).append("_");
            }
            clientId.append(this.moduleId).append("_").append(contractId);
            body.put("clientId", (Object)clientId.toString());
        }
        return body;
    }

    private JSONObject buildOrderBundle(String customerAddress, String contractTitle, int transactionId, BigDecimal sum) {
        JSONObject customerDetailsJSON = new JSONObject();
        if (!Utils.isBlankString((String)customerAddress)) {
            customerDetailsJSON.put(customerAddress.contains("@") ? "email" : "phone", (Object)customerAddress);
        }
        JSONObject quantityJSON = new JSONObject();
        quantityJSON.put("value", this.moduleSetup.getInt("sberbank.fiscalization.receipt.qty", 1));
        quantityJSON.put("measure", (Object)this.moduleSetup.get("sberbank.fiscalization.receipt.qty.measure", "\u0448\u0442"));
        JSONObject taxJSON = new JSONObject();
        taxJSON.put("taxType", this.moduleSetup.getInt("sberbank.fiscalization.receipt.tax.type", this.moduleSetup.getInt("sberbank.fiscalization.receipt.vat", 0)));
        JSONObject itemJSON = new JSONObject();
        itemJSON.put("positionId", (Object)"1");
        itemJSON.put("name", (Object)this.moduleSetup.get("sberbank.fiscalization.receipt.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle));
        itemJSON.put("quantity", (Object)quantityJSON);
        itemJSON.put("itemAmount", sum.multiply(new BigDecimal(100)).setScale(0).intValue());
        itemJSON.put("itemCode", (Object)String.valueOf(transactionId));
        itemJSON.put("tax", (Object)taxJSON);
        itemJSON.put("itemPrice", sum.multiply(new BigDecimal(100)).setScale(0).intValue());
        JSONArray itemsJSON = new JSONArray();
        itemsJSON.put((Object)itemJSON);
        JSONObject cartItemsJSON = new JSONObject();
        cartItemsJSON.put("items", (Object)itemsJSON);
        JSONObject orderBundleJSON = new JSONObject();
        orderBundleJSON.put("customerDetails", (Object)customerDetailsJSON);
        orderBundleJSON.put("cartItems", (Object)cartItemsJSON);
        return orderBundleJSON;
    }
}

