/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHouseAccount;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.enums.SmartHouseAccountState;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.enums.SmartHouseAccountStatus;
import ru.bitel.common.model.Id;

public class SmartHouseAccountDao
extends AbstractIdDao<SmartHouseAccount> {
    public SmartHouseAccountDao(Connection con, int moduleId) {
        super(con, moduleId, "smarthouse_account");
    }

    public List<SmartHouseAccount> list(int contractId, int contractObjectId) throws SQLException {
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(contractId);
        if (contractObjectId > -1) {
            params.add(contractObjectId);
        }
        ArrayList<SmartHouseAccount> accounts = new ArrayList<SmartHouseAccount>();
        accounts.addAll(this.listImpl(null, "contract_id=?" + (contractObjectId > -1 ? " AND contract_object_id=?" : ""), "title", params.toArray()));
        return accounts;
    }

    protected SmartHouseAccount getFromRS(ResultSet rs) throws SQLException {
        return new SmartHouseAccount(rs.getInt("id")).setTitle(rs.getString("title")).setType(rs.getInt("type")).setContractId(rs.getInt("contract_id")).setContractObjectId(rs.getInt("contract_object_id")).setStatus(SmartHouseAccountStatus.getSmartHouseAccountStatus((int)rs.getInt("status"))).setState(SmartHouseAccountState.getSmartHouseAccountState((int)rs.getInt("state"))).setComment(rs.getString("comment"));
    }

    protected void updateImpl(SmartHouseAccount smartHouseAccount) throws SQLException {
        String querySet = "title=?, type=?, contract_id=?, contract_object_id=?, status=?, state=?, comment=?";
        try (PreparedStatement ps = this.prepareStatement((Id)smartHouseAccount, querySet);){
            int index = 1;
            ps.setString(index++, smartHouseAccount.getTitle());
            ps.setInt(index++, smartHouseAccount.getType());
            ps.setInt(index++, smartHouseAccount.getContractId());
            ps.setInt(index++, smartHouseAccount.getContractObjectId());
            ps.setInt(index++, smartHouseAccount.getStatus().getCode());
            ps.setInt(index++, smartHouseAccount.getState().getCode());
            ps.setString(index++, smartHouseAccount.getComment());
            this.executeUpdate((Id)smartHouseAccount, index, ps);
        }
    }
}

