/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client.tariff;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.TariffPanelEditor;
import ru.bitel.bgbilling.kernel.tariff.client.editor.MultiSelectEditor;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.service.ProductService;

public class ProductTariffTreeNode
extends DefaultTariffTreeNode {
    private static final String STORE_KEY = "productSpecIds";
    private static Icon icon = ClientUtils.getIcon((String)"fugue/present");
    private JLabel view = new JLabel();
    private MultiSelectEditor<IdTitle> multiList;
    private List<IdTitle> products = new ArrayList<IdTitle>();
    private String productTitle;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> nodes) {
        super.init(id, mtree, type, tree, config, parent, nodes);
        this.view.setIcon(icon);
        int moduleId = this.getModuleId(parent);
        TariffPanelEditor tariffPanelEditor = (TariffPanelEditor)tree.getParent();
        try {
            ProductService productService = (ProductService)((ClientContext)tariffPanelEditor.getContext()).getWebService(ProductService.class, 0);
            List productSpecs = productService.productSpecList(Integer.valueOf(moduleId), null, null, null, null);
            for (ProductSpec productSpec : productSpecs) {
                ProductSpec productSpec1;
                Object result = productSpec.getTitle();
                AtomicReference<Integer> productId = new AtomicReference<Integer>(productSpec.getParentId());
                while ((productSpec1 = (ProductSpec)productSpecs.stream().filter(a -> a.getId() == ((Integer)productId.get()).intValue()).findFirst().orElse(null)) != null) {
                    result = productSpec1.getTitle() + " -> " + (String)result;
                    productId.set(productSpec1.getParentId());
                }
                this.products.add(new IdTitle(productSpec.getId(), (String)result));
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public Component getView() {
        return this.view;
    }

    public void setData(String data) {
        super.setData(data);
        this.updateView();
    }

    private void updateView() {
        this.extractData();
        this.view.setText(this.productTitle);
    }

    protected void loadData() {
        this.getEditorPanel();
        this.multiList.setSelect(this.getDataInHash().getOrDefault(STORE_KEY, ""));
    }

    protected JPanel getEditorPanel() {
        if (this.multiList == null) {
            this.multiList = new MultiSelectEditor(this.products);
        }
        return this.multiList;
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(STORE_KEY, this.multiList.getSelect());
        this.setDataInHash(data);
        this.updateView();
    }

    public void extractData() {
        String productSpecIds = this.getDataInHash().getOrDefault(STORE_KEY, "");
        StringBuffer str = new StringBuffer();
        if (this.products != null && !productSpecIds.equals("")) {
            Utils.toIntegerList((String)productSpecIds).forEach(id -> str.append(str.length() > 0 ? "<br>" : "").append(" ").append(this.getProductTitle((int)id)));
        }
        this.productTitle = "<html>" + this.getLabelTitle() + "<br>" + str.toString() + "</html>";
    }

    public String getProductTitle(int id) {
        return "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;* " + this.products.stream().filter(a -> a.getId() == id).map(IdTitle::getTitle).findFirst().orElse("#" + id);
    }

    public List<Integer> getProductSpecIds() {
        Map data = this.getDataInHash();
        return Utils.toIntegerList((String)((String)data.get(STORE_KEY)));
    }

    protected String getLabelTitle() {
        return "\u041f\u0440\u043e\u0434\u0443\u043a\u0442: ";
    }
}

