/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.contract;

import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneCategory;
import ru.bitel.oss.systems.inventory.resource.common.service.PhoneResourceService;

public class VoiceAccountNumberEditorDialog
extends BGEditorDialog<VoiceAccount> {
    private ClientContext context = null;
    private PhoneResourceService phoneResourceService = null;
    private PhoneCategoryTreeModel treeModel = new PhoneCategoryTreeModel();
    private BGUTreeTable treeTable = new BGUTreeTable((BGTreeTableModel)this.treeModel);
    private BGTextField numberFilter = new BGTextField(10);
    private IntTextField maxField = new IntTextField(6);
    private BGControlPanelDateNoB date = new BGControlPanelDateNoB();
    private BGUList<IdTitle> resourceList = new BGUList();
    private BGUList<IdTitle> result = new BGUList();

    public VoiceAccountNumberEditorDialog(String title, VoiceAccount data, ClientContext context) {
        super(title, (Object)data);
        this.context = context;
    }

    public void doDialogPanel() {
        this.panel.add((Component)this.getFilterPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.getResourcePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.date.setLocalDate(LocalDate.now());
        this.maxField.setValue((long)ClientSetup.getInstance().getUserConfig().getInt("voice.resource.ip.free.max", 100));
        this.treeTable.addTreeSelectionListener(e -> {
            ArrayList data = new ArrayList();
            PhoneCategory phoneCategory = (PhoneCategory)this.treeModel.getSelectedRow();
            if (phoneCategory != null) {
                try {
                    ((PhoneResourceService)this.context.getWebService(PhoneResourceService.class)).phoneResourceList(phoneCategory.getId()).forEach(a -> data.add(new IdTitle(a.getId(), a.getPhoneFrom() + "-" + a.getPhoneTo())));
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            this.resourceList.setData(data);
            this.resourceList.invalidate();
        });
        this.resourceList.addListSelectionListener(e -> this.doFilter());
        try {
            this.treeModel.setData(this.getPhoneResourceService().phoneCategoryRoot());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public boolean doApply() throws Exception {
        IdTitle idTitle = (IdTitle)this.result.getSelectedValue();
        if (idTitle != null) {
            ((VoiceAccount)this.data).setNumber(Long.valueOf(idTitle.getTitle()).longValue());
        }
        return true;
    }

    private void doFilter() {
        PhoneCategory category = (PhoneCategory)this.treeModel.getSelectedRow();
        if (category == null || category.getId() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e");
            return;
        }
        if (this.date.getDateCalendar() == null) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0434\u0430\u0442\u0443");
            return;
        }
        try {
            HashSet resourceIds = new HashSet();
            this.resourceList.getSelectedValuesList().forEach(a -> resourceIds.add(a.getId()));
            this.result.setData(this.getPhoneResourceService().phoneFreeList(Integer.valueOf(category.getId()), resourceIds, this.date.getDate(), this.numberFilter.getText(), (int)this.maxField.getValue()).stream().map(t -> new IdTitle(0, String.valueOf(t))).collect(Collectors.toList()));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private JPanel getFilterPanel() {
        ActionListener actionListener = e -> this.doFilter();
        this.numberFilter.setHorizontalAlignment(0);
        this.numberFilter.addActionListener(actionListener);
        JButton goButton = new JButton("\u0412\u044b\u0432\u0435\u0441\u0442\u0438");
        goButton.addActionListener(actionListener);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0424\u0438\u043b\u044c\u0442\u0440:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.numberFilter, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041d\u0430 \u0434\u0430\u0442\u0443:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.date, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041c\u0430\u043a\u0441\u0438\u043c\u0443\u043c:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.maxField, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)goButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getResourcePanel() {
        Dimension dimension = new Dimension(350, 400);
        JScrollPane categoryScrollPane = new JScrollPane((Component)this.treeTable);
        categoryScrollPane.setMinimumSize(dimension);
        categoryScrollPane.setPreferredSize(dimension);
        dimension = new Dimension(250, 400);
        JScrollPane resourceScrollPane = new JScrollPane((Component)this.resourceList);
        resourceScrollPane.setMinimumSize(dimension);
        resourceScrollPane.setPreferredSize(dimension);
        dimension = new Dimension(200, 400);
        JScrollPane resultScrollPane = new JScrollPane((Component)this.result);
        resultScrollPane.setMinimumSize(dimension);
        resultScrollPane.setPreferredSize(dimension);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)categoryScrollPane, new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 13, 1, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)resourceScrollPane, new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 13, 1, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)resultScrollPane, new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(10, 10, 0, 0), 0, 0));
        return panel;
    }

    private PhoneResourceService getPhoneResourceService() {
        if (this.phoneResourceService == null) {
            this.phoneResourceService = (PhoneResourceService)this.context.getPort(PhoneResourceService.class);
        }
        return this.phoneResourceService;
    }

    class PhoneCategoryTreeModel
    extends BGTreeTableModel<PhoneCategory> {
        public PhoneCategoryTreeModel() {
            super(PhoneCategoryTreeModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", PhoneCategory.class, -1, 300, -1, "title", false);
            this.addColumnId();
        }
    }
}

