/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.action.web;

import bitel.billing.server.call.bean.Login;
import jakarta.servlet.http.HttpSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpLoginManager;
import ru.bitel.bgbilling.modules.voiceip.server.dto.LoginDTO;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

@WebAction(title="Voiceip")
public class ActionVoiceip
extends AbstractAction {
    public ActionVoiceip() {
        super("voiceip");
    }

    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
    }

    @WebOperation(title="\u0421\u043f\u0438\u0441\u043e\u043a \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u0432")
    public void accounts() throws BGException {
        VoiceIpLoginManager voiceIpLoginManager = new VoiceIpLoginManager(this.con, this.moduleId);
        ArrayList<LoginDTO> loginDTOs = new ArrayList<LoginDTO>();
        for (Login login : voiceIpLoginManager.getContractLogins(this.contractId)) {
            loginDTOs.add(new LoginDTO.Builder(login).build());
        }
        this.setResultParam("accountList", loginDTOs);
        this.requestDispatcher(this.moduleName, "accounts");
    }

    @WebOperation(title="\u0421\u043c\u0435\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f")
    public void changeLoginPassword() throws BGException {
        int accountId;
        VoiceIpLoginManager voiceIpLoginManager;
        block22: {
            HttpSession ses = this.context.getRequest().getSession(true);
            voiceIpLoginManager = new VoiceIpLoginManager(this.con, this.moduleId);
            accountId = this.req.getInt("accountId", -1);
            String old_pswd = this.req.get("old_pswd", null);
            String pswd1 = this.req.get("pswd1", null);
            String pswd2 = this.req.get("pswd2", null);
            if (old_pswd != null && pswd1 != null && pswd2 != null) {
                String error = ContractUtils.checkPassword((ParameterMap)this.moduleSetup, (String)pswd1, (String)pswd2);
                if (error != null) {
                    this.setResultParam("status", "error");
                    this.setResultParam("error", error);
                } else {
                    String query = "SELECT pswd FROM user_login_" + this.moduleId + " WHERE id=?";
                    try (PreparedStatement psSelectPswd = this.con.prepareStatement(query);){
                        boolean is_pswd_valid = false;
                        psSelectPswd.setInt(1, accountId);
                        ResultSet rs = psSelectPswd.executeQuery();
                        if (rs.next()) {
                            String pswd = rs.getString(1);
                            if (Utils.getDigest((String)old_pswd, (String)"cp1251").equals(pswd)) {
                                is_pswd_valid = true;
                            } else if (old_pswd.equals(pswd)) {
                                is_pswd_valid = true;
                            }
                        }
                        if (!is_pswd_valid) {
                            this.setResultParam("status", "error");
                            this.setResultParam("error", "\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d \u0441\u0442\u0430\u0440\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c!");
                            break block22;
                        }
                        if (this.con == null) break block22;
                        try (PreparedStatement ps = this.con.prepareStatement("UPDATE user_login_" + this.moduleId + " SET pswd=? WHERE id=?");){
                            ps.setString(1, pswd1.trim());
                            ps.setInt(2, accountId);
                            ps.executeUpdate();
                        }
                        this.setResultParam("status", "ok");
                        boolean is_admin = ses.getAttribute("admin") != null;
                        voiceIpLoginManager.logPswdChange(accountId, is_admin ? 0 : -1);
                    }
                    catch (SQLException e) {
                        this.setResultParam("status", "error");
                        this.setResultParam("error", e.getLocalizedMessage());
                    }
                }
            }
        }
        this.setResultParam("accountId", accountId);
        this.setResultParam("loginList", voiceIpLoginManager.getContractLogins(this.contractId));
        this.requestDispatcher(this.moduleName, "changeLoginPassword");
    }

    @WebOperation(title="\u0421\u043c\u0435\u043d\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u0430")
    public void changeLoginStatus() throws BGException {
        VoiceIpLoginManager voiceIpLoginManager = new VoiceIpLoginManager(this.con, this.moduleId);
        this.setResultParam("loginList", voiceIpLoginManager.getContractLogins(this.contractId));
        this.requestDispatcher(this.moduleName, "changeLoginStatus");
    }

    @WebOperation(title="\u0421\u0435\u0441\u0441\u0438\u044f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430")
    public void showSessions() throws BGException {
        this.requestDispatcher(this.moduleName, "showSessions");
    }

    @WebOperation(title="\u041d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430")
    public void showLoginBalance() throws BGException {
        this.requestDispatcher(this.moduleName, "showLoginBalance");
    }

    @WebOperation(title="\u041d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430")
    public void loginDirect() throws BGException {
        this.requestDispatcher(this.moduleName, "loginDirect");
    }

    @WebOperation(title="\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0430 \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430")
    public void dispatchAmount() throws BGException {
        this.requestDispatcher(this.moduleName, "dispatchAmount");
    }

    @WebOperation(title="\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0430 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430")
    public void dispatchDirect() throws BGException {
        this.requestDispatcher(this.moduleName, "dispatchDirect");
    }
}

