/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client;

import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.BGControlPanelMonth;
import bitel.billing.module.common.BGToggleButton;
import bitel.billing.module.services.ServiceConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.modules.bill.client.ActionServiceConfig;
import ru.bitel.bgbilling.modules.bill.client.BillServiceConfigTabbedPanel;
import ru.bitel.bgbilling.modules.bill.client.ServiceConfigBillGenerate;
import ru.bitel.bgbilling.modules.bill.client.bean.ConfirmPayBillDialog;
import ru.bitel.bgbilling.modules.bill.client.bean.GenerateInvoiceMenu;
import ru.bitel.bgbilling.modules.bill.client.bean.SelectDateDialog;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class ServiceConfigBillManager
extends BillServiceConfigTabbedPanel {
    private BGButton filterSet = new BGButton();
    private BGControlPanelDateNoB fromDate = new BGControlPanelDateNoB();
    private BGControlPanelDateNoB untilDate = new BGControlPanelDateNoB();
    private BGControlPanelListSelect typeCb = new BGControlPanelListSelect(5);
    private ContractLabelTree contractLabelTree = new ContractLabelTree();
    private ButtonGroup userTypeButtonGroup = new ButtonGroup();
    private ButtonGroup payedTypeButtonGroup = new ButtonGroup();
    private JRadioButton orRB = new JRadioButton("\u0418\u041b\u0418");
    private JRadioButton andRB = new JRadioButton("\u0418");
    private BGTextField contract = new BGTextField();
    private BGTextField billNumber = new BGTextField();
    private BGUComboBox<IdTitle> dateTypeCombo = new BGUComboBox();
    private BGUComboBox<IdTitle> accountComboBox = new BGUComboBox();
    private BGControlPanelMonth month = new BGControlPanelMonth();
    private JPanel extParamPanel = null;
    private int pay = 0;
    private GenerateInvoiceMenu generateInvoiceMenu = null;

    public ServiceConfigBillManager() {
        super("bill");
        this.rb_name = ClientUtils.getRBName(ActionServiceConfig.class);
        this.getModuleDoc(ActionServiceConfig.class);
        this.tableModel = new BillTableModel("BillManager");
        this.initCardPanel();
    }

    @Override
    protected void addPopupItems(JPopupMenu popupMenu) {
        GregorianCalendar cal = new GregorianCalendar();
        ActionListener actionListener = e -> {
            int[] idArray = Utils.toIntArray((String)e.getActionCommand());
            if (idArray[2] > 0 && idArray[1] > 0 && idArray[0] > 0) {
                try {
                    String className = ServiceConfigBillGenerate.class.getName();
                    ServiceConfig serviceConfig = (ServiceConfig)this.getParent().getParent().getParent();
                    ServiceConfigBillGenerate billGenerate = (ServiceConfigBillGenerate)serviceConfig.getTab(className);
                    billGenerate.setDocumentTypeSelectedIndex(1);
                    billGenerate.getTemplateBillList(false, String.valueOf(idArray[1]), "invoice", idArray[2], String.valueOf(idArray[0]), "bill");
                    billGenerate.setTableSelectedIndex(0);
                    serviceConfig.selectTab(className);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.generateInvoiceMenu = new GenerateInvoiceMenu("\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0447\u0435\u0442-\u0444\u0430\u043a\u0442\u0443\u0440\u0443, \u0410\u043a\u0442, \u0423\u041f\u0414", (BGTableModel<Element>)this.tableModel, actionListener, () -> this.getDocType());
        popupMenu.add(this.generateInvoiceMenu);
        popupMenu.addSeparator();
        JMenuItem itemPayedToday = new JMenuItem("\u041e\u043f\u043b\u0430\u0447\u0435\u043d\u043e \u0441\u0435\u0433\u043e\u0434\u043d\u044f (" + TimeUtils.format((Calendar)cal, (String)"dd.MM, EEE") + ")");
        popupMenu.add(itemPayedToday);
        itemPayedToday.addActionListener(e -> this.setPayed(true, new GregorianCalendar().getTime(), true));
        cal.set(5, cal.get(5) - 1);
        JMenuItem itemPayedYesterday = new JMenuItem("\u041e\u043f\u043b\u0430\u0447\u0435\u043d\u043e \u0432\u0447\u0435\u0440\u0430 (" + TimeUtils.format((Calendar)cal, (String)"dd.MM, EEE") + ")");
        popupMenu.add(itemPayedYesterday);
        itemPayedYesterday.addActionListener(e -> {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(5, calendar.get(5) - 1);
            this.setPayed(true, calendar.getTime(), true);
        });
        JMenuItem itemPayedOnDate = new JMenuItem("\u041e\u043f\u043b\u0430\u0447\u0435\u043d\u043e \u043d\u0430 \u0434\u0430\u0442\u0443");
        popupMenu.add(itemPayedOnDate);
        itemPayedOnDate.addActionListener(e -> {
            SelectDateDialog selectDateDialog = new SelectDateDialog();
            selectDateDialog.setVisible(true);
            Calendar calendar = selectDateDialog.getCalendar();
            if (calendar != null) {
                this.setPayed(true, calendar.getTime(), false);
            }
        });
        popupMenu.addSeparator();
        JMenuItem itemNotPayed = new JMenuItem("\u041d\u0435 \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043e");
        popupMenu.add(itemNotPayed);
        itemNotPayed.addActionListener(e -> this.setPayed(false, null, false));
    }

    private List<IdTitle> getDocType() {
        try {
            int contractId;
            Element element = (Element)this.tableModel.getSelectedRow();
            if (element != null && (contractId = Utils.parseInt((String)element.getAttribute("cid"), (int)-1)) > 0) {
                return ((BillService)this.getContext().getWebService(BillService.class, this.getContext().getModuleId())).docTypeTitles(contractId, DocumentType.INVOICE);
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        return Collections.emptyList();
    }

    @Override
    protected JPanel getPanel() {
        BGUTable table = new BGUTable((TableModel)this.tableModel);
        this.initTable("bill", table);
        this.filterSet.setText("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c");
        this.filterSet.setActionCommand("go");
        this.filterSet.addActionListener(e -> this.trySetData());
        this.month.setBorder(null);
        this.orRB.setSelected(true);
        int indexY = 0;
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("\u041f\u0430\u0447\u043a\u0430:"), new GridBagConstraints(0, indexY++, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        filterPanel.add((Component)this.packageCb, new GridBagConstraints(0, indexY++, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)new JLabel("\u0412\u044b\u043f\u0438\u0441\u0430\u043d \u043d\u0430"), new GridBagConstraints(0, indexY++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        filterPanel.add((Component)this.accountComboBox, new GridBagConstraints(0, indexY++, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)new JLabel("\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 1:"), new GridBagConstraints(0, indexY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        filterPanel.add((Component)new JLabel("\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 2:"), new GridBagConstraints(1, indexY++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.sortModeCb, new GridBagConstraints(0, indexY, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)this.secondarySortModeCb, new GridBagConstraints(1, indexY++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        filterPanel.add((Component)new JLabel("\u0414\u0430\u0442\u0430:"), new GridBagConstraints(0, indexY++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 2, 0), 0, 0));
        filterPanel.add((Component)this.getDateButtonPanel(), new GridBagConstraints(0, indexY++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)new JLabel("\u0421\u043e\u0437\u0434\u0430\u043d\u044b:"), new GridBagConstraints(0, indexY++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 2, 5), 0, 0));
        filterPanel.add((Component)this.getUserTypePanel(), new GridBagConstraints(0, indexY++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel groupModePanel = new JPanel();
        groupModePanel.add(new JLabel("\u0420\u0435\u0436\u0438\u043c"));
        groupModePanel.add(this.andRB);
        groupModePanel.add(this.orRB);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.andRB);
        buttonGroup3.add(this.orRB);
        JPanel groupsPanel = new JPanel(new GridBagLayout());
        groupsPanel.setPreferredSize(new Dimension(220, 335));
        groupsPanel.setMinimumSize(new Dimension(100, 335));
        groupsPanel.add((Component)groupModePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        groupsPanel.add((Component)new JScrollPane((Component)this.contractLabelTree), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JTabbedPane filtersPanel = new JTabbedPane();
        filtersPanel.setPreferredSize(new Dimension(300, 200));
        filtersPanel.addTab("\u041c\u0435\u0442\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", groupsPanel);
        filtersPanel.addTab("\u0422\u0438\u043f\u044b", (Component)this.typeCb);
        this.extParamPanel = new JPanel(new GridBagLayout());
        this.extParamPanel.add((Component)filterPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.extParamPanel.add((Component)filtersPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.extParamPanel.setVisible(false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 2, 0, 2), 0, 0));
        panel.add((Component)this.positionsEditor.getPositionsPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 1, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.countLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        JPanel billPanel = new JPanel(new GridBagLayout());
        billPanel.setLayout(new GridBagLayout());
        billPanel.add((Component)this.getTopPanel(), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        billPanel.add((Component)panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        billPanel.add((Component)this.extParamPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        return billPanel;
    }

    @Override
    protected JPanel getFilterPanel() {
        JToggleButton extParamButton = new JToggleButton("\u0415\u0449\u0435...");
        extParamButton.addActionListener(e -> this.extParamPanel.setVisible(((JToggleButton)e.getSource()).isSelected()));
        int insetLeft = 15;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u0424\u0438\u043b\u044c\u0442\u0440 "));
        panel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 0), 0, 0));
        panel.add((Component)this.contract, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 5, 5, 0), 0, 0));
        panel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440 \u0441\u0447\u0435\u0442\u0430:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, insetLeft, 0, 0), 0, 0));
        panel.add((Component)this.billNumber, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, insetLeft, 5, 0), 0, 0));
        panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, insetLeft, 0, 0), 0, 0));
        panel.add((Component)this.month, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, insetLeft, 5, 0), 0, 0));
        panel.add((Component)new JLabel("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435:"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, insetLeft, 0, 0), 0, 0));
        panel.add((Component)this.getPayedTypePanel(), new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, insetLeft, 5, 0), 0, 0));
        panel.add((Component)extParamButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, insetLeft, 5, 0), 0, 0));
        panel.add((Component)this.filterSet, new GridBagConstraints(5, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, insetLeft, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getDateButtonPanel() {
        this.dateTypeCombo.setData(Arrays.asList(new IdTitle(1, "\u0432\u044b\u043f\u0438\u0441\u043a\u0438"), new IdTitle(2, "\u043e\u043f\u043b\u0430\u0442\u044b")));
        JPanel dateButtonPanel = new JPanel(new GridBagLayout());
        dateButtonPanel.add((Component)this.dateTypeCombo, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        dateButtonPanel.add((Component)new JLabel("\u0441"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        dateButtonPanel.add((Component)this.fromDate, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 5, 0, 0), 0, 0));
        dateButtonPanel.add((Component)new JLabel("\u043f\u043e"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        dateButtonPanel.add((Component)this.untilDate, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 5, 0, 0), 0, 0));
        return dateButtonPanel;
    }

    private JPanel getUserTypePanel() {
        BGToggleButton userTypeButton1 = new BGToggleButton("\u0432\u0441\u0435\u043c\u0438", "1", null);
        BGToggleButton userTypeButton2 = new BGToggleButton("\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u043e\u043c", "2", null);
        BGToggleButton userTypeButton3 = new BGToggleButton("\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c", "3", null);
        this.userTypeButtonGroup.add((AbstractButton)userTypeButton1);
        this.userTypeButtonGroup.add((AbstractButton)userTypeButton2);
        this.userTypeButtonGroup.add((AbstractButton)userTypeButton3);
        userTypeButton1.setSelected(true);
        JPanel userTypeJPanel = new JPanel(new GridBagLayout());
        userTypeJPanel.add((Component)userTypeButton1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        userTypeJPanel.add((Component)userTypeButton2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        userTypeJPanel.add((Component)userTypeButton3, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        return userTypeJPanel;
    }

    private JPanel getPayedTypePanel() {
        BGToggleButton payedTypeButton1 = new BGToggleButton("\u043d\u0435\u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u044b\u0435", "1", null);
        BGToggleButton payedTypeButton2 = new BGToggleButton("\u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u044b\u0435", "2", null);
        BGToggleButton payedTypeButton3 = new BGToggleButton("\u043b\u044e\u0431\u043e\u0435", "3", null);
        this.payedTypeButtonGroup.add((AbstractButton)payedTypeButton1);
        this.payedTypeButtonGroup.add((AbstractButton)payedTypeButton2);
        this.payedTypeButtonGroup.add((AbstractButton)payedTypeButton3);
        payedTypeButton1.setSelected(true);
        JPanel payedTypeJPanel = new JPanel(new GridBagLayout());
        payedTypeJPanel.add((Component)payedTypeButton1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        payedTypeJPanel.add((Component)payedTypeButton2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        payedTypeJPanel.add((Component)payedTypeButton3, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        return payedTypeJPanel;
    }

    @Override
    protected Request getRequest() {
        this.typeBill = "bill";
        return new Request().setModule(this.module).setAction("Bill").setModuleId(this.getModuleId()).setAttribute("gr", Utils.toString((Iterable)this.contractLabelTree.getSelectedIds())).setAttribute("gr_mode", this.orRB.isSelected() ? "or" : "and").setAttribute("from", this.fromDate.getDateString()).setAttribute("until", this.untilDate.getDateString()).setAttribute("payed_type", String.valueOf(this.payedTypeButtonGroup.getSelection().getActionCommand())).setAttribute("user_type", String.valueOf(this.userTypeButtonGroup.getSelection().getActionCommand())).setAttribute("date_type", ((IdTitle)this.dateTypeCombo.getSelectedItem()).getId()).setAttribute("y", String.valueOf(this.month.getLocalDate().getYear())).setAttribute("m", String.valueOf(this.month.getLocalDate().getMonthValue() - 1)).setAttribute("contract", this.contract.getText()).setAttribute("billNumber", this.billNumber.getText()).setAttribute("package", ((IdTitle)this.packageCb.getSelectedItem()).getId()).setAttribute("sort_mode", ((IdTitle)this.sortModeCb.getSelectedItem()).getId()).setAttribute("secondary_sort_mode", ((IdTitle)this.secondarySortModeCb.getSelectedItem()).getId()).setAttribute("type", this.typeCb.getListValues()).setAttribute("countOfBill", this.tableModel.getRowCount()).setAttribute("account_id", this.accountComboBox.optSelectedItem().map(a -> a.getId()).orElse(null)).setPageSize(0);
    }

    public void setData() throws Exception {
        Element payElement;
        Element sepEl;
        Request request;
        Document doc;
        if (!this.init) {
            this.init();
            this.init = true;
        }
        if (ClientUtils.checkStatus((Document)(doc = this.getDocument(request = this.getRequest())))) {
            Element tableEl = XMLUtils.getElement((Document)doc, (String)"table");
            ArrayList<Element> rows = new ArrayList<Element>();
            for (Element rowElement : XMLUtils.selectElements((Node)tableEl, (String)"data/row")) {
                rows.add(rowElement);
            }
            this.tableModel.setData(rows);
            this.updateCountLabel(tableEl.getAttribute("number"), tableEl.getAttribute("summ"));
        }
        if ((sepEl = XMLUtils.selectElement((Node)doc, (String)"/data/separator")) != null) {
            this.separator = XMLUtils.getAttribute((Element)sepEl, (String)"separator", (String)",");
        }
        if ((payElement = XMLUtils.selectElement((Node)doc, (String)"//pay")) != null) {
            this.pay = Utils.parseInt((String)XMLUtils.getAttribute((Element)payElement, (String)"pay"), (int)0);
        }
        request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setAction("BillPositionList");
        request.setAttribute("parsed", "1");
        request.setAttribute("mm", String.valueOf(this.month.getLocalDate().getMonthValue() - 1));
        doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.positionsEditor.setPositionList(XMLUtils.getNode((Document)doc, (String)"positions"));
        }
        this.currentId = null;
        this.positionsEditor.showPositions(null);
    }

    private void init() {
        try {
            this.contractLabelTree.setData(((ContractLabelService)this.getContext().getPort(ContractLabelService.class, 0)).getContractLabelTreeItemList(-1, false));
            this.accountComboBox.setData(((BillService)this.getContext().getPort(BillService.class)).bankAccountList().stream().map(a -> a.toIdTitle()).toList());
            this.accountComboBox.insertItemAt((Object)new IdTitle(0, "-- \u043b\u044e\u0431\u043e\u0439 --"), 0);
            this.accountComboBox.setSelectedIndex(0);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        try {
            List docTypes = ((BillService)this.getContext().getPort(BillService.class, this.getModuleId())).docTypeList(DocumentType.BILL);
            this.typeCb.getListModel().clear();
            docTypes.forEach(a -> this.typeCb.getListModel().addElement(new BGUListItem((IdTitle)a)));
            this.prepareFilters();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void setPayed(boolean payed, Date date, boolean checkWeekend) {
        Calendar calendar;
        List rows = this.tableModel.getSelectedRows();
        if (rows.isEmpty()) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443");
            return;
        }
        if (checkWeekend && date != null && ((calendar = TimeUtils.convertDateToCalendar((Date)date)).get(7) == 1 || calendar.get(7) == 7) && !ClientUtils.confirm((String)"\u0414\u0430\u0442\u0430 \u043f\u043e\u043f\u0430\u0434\u0430\u0435\u0442 \u043d\u0430 \u0432\u044b\u0445\u043e\u0434\u043d\u043e\u0439 \u0434\u0435\u043d\u044c, \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c?", (String)"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043e\u043f\u043b\u0430\u0442\u044b")) {
            return;
        }
        int result = 0;
        if (payed && this.pay == 2) {
            for (Element rowElement : rows) {
                StringBuilder sb = new StringBuilder();
                this.addIds(sb, rowElement);
                Map<String, String> data = this.getData(rowElement);
                String summAndComment = ConfirmPayBillDialog.showConfirmDialog(JOptionPane.getRootFrame(), data);
                if (summAndComment == null) continue;
                result = this.doSetPayed(payed, date, summAndComment, sb.toString()) ? 1 : 0;
            }
        } else {
            StringBuilder sb = new StringBuilder();
            for (Element rowElement : rows) {
                this.addIds(sb, rowElement);
            }
            int n = result = this.doSetPayed(payed, date, null, sb.toString()) ? 1 : 0;
        }
        if (result > 0) {
            this.trySetData();
        }
    }

    private void addIds(StringBuilder sb, Element rowElement) {
        sb.append(rowElement.getAttribute("id"));
        sb.append(":");
        sb.append(rowElement.getAttribute("cid"));
        sb.append(";");
    }

    private boolean doSetPayed(boolean payed, Date date, String sumComment, String ids) {
        boolean result = false;
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setAction("SetPayed");
        request.setAttribute("value", String.valueOf(payed));
        if (date != null) {
            request.setAttribute("date", TimeUtils.format((Date)date, (String)"dd.MM.yyyy"));
        }
        if (sumComment != null) {
            request.setAttribute("summComment", sumComment);
        }
        request.setAttribute("ids", ids);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            result = true;
        }
        return result;
    }

    public void deleteItem() {
        List rows = this.tableModel.getSelectedRows();
        if (rows.isEmpty()) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
            return;
        }
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0447\u0435\u0442\u0430?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("DeleteBill");
            StringBuilder sb = new StringBuilder();
            for (Element rowElement : rows) {
                sb.append(rowElement.getAttribute("id"));
                sb.append(";");
            }
            request.setAttribute("ids", sb.toString());
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.trySetData();
            }
        }
    }

    private Map<String, String> getData(Element rowElement) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("contract", rowElement.getAttribute("contract"));
        data.put("number", rowElement.getAttribute("number"));
        data.put("create_dt", rowElement.getAttribute("create_dt"));
        data.put("summ", rowElement.getAttribute("summ"));
        return data;
    }

    class BillTableModel
    extends BGTableModel<Element> {
        public BillTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("cid", 0, 0, 0, "cid", false, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("type", 0, 0, 0, "type", false, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041d\u043e\u043c\u0435\u0440", 120, 120, 120, "number", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", Date.class, 120, 120, 120, "create_dt", true, (TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy", 0));
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 [\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439]", 100, -1, -1, "contract_and_comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0438\u043f", 100, 250, 500, "type_title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 100, 100, 100, "status", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u043e\u0437\u0434\u0430\u043b", 180, 180, 180, "createdby", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430 \u043e\u043f\u043b\u0430\u0442\u044b", Date.class, 120, 120, 120, "pay_dt", true, (TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy", 0));
            this.addColumn("\u041e\u0442\u043c\u0435\u0442\u0438\u043b \u043e\u043f\u043b\u0430\u0442\u0443", 180, 180, 180, "payedby", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", BigDecimal.class, 100, 100, 100, "summ", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
        }

        public Object getValue(Element val, int column) throws Exception {
            Object result = null;
            String identifier = this.getIdentifier(column);
            result = "create_dt".equals(identifier) || "pay_dt".equals(identifier) ? TimeUtils.parseDate((String)val.getAttribute(identifier), (String)"dd.MM.yyyy") : ("summ".equals(identifier) ? new BigDecimal(val.getAttribute(identifier)) : super.getValue((Object)val, column));
            return result;
        }
    }
}

