/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.directory;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.bill.common.bean.link.BillLink;
import ru.bitel.bgbilling.modules.bill.common.bean.link.BillLinkBlock;
import ru.bitel.bgbilling.modules.bill.common.bean.link.BillLinkBlockType;
import ru.bitel.bgbilling.modules.bill.common.bean.link.BillLinkProperties;
import ru.bitel.bgbilling.modules.bill.common.service.BillLinkService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;

public class BillLinkPanel
extends BGUPanel {
    private BillLink billLink = null;
    private BillLinkBlock billLinkBlock = new BillLinkBlock();
    private JTextField blockKey = null;
    private JTextField blockTitle = null;
    private JTextArea blockData = null;
    private JPopupMenu popupMenu = null;
    private ActionListener actionListener = null;
    private CardLayout cardLayout = new CardLayout();
    private BGTextField linkTitle = new BGTextField();
    private BillLinkService billLinkService = null;
    private BillLinkTableModel linkTableModel = new BillLinkTableModel(BillLinkTableModel.class.getName());
    private BGUTable linkTable = new BGUTable((TableModel)((Object)this.linkTableModel));
    private PropertiesTableModel propertiesTableModel = new PropertiesTableModel(PropertiesTableModel.class.getName());
    private BGUTable propertiesTable = new BGUTable((TableModel)((Object)this.propertiesTableModel));
    private LinkBlockTableModel linkBlockTableModel = new LinkBlockTableModel(LinkBlockTableModel.class.getName());
    private BGUTable linkBlockTable = new BGUTable((TableModel)((Object)this.linkBlockTableModel));

    protected void jbInit() throws Exception {
        this.linkTable.getSelectionModel().setSelectionMode(0);
        this.propertiesTable.getSelectionModel().setSelectionMode(0);
        this.linkBlockTable.getSelectionModel().setSelectionMode(0);
        this.billLinkService = (BillLinkService)((ClientContext)this.getContext()).getPort(BillLinkService.class);
        this.linkTableModel.setData(this.billLinkService.getBillLinkList());
        this.setLayout(this.cardLayout);
        this.add(this.getTablePanel(), "table");
        this.add(this.getEditorPanel(), "editor");
    }

    private JPanel getTablePanel() {
        BGSwingUtilites.handleEdit((JTable)this.linkTable, (BGUPanel)this, (String)"edit");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)this.linkTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getEditorPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        panel.add((Component)this.getEditPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getEditPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getTitlePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getColumnPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTitlePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 20, 5, 0), 0, 0));
        panel.add((Component)this.linkTitle, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private BGSplitPaneNoBorder getColumnPanel() {
        return new BGSplitPaneNoBorder(1, (Component)this.getRowPanel(), (Component)this.getPropertiesPanel(), -200L);
    }

    private BGSplitPaneNoBorder getRowPanel() {
        return new BGSplitPaneNoBorder(0, (Component)this.getBlockPanel(), (Component)this.getBlockEditorPanel(), -200L);
    }

    private JTabbedPane getBlockPanel() {
        this.linkBlockTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (BillLinkPanel.this.getPopupMenu() != null && SwingUtilities.isRightMouseButton(mouseEvent) && BillLinkPanel.this.linkBlockTable.getSelectedRow() == BillLinkPanel.this.linkBlockTable.rowAtPoint(mouseEvent.getPoint())) {
                    BillLinkPanel.this.getPopupMenu().show((Component)BillLinkPanel.this.linkBlockTable, mouseEvent.getX(), mouseEvent.getY());
                } else if (BillLinkPanel.this.linkBlockTable.getSelectedRow() > -1) {
                    BillLinkPanel.this.billLinkBlock = (BillLinkBlock)BillLinkPanel.this.linkBlockTableModel.getSelectedRow();
                    BillLinkPanel.this.setLinkBlockEditorData();
                }
            }
        });
        ActionListener actionListener = e -> {
            BillLinkBlockType billLinkBlokType = BillLinkBlockType.valueOf((String)e.getActionCommand());
            BillLinkBlock billLinkBlock = new BillLinkBlock();
            billLinkBlock.setType(billLinkBlokType);
            billLinkBlock.setKey(this.getBlockKey(billLinkBlokType));
            billLinkBlock.setTitle("\u041d\u043e\u0432\u044b\u0439 \u0431\u043b\u043e\u043a");
            this.billLink.getLinkBlocks().add(billLinkBlock);
            this.linkBlockTableModel.addRow(billLinkBlock);
        };
        int gridx = 0;
        JPanel blockButtonPanel = new JPanel(new GridBagLayout());
        for (BillLinkBlockType billLinkBlokType : BillLinkBlockType.values()) {
            JButton button = new JButton("+" + billLinkBlokType.toString());
            button.setActionCommand(billLinkBlokType.toString());
            button.addActionListener(actionListener);
            blockButtonPanel.add((Component)button, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        }
        blockButtonPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)blockButtonPanel, new GridBagConstraints(0, 0, 1, 1, 11.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.linkBlockTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JTabbedPane pane = new JTabbedPane();
        pane.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        pane.add("\u0411\u043b\u043e\u043a\u0438", panel);
        return pane;
    }

    void setLinkEditorData() {
        this.linkTitle.setText(this.billLink.getTitle());
        this.linkBlockTableModel.setData(this.billLink.getLinkBlocks());
        this.billLinkBlock = new BillLinkBlock();
        this.setLinkBlockEditorData();
    }

    void setLinkBlockEditorData() {
        this.blockKey.setText(this.billLinkBlock.getKey());
        this.blockTitle.setText(this.billLinkBlock.getTitle());
        this.blockData.setText(this.billLinkBlock.getData());
    }

    private String getBlockKey(BillLinkBlockType billLinkBlokType) {
        ArrayList<BillLinkBlock> list = new ArrayList<BillLinkBlock>();
        for (BillLinkBlock billLinkBlock : this.billLink.getLinkBlocks()) {
            if (!billLinkBlock.getType().name().equalsIgnoreCase(billLinkBlokType.name())) continue;
            list.add(billLinkBlock);
        }
        int len = billLinkBlokType.name().length();
        int keyN = 1;
        while (true) {
            boolean fl = false;
            for (BillLinkBlock billLinkBlock : list) {
                if (Utils.parseInt((String)billLinkBlock.getKey().substring(len), (int)0) != keyN) continue;
                fl = true;
                break;
            }
            if (!fl) break;
            ++keyN;
        }
        return billLinkBlokType.name().toLowerCase() + keyN;
    }

    private JPanel getBlockEditorPanel() {
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Component component = focusEvent.getComponent();
                if (BillLinkPanel.this.blockKey == component) {
                    BillLinkPanel.this.billLinkBlock.setKey(BillLinkPanel.this.blockKey.getText());
                } else if (BillLinkPanel.this.blockTitle == component) {
                    BillLinkPanel.this.billLinkBlock.setTitle(BillLinkPanel.this.blockTitle.getText());
                } else if (BillLinkPanel.this.blockData == component) {
                    BillLinkPanel.this.billLinkBlock.setData(BillLinkPanel.this.blockData.getText());
                }
                BillLinkPanel.this.linkBlockTable.invalidate();
                BillLinkPanel.this.linkBlockTable.repaint();
            }
        };
        this.blockKey = new JTextField(10);
        this.blockKey.addFocusListener(focusAdapter);
        this.blockTitle = new JTextField(30);
        this.blockTitle.addFocusListener(focusAdapter);
        this.blockData = new JTextArea();
        this.blockData.setMargin(new Insets(3, 3, 3, 3));
        this.blockData.addFocusListener(focusAdapter);
        JPanel keyTitlePanel = new JPanel(new GridBagLayout());
        keyTitlePanel.add((Component)new JLabel("Key"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        keyTitlePanel.add((Component)this.blockKey, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        keyTitlePanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        keyTitlePanel.add((Component)this.blockTitle, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0), BorderFactory.createTitledBorder("\u0414\u0430\u043d\u043d\u044b\u0435 \u0431\u043b\u043e\u043a\u0430")));
        panel.add((Component)keyTitlePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JScrollPane(this.blockData), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JTabbedPane getPropertiesPanel() {
        JTabbedPane pane = new JTabbedPane();
        pane.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        pane.add("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430", new JScrollPane((Component)this.propertiesTable));
        return pane;
    }

    private JPanel getButtonPanel() {
        BGButton saveButton = new BGButton((Action)new SaveAction("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"));
        BGButton closeButton = new BGButton((Action)new CloseAction("\u0417\u0430\u043a\u0440\u044b\u0442\u044c"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)saveButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)closeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private void show(String l) {
        this.cardLayout.show((Container)((Object)this), l);
        if ("table".equals(l)) {
            this.performAction("refresh");
        }
    }

    JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0431\u043b\u043e\u043a");
            menuItem.addActionListener(this.getActionListener());
            menuItem.setActionCommand("deletBlock");
            this.popupMenu.add(menuItem);
        }
        return this.popupMenu;
    }

    ActionListener getActionListener() {
        if (this.actionListener == null) {
            this.actionListener = e -> {
                String actionCommand = e.getActionCommand();
                if ("deletBlock".equals(actionCommand)) {
                    this.linkBlockTableModel.deleteSelectedRows();
                    this.billLinkBlock = new BillLinkBlock();
                    this.setLinkBlockEditorData();
                }
            };
        }
        return this.actionListener;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.linkTableModel.setData(this.billLinkService.getBillLinkList())));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            if (this.getComponent(0).isVisible()) {
                this.billLink = new BillLink();
                this.setLinkEditorData();
                this.show("editor");
            }
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            if (this.getComponent(0).isVisible()) {
                this.billLink = (BillLink)this.linkTableModel.getSelectedRow();
                if (this.billLink == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                } else {
                    this.setLinkEditorData();
                    this.show("editor");
                }
            }
        });
    }

    class BillLinkTableModel
    extends BGTableModel<BillLink> {
        public BillLinkTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 200, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043b", 200, 200, 200, "userId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430 \u043f\u0440\u0430\u0432\u043a\u0438", 150, 150, 150, "lastModified", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
        }
    }

    class PropertiesTableModel
    extends BGTableModel<BillLinkProperties> {
        public PropertiesTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u0418\u043c\u044f", 100, 150, -1, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 100, 200, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class LinkBlockTableModel
    extends BGTableModel<BillLinkBlock> {
        public LinkBlockTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u0422\u0438\u043f", 80, 80, 80, "type", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 200, -1, "title", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class SaveAction
    extends AbstractAction {
        public SaveAction(String text) {
            super(text, null);
            this.putValue("ActionCommandKey", "save");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BillLinkPanel.this.billLink.setTitle(BillLinkPanel.this.linkTitle.getText());
            try {
                BillLinkPanel.this.billLinkService.updateBillLink(BillLinkPanel.this.billLink);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return;
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction(String text) {
            super(text, null);
            this.putValue("ActionCommandKey", "close");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BillLinkPanel.this.show("table");
        }
    }
}

