/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.botmanager.client.BotStatisticTableModel;
import ru.bitel.bgbilling.modules.botmanager.common.bean.StatisticNote;
import ru.bitel.bgbilling.modules.botmanager.common.service.BotManagerService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.SearchResult;

public class BotStatisticPanel
extends BGUTabPanel {
    private BotManagerService botManagerService;
    private BGTableModel<StatisticNote> tableModel;
    private BGControlPanelPages page = new BGControlPanelPages();
    private JLabel recordCountLabel = new JLabel();

    public BotStatisticPanel() {
        this.botManagerService = (BotManagerService)((ClientContext)this.getContext()).getPort(BotManagerService.class);
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.page.setKey(((Object)((Object)this)).getClass().getName());
        final JPopupMenu popupMenu = this.buildMenu();
        this.tableModel = new BotStatisticTableModel("", this.botManagerService);
        final BGUTable statisticTable = new BGUTable(this.tableModel);
        statisticTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StatisticNote selectedNote = (StatisticNote)BotStatisticPanel.this.tableModel.getSelectedRow();
                if (selectedNote != null && selectedNote.getContractId() > 0) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                        BGClientBase.getFrame().getTabbedPane().addContractEditorTab(selectedNote.getContractId());
                    } else if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1) {
                        popupMenu.show((Component)statisticTable, e.getX(), e.getY());
                    }
                }
            }
        });
        this.add(this.getFilterPanel(), new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 0), 0, 0));
        this.add(new JScrollPane((Component)statisticTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getFilterPanel() {
        this.page.init();
        this.page.addPropertyChangeListener(evt -> {
            if (this.tableModel.getRowCount() > 0) {
                this.performAction("refresh");
            }
        });
        JPanel filterPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(-1, 0, 1, 0, 0.0, 1.0, 13, 0, new Insets(0, 3, 0, 0), 0, 0);
        filterPanel.add((Component)this.recordCountLabel, constraints);
        filterPanel.add((Component)this.page, constraints);
        return filterPanel;
    }

    private JPopupMenu buildMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem deleteStatistic = new JMenuItem("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0432\u0441\u044e \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443");
        deleteStatistic.addActionListener(e -> this.popupMenuItemAction("deleteStatistic"));
        JMenuItem deleteForContract = new JMenuItem("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443 \u0434\u043b\u044f \u044d\u0442\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        deleteForContract.addActionListener(e -> this.popupMenuItemAction("deleteForContract"));
        JMenuItem deleteForBot = new JMenuItem("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443 \u0434\u043b\u044f \u044d\u0442\u043e\u0433\u043e \u0431\u043e\u0442\u0430");
        deleteForBot.addActionListener(e -> this.popupMenuItemAction("deleteForBot"));
        menu.add(deleteStatistic);
        menu.add(deleteForContract);
        menu.add(deleteForBot);
        return menu;
    }

    private void popupMenuItemAction(String command) {
        try {
            StatisticNote selectedNode;
            if ("deleteStatistic".equals(command)) {
                this.botManagerService.clearStatisticByBotId(-1);
            } else if ("deleteForContract".equals(command)) {
                StatisticNote selectedNote = (StatisticNote)this.tableModel.getSelectedRow();
                if (selectedNote != null && selectedNote.getContractId() > 0) {
                    this.botManagerService.clearStatisticByContractId(selectedNote.getContractId());
                }
            } else if ("deleteForBot".equals(command) && (selectedNode = (StatisticNote)this.tableModel.getSelectedRow()) != null) {
                this.botManagerService.clearStatisticByBotId(selectedNode.getBotId());
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.performAction("refresh");
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> {
            SearchResult searchResult = this.botManagerService.getStatistic(this.page.getPage());
            this.tableModel.setData(searchResult.getList());
            this.page.setPage(searchResult.getPage());
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
        }));
    }
}

