/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client;

import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.botmanager.client.BotStatisticTableModel;
import ru.bitel.bgbilling.modules.botmanager.common.bean.StatisticNote;
import ru.bitel.bgbilling.modules.botmanager.common.service.BotManagerService;
import ru.bitel.common.client.table.BGTableModel;

public class ServicePropertiesPanel
extends ServicePanel {
    private BotManagerService botManagerService;
    private BGUTable statisticTable;
    private BGTableModel<StatisticNote> tableModel;

    public void init(int contractId, int moduleId, int objectId) {
        super.init(contractId, moduleId, objectId);
        this.setLayout(new GridBagLayout());
        this.tableModel = new BotStatisticTableModel("statistic", this.getBotManagerService());
        this.statisticTable = new BGUTable(this.tableModel);
        final JPopupMenu menu = this.buildMenu();
        this.statisticTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StatisticNote selectedNote;
                if (e.getClickCount() == 1 && SwingUtilities.isRightMouseButton(e) && (selectedNote = (StatisticNote)ServicePropertiesPanel.this.tableModel.getSelectedRow()) != null) {
                    menu.show((Component)ServicePropertiesPanel.this.statisticTable, e.getX(), e.getY());
                }
            }
        });
        this.add(new JScrollPane((Component)this.statisticTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPopupMenu buildMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem deleteAllNotesOfContract = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        deleteAllNotesOfContract.addActionListener(e -> {
            if (ClientUtils.confirmDelete((Object)"\u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430")) {
                try {
                    this.getBotManagerService().clearStatisticByContractId(this.getContractId());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
                this.trySetData();
            }
        });
        menu.add(deleteAllNotesOfContract);
        return menu;
    }

    public void setData() throws Exception {
        this.tableModel.setData(this.getBotManagerService().getStatisticByContractId(this.getContractId()));
    }

    private BotManagerService getBotManagerService() {
        if (this.botManagerService == null) {
            this.botManagerService = (BotManagerService)this.getContext().getPort(BotManagerService.class, this.getModuleId());
        }
        return this.botManagerService;
    }
}

