/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.client;

import bitel.billing.module.services.ServiceConfigTabbedPanel;
import jakarta.xml.ws.Holder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.RowSorterListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.hd.common.bean.ZoneWhois;
import ru.bitel.bgbilling.modules.hd.common.service.ZoneService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.SearchResult;

public class ServiceConfigWhois
extends ServiceConfigTabbedPanel {
    private JPopupMenu popupMenu = null;
    private ZoneService zoneService = null;
    private JLabel recordCount = new JLabel();
    private RowSorterListener rowSorterListener = null;
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private ZoneWhoisTableModel tableModel = new ZoneWhoisTableModel(ZoneWhoisTableModel.class.getName());
    private BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
    private BGTextField zone = new BGTextField(15);
    private JCheckBox actualy = new JCheckBox("\u0442\u043e\u043b\u044c\u043a\u043e \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0435");

    public ServiceConfigWhois() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void jbInit() {
        int gridy = 0;
        this.setLayout(new GridBagLayout());
        this.add(this.getTopPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getTopPanel() {
        BGButton doButton = new BGButton("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c");
        doButton.addActionListener(e -> {
            this.pagePanel.setPageIndex(1);
            this.setData();
        });
        this.pagePanel.addPropertyChangeListener(e -> this.setData());
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (ServiceConfigWhois.this.getPopupMenu() != null && SwingUtilities.isRightMouseButton(event) && ServiceConfigWhois.this.table.getSelectedRow() == ServiceConfigWhois.this.table.rowAtPoint(event.getPoint())) {
                    ServiceConfigWhois.this.getPopupMenu().show((Component)ServiceConfigWhois.this.table, event.getX(), event.getY());
                }
            }
        });
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0417\u043e\u043d\u0430: "), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.zone, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.actualy, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)doButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.recordCount, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.pagePanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    public void setData() {
        try {
            this.table.getRowSorter().removeRowSorterListener(this.getRowSorterListener());
            SearchResult searchResult = this.getZoneService().searchWhoisList(this.zone.getText(), this.actualy.isSelected(), null, this.pagePanel.getPage(), this.table.getSort());
            this.tableModel.setData(searchResult.getList());
            this.pagePanel.setPage(searchResult.getPage());
            this.recordCount.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatLong((long)searchResult.getPage().getRecordCount()));
            this.table.getRowSorter().addRowSorterListener(this.getRowSorterListener());
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private RowSorterListener getRowSorterListener() {
        if (this.rowSorterListener == null) {
            this.rowSorterListener = e -> {
                this.pagePanel.setPageIndex(1);
                this.setData();
            };
        }
        return this.rowSorterListener;
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(this.getOpenContractMenuItem());
            this.popupMenu.add(this.getWhoisDataMenuItem());
        }
        return this.popupMenu;
    }

    private JMenuItem getOpenContractMenuItem() {
        return new JMenuItem("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440"){
            {
                this.addActionListener(e -> {
                    int contractId;
                    ZoneWhois zoneWhois = (ZoneWhois)ServiceConfigWhois.this.tableModel.getSelectedRow();
                    if (zoneWhois != null && (contractId = zoneWhois.getContractId()) > 0) {
                        ClientUtils.openContract((int)contractId);
                    }
                });
            }
        };
    }

    private JMenuItem getWhoisDataMenuItem() {
        return new JMenuItem("Whois \u0434\u0430\u043d\u043d\u044b\u0435"){
            {
                this.addActionListener(e -> {
                    ZoneWhois zoneWhois = (ZoneWhois)ServiceConfigWhois.this.tableModel.getSelectedRow();
                    if (zoneWhois != null) {
                        try {
                            Holder holder = new Holder();
                            ServiceConfigWhois.this.getZoneService().getWhoisData(holder, zoneWhois.getId());
                            JSONObject jsonObject = new JSONObject((String)holder.value);
                            ArrayList list = new ArrayList();
                            jsonObject.keySet().stream().forEach(k -> list.add(new String[]{k, jsonObject.getString(k)}));
                            Object[][] data = new String[list.size()][2];
                            for (int index = 0; index < list.size(); ++index) {
                                data[index] = (String[])list.get(index);
                            }
                            JTable table = new JTable(data, new String[]{"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435"});
                            JScrollPane jScrollPane = new JScrollPane(table);
                            jScrollPane.setPreferredSize(new Dimension(500, 200));
                            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), jScrollPane, "Whois \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                        }
                        catch (Exception ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    }
                });
            }
        };
    }

    private ZoneService getZoneService() {
        if (this.zoneService == null) {
            this.zoneService = (ZoneService)this.getContext().getPort(ZoneService.class);
        }
        return this.zoneService;
    }

    class ZoneWhoisTableModel
    extends BGTableModel<ZoneWhois> {
        public ZoneWhoisTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0417\u043e\u043d\u0430", 100, 200, -1, "zone", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430 (whois)", 100, 150, 200, "whoisLastUpdate", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("Whois", 50, 50, 50, "loadWhois", true);
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 200, 200, 200, "period", true);
            this.addColumn("\u041e\u0441\u0432\u043e\u0431\u043e\u0436\u0434\u0435\u043d\u0438\u0435", 100, 150, 150, "freeDate", true, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440", 100, 200, -1, "registrar", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 100, 150, -1, "contractTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }
    }
}

