/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.client.parameter;

import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Optional;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamHistoryDialog;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamPanel;
import ru.bitel.bgbilling.kernel.customer.common.bean.Customer;
import ru.bitel.common.client.BGSwingUtilites;

public class CustomerParamTextArea
extends JTextArea {
    private String title = "";
    private String oldValue = "";
    private String fieldKey = null;
    private CustomerParamPanel customerParamPanel = null;

    public CustomerParamTextArea(Customer.Keys customeKey, int row, int column, String regexp, CustomerParamPanel customerParamPanel) {
        this(customeKey.description(), row, column, customeKey.key(), regexp, customerParamPanel);
    }

    public CustomerParamTextArea(String title, int row, int column, final String fieldKey, final String regexp, final CustomerParamPanel customerParamPanel) {
        super(row, column);
        this.title = title;
        this.fieldKey = fieldKey;
        this.customerParamPanel = customerParamPanel;
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setMargin(new Insets(3, 3, 3, 3));
        BGSwingUtilites.handleRMouseClicked(this, e -> {
            JMenuItem copyItem = new JMenuItem("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430");
            copyItem.addActionListener(a -> BGSwingUtilites.clipboardCopy(Optional.ofNullable(this.getText()).orElse("")));
            JMenuItem historyItem = new JMenuItem("\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430");
            historyItem.addActionListener(a -> new CustomerParamHistoryDialog(title, fieldKey, customerParamPanel));
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(copyItem);
            popupMenu.add(historyItem);
            popupMenu.show(this, e.getX(), e.getY());
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                String text = CustomerParamTextArea.this.getText();
                if (((ClientContext)customerParamPanel.getContext()).getCustomerId() > 0 && !CustomerParamTextArea.this.oldValue.equals(text)) {
                    if (regexp != null && !text.matches(regexp)) {
                        ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0448\u0430\u0431\u043b\u043e\u043d\u0443 - " + regexp);
                        return;
                    }
                    customerParamPanel.updateCustomerValue(fieldKey, text);
                    CustomerParamTextArea.this.oldValue = text;
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    public void setData() {
        Object object = ((ClientContext)this.customerParamPanel.getContext()).getCustomer().optQuery(this.fieldKey);
        this.oldValue = object == null ? "" : String.valueOf(object);
        this.setText(this.oldValue);
    }

    public String getFieldKey() {
        return this.fieldKey;
    }

    public String getTitle() {
        return this.title;
    }
}

