/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.organizer.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.plugins.organizer.client.CalendarTreePanel;
import ru.bitel.bgbilling.plugins.organizer.client.OrganizerRecordEditor;
import ru.bitel.bgbilling.plugins.organizer.client.bean.RecordInfo;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class OrganizerSearchPanel
extends BGUPanel {
    private boolean init = false;
    private BGTable table = new BGTable();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private JLabel recordCountLabel = new JLabel();
    private JPanel filterPanel = new JPanel(new GridBagLayout());
    private JToggleButton filterButton = new JToggleButton(" \u0424\u0438\u043b\u044c\u0442\u0440 ");
    private BGTextField title = new BGTextField();
    private IntTextField idField = new IntTextField();
    private JCheckBox doneBox = new JCheckBox("\u0422\u043e\u043b\u044c\u043a\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043d\u044b\u0435");
    private BGComboBox<ComboBoxItem> completedUsers = new BGComboBox();
    private BGComboBox<ComboBoxItem> todoUsers = new BGComboBox();
    private BGComboBox<ComboBoxItem> todoGroups = new BGComboBox();
    private BGControlPanelPeriodNoB periodPanel = new BGControlPanelPeriodNoB();
    private BGControlPanelPeriodNoB donePeriodPanel = new BGControlPanelPeriodNoB();
    private CalendarTreePanel calendar = new CalendarTreePanel();
    private OrganizerRecordEditor editor = new OrganizerRecordEditor();

    protected void jbInit() throws Exception {
        JPopupMenu popupMenu = this.createPopupMenu(this.table);
        JMenuItem item = new JMenuItem("\u041a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443");
        popupMenu.add(item);
        item.addActionListener(e -> this.gotoContract());
        JPanel leftPanel = new JPanel(new GridBagLayout());
        JPanel rightPanel = new JPanel(new GridBagLayout());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        BGButton buttonSearch = new BGButton("\u041f\u043e\u0438\u0441\u043a");
        BGButton buttonReset = new BGButton("\u0421\u0431\u0440\u043e\u0441");
        buttonSearch.addActionListener(e -> {
            this.pagePanel.init();
            this.performAction("refresh");
        });
        buttonReset.addActionListener(e -> {
            this.pagePanel.init();
            this.resetFilter();
            this.performAction("refresh");
        });
        this.pagePanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.performAction("refresh");
            }
        });
        this.doneBox.addActionListener(e -> {
            this.completedUsers.setEnabled(this.doneBox.isSelected());
            this.donePeriodPanel.setEnabled(this.doneBox.isSelected());
        });
        this.doneBox.setSelected(false);
        this.completedUsers.setEnabled(false);
        this.donePeriodPanel.setEnabled(false);
        this.todoUsers.addActionListener(e -> {
            if (this.todoUsers.getSelectedIndex() > 0) {
                this.todoGroups.setSelectedIndex(0);
            }
        });
        this.todoGroups.addActionListener(e -> {
            if (this.todoGroups.getSelectedIndex() > 0) {
                this.todoUsers.setSelectedIndex(0);
            }
        });
        this.filterPanel.setBorder((Border)new BGTitleBorder("\u041f\u043e\u0438\u0441\u043a"));
        JPanel f1 = new JPanel(new GridBagLayout());
        f1.add((Component)new JLabel("ID: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        f1.add((Component)this.idField, new GridBagConstraints(1, 0, 1, 1, 0.01, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        f1.add((Component)new JLabel("\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u0442: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        f1.add((Component)this.title, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel f2 = new JPanel(new GridBagLayout());
        f2.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u0443 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u043e: "));
        f2.add((Component)new JLabel("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        f2.add((Component)this.todoUsers, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        f2.add((Component)new JLabel("\u0438\u043b\u0438 \u0433\u0440\u0443\u043f\u043f\u0435: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        f2.add((Component)this.todoGroups, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel f3 = new JPanel(new GridBagLayout());
        f3.setBorder((Border)new BGTitleBorder(" \u0421\u0442\u0430\u0442\u0443\u0441: "));
        f3.add((Component)this.doneBox, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        f3.add((Component)new JLabel(" \u041a\u0442\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u043b: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        f3.add((Component)this.completedUsers, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel f4 = new JPanel(new GridBagLayout());
        f4.setBorder((Border)new BGTitleBorder(" \u041f\u0435\u0440\u0438\u043e\u0434: "));
        f4.add((Component)new JLabel("\u0417\u0430\u0434\u0430\u043d\u0438\u0435 \u0431\u044b\u043b\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(4, 5, 7, 5), 0, 0));
        f4.add((Component)this.donePeriodPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel buttonZ = new JPanel(new GridBagLayout());
        buttonZ.add((Component)this.filterButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 50, 5, 5), 0, 0));
        buttonZ.add((Component)this.periodPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 50, 5, 5), 0, 0));
        buttonZ.add((Component)buttonSearch, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        buttonZ.add((Component)buttonReset, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.recordCountLabel.setFont(new Font("Dialog", 1, 14));
        JPanel pages = new JPanel(new GridBagLayout());
        pages.add((Component)new JLabel(" "), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        pages.add((Component)this.recordCountLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        pages.add((Component)this.pagePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)f1, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.filterPanel.add((Component)f2, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.filterPanel.add((Component)f3, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.filterPanel.add((Component)f4, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    OrganizerSearchPanel.this.openEditor(false);
                }
            }
        });
        this.filterButton.addActionListener(e -> this.filterPanel.setVisible(this.filterButton.isSelected()));
        this.filterPanel.setVisible(false);
        this.calendar.addActionListener(e -> this.setSelectedPeriod());
        leftPanel.add((Component)new JScrollPane(this.calendar), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)this.filterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)buttonZ, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        topPanel.add((Component)pages, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        rightPanel.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        rightPanel.add((Component)mainPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 2, 0, 2), 0, 0));
        rightPanel.add((Component)((Object)this.editor), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JSplitPane mainSplit = new JSplitPane();
        mainSplit.setBorder(null);
        mainSplit.setDividerSize(5);
        mainSplit.setDividerLocation(180);
        mainSplit.add((Component)leftPanel, "left");
        mainSplit.add((Component)rightPanel, "right");
        this.setLayout(new GridBagLayout());
        this.add(mainSplit, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        BGPluginClient plugin = BGPluginManagerClient.getManager().getPlugin("ru.bitel.bgbilling.plugins.organizer");
        this.table.setHeader(plugin.getResourceBundle(), plugin.getTable("records"), "records");
        this.editor.setVisible(false);
        this.editor.setParent(this);
        this.init = false;
    }

    protected JPopupMenu createPopupMenu(final BGTable table) {
        final JPopupMenu result = new JPopupMenu();
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1) {
                    result.show((Component)table, e.getX(), e.getY());
                }
            }
        });
        return result;
    }

    private void openEditor(boolean clear) {
        if (clear || this.table.getSelectedRow() < 0) {
            this.editor.initiate(new RecordInfo());
            this.editor.setVisible(true);
            return;
        }
        int sel = this.table.getSelectedRow();
        if (sel < 0) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
            return;
        }
        RecordInfo info = new RecordInfo();
        info.setId(String.valueOf(this.table.getColumnValue(sel, "ID")));
        info.setContractId(Integer.valueOf(String.valueOf(this.table.getColumnValue(sel, "CID"))));
        info.setContractName(String.valueOf(this.table.getColumnValue(sel, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440")));
        info.setTitle(String.valueOf(this.table.getColumnValue(sel, "\u0422\u0435\u043c\u0430")));
        info.setComm(String.valueOf(this.table.getColumnValue(sel, "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439")));
        info.setUser(String.valueOf(this.table.getColumnValue(sel, "TODOUID")));
        info.setGroup(String.valueOf(this.table.getColumnValue(sel, "TODOGID")));
        String period = String.valueOf(this.table.getColumnValue(sel, "\u041f\u0435\u0440\u0438\u043e\u0434 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f"));
        String date1 = period.substring(0, period.indexOf("--"));
        String date2 = period.substring(period.indexOf("--") + 3);
        info.setStatus((Boolean)this.table.getColumnValue(sel, "\u0421\u0442\u0430\u0442\u0443\u0441") != false ? "done" : "notdone");
        Period per = new Period();
        per.setDateFrom(TimeUtils.convertStringToDate((String)date1));
        per.setDateTo(TimeUtils.convertStringToDate((String)date2));
        info.setPeriod(per);
        info.setUidCompleted(String.valueOf(this.table.getColumnValue(sel, "UIDCOMPLETE")));
        this.editor.initiate(info);
        this.editor.setVisible(true);
    }

    private void setSelectedPeriod() {
        Period p = this.calendar.getSelectedPeriod();
        this.periodPanel.setDateCalendar1(p.getDateFromCalendar());
        this.periodPanel.setDateCalendar2(p.getDateToCalendar());
    }

    private void resetFilter() {
        this.title.setText("");
        this.idField.setText("");
        this.todoUsers.setSelectedIndex(0);
        this.todoGroups.setSelectedIndex(0);
        this.completedUsers.setSelectedIndex(0);
        this.doneBox.setSelected(false);
        this.donePeriodPanel.setDateString1("");
        this.donePeriodPanel.setDateString2("");
    }

    private void gotoContract() {
        String cid = ClientUtils.getRowId((BGTable)this.table, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!", (String)"CID");
        if (cid != null && !cid.equals("-1")) {
            ClientUtils.openContract((int)Utils.parseInt((String)cid));
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (!this.init) {
                Request request = new Request();
                request.setModule("ru.bitel.bgbilling.plugins.organizer");
                request.setAction("GetCalendarYears");
                Document doc = TransferManager.getDocument((Request)request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    Element years = XMLUtils.selectElement((Node)doc, (String)"//years");
                    this.calendar.setYears(Utils.parseInt((String)years.getAttribute("from")), Utils.parseInt((String)years.getAttribute("to")));
                }
                request = new Request();
                request.setModule("ru.bitel.bgbilling.plugins.organizer");
                request.setAction("GetUsersAndGroups");
                doc = TransferManager.getDocument((Request)request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    Node users = XMLUtils.selectNode((Node)doc, (String)"//users");
                    this.todoUsers.setModel((ComboBoxModel)ClientUtils.buildComboBoxWithDefault((Node)users, null));
                    this.completedUsers.setModel((ComboBoxModel)ClientUtils.buildComboBoxWithDefault((Node)users, null));
                    Node groups = XMLUtils.selectNode((Node)doc, (String)"//groups");
                    this.todoGroups.setModel((ComboBoxModel)ClientUtils.buildComboBoxWithDefault((Node)groups, null));
                }
                this.init = true;
            } else {
                Request request = new Request();
                request.setModule("ru.bitel.bgbilling.plugins.organizer");
                request.setAction("GetRecordsList");
                request.setPageIndex(this.pagePanel.getPageIndex());
                request.setPageSize(this.pagePanel.getPageSize());
                request.setAttribute("rid", this.idField.getText().trim());
                request.setAttribute("contains", this.title.getText().trim());
                request.setAttribute("todouser", ((ComboBoxItem)this.todoUsers.getSelectedItem()).getObject().toString());
                request.setAttribute("todogroup", ((ComboBoxItem)this.todoGroups.getSelectedItem()).getObject().toString());
                request.setAttribute("onlydone", this.doneBox.isSelected());
                if (this.doneBox.isSelected()) {
                    request.setAttribute("completeduser", ((ComboBoxItem)this.completedUsers.getSelectedItem()).getObject().toString());
                    request.setAttribute("completedate1", this.donePeriodPanel.getDateString1());
                    request.setAttribute("completedate2", this.donePeriodPanel.getDateString2());
                }
                request.setPeriod(this.periodPanel.getPeriod());
                this.setDocument(TransferManager.getDocument((Request)request));
            }
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> this.openEditor(true));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            if (this.table.getSelectedRow() < 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
                return;
            }
            this.openEditor(false);
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u044b\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u0435?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 2) == 2) {
                return;
            }
            int sel = this.table.getSelectedRow();
            if (sel < 0) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                return;
            }
            String rid = String.valueOf(this.table.getColumnValue(sel, "ID"));
            Request request = new Request();
            request.setModule("ru.bitel.bgbilling.plugins.organizer");
            request.setAction("DeleteOrganizerRecord");
            request.setAttribute("rid", rid);
            ClientUtils.checkStatus((Document)TransferManager.getDocument((Request)request));
            this.performAction("refresh");
        });
    }

    protected void setDocument(Document doc) throws Exception {
        if (ClientUtils.checkStatus((Document)doc)) {
            Element tableElement = this.table.updateData(doc);
            this.pagePanel.setPageInfo(tableElement);
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Page.getRecordCount((Element)tableElement));
        }
    }
}

