/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.client.directory;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.shop.client.TitleLabel;
import ru.bitel.bgbilling.plugins.shop.client.TreeCellRenderer;
import ru.bitel.bgbilling.plugins.shop.common.bean.ShopDirectoryItem;
import ru.bitel.bgbilling.plugins.shop.common.bean.ShopItemType;
import ru.bitel.bgbilling.plugins.shop.common.service.ShopService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class ShopTreePanel
extends BGUPanel {
    private JPanel propertiesPanel = null;
    private EditorPanel editorPanel = null;
    private JTree productTree = new JTree();
    private Map<Integer, ShopItemType> shopItemTypeMap = new HashMap<Integer, ShopItemType>();

    protected void jbInit() throws Exception {
        JScrollPane scrollPane = BGSwingUtilites.wrapScrollPane((JComponent)this.productTree, (int)500, (int)300);
        this.productTree.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.productTree.setCellRenderer(new TreeCellRenderer());
        this.productTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int locationRow = ShopTreePanel.this.productTree.getRowForLocation(e.getX(), e.getY());
                if (ShopTreePanel.this.productTree.isEnabled() && SwingUtilities.isRightMouseButton(e) && locationRow > -1 && ShopTreePanel.this.productTree.getRowForPath(ShopTreePanel.this.productTree.getSelectionPath()) == locationRow) {
                    ShopTreePanel.this.getPopupMenu().show(ShopTreePanel.this.productTree, e.getX(), e.getY());
                }
            }
        });
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)scrollPane, (Component)this.getPropertiesPanel(), 600L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    private JPopupMenu getPopupMenu() {
        TreePath treePath = this.productTree.getSelectionPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        ShopDirectoryItem selectedDirectoryItem = (ShopDirectoryItem)node.getUserObject();
        JPopupMenu popupMenu = new JPopupMenu();
        if (selectedDirectoryItem.isAllowSubDirectory()) {
            JMenuItem addDir = new JMenuItem("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0430\u043f\u043a\u0443");
            addDir.addActionListener(e -> {
                ShopDirectoryItem shopDirectoryItem = new ShopDirectoryItem();
                shopDirectoryItem.setId(-1);
                shopDirectoryItem.setParentId(selectedDirectoryItem.getId());
                new TreeNodeEditor("\u041d\u043e\u0432\u0430\u044f \u043f\u0430\u043f\u043a\u0430", shopDirectoryItem).open();
            });
            popupMenu.add(addDir);
        }
        if (selectedDirectoryItem.getId() > 0) {
            JMenuItem editDir = new JMenuItem("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0430\u043f\u043a\u0443");
            editDir.addActionListener(e -> {
                this.productTree.setEnabled(false);
                ((CardLayout)this.getPropertiesPanel().getLayout()).show(this.getPropertiesPanel(), "editor");
                this.editorPanel.setData(selectedDirectoryItem);
            });
            popupMenu.add(editDir);
        }
        if (!selectedDirectoryItem.getItemTypeIds().isEmpty()) {
            popupMenu.add(new JSeparator());
            JMenu productPositionMenu = new JMenu("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0442\u043e\u0432\u0430\u0440\u043d\u0443\u044e \u043f\u043e\u0437\u0438\u0446\u0438\u044e");
            List<Integer> needLoadIds = selectedDirectoryItem.getItemTypeIds().stream().filter(a -> !this.shopItemTypeMap.containsKey(a)).toList();
            if (needLoadIds != null && !needLoadIds.isEmpty()) {
                try {
                    ((ShopService)((ClientContext)this.getContext()).getWebService(ShopService.class)).shopItemTypeListByIds(needLoadIds).forEach(a -> this.shopItemTypeMap.put(a.getId(), (ShopItemType)a));
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            for (Integer itemTypeId : selectedDirectoryItem.getItemTypeIds()) {
                ShopItemType shopItemType = this.shopItemTypeMap.get(itemTypeId);
                if (shopItemType == null) continue;
                JMenuItem item = new JMenuItem(shopItemType.getTitle());
                productPositionMenu.add(item);
            }
            popupMenu.add(productPositionMenu);
        }
        return popupMenu;
    }

    private JPanel getPropertiesPanel() {
        if (this.propertiesPanel == null) {
            this.propertiesPanel = new JPanel(new CardLayout());
            this.propertiesPanel.add((Component)new JPanel(new GridBagLayout()), "empty");
            this.editorPanel = new EditorPanel();
            this.propertiesPanel.add((Component)this.editorPanel, "editor");
        }
        return this.propertiesPanel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            ShopDirectoryItem shopDirectoryItem = new ShopDirectoryItem();
            shopDirectoryItem.setId(0);
            shopDirectoryItem.setParentId(-1);
            shopDirectoryItem.setAllowSubDirectory(true);
            shopDirectoryItem.setTitle("\u041a\u0430\u0442\u0430\u043b\u043e\u0433 \u0442\u043e\u0432\u0430\u0440\u043e\u0432");
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(shopDirectoryItem);
            List shopDirectoryItems = ((ShopService)((ClientContext)this.getContext()).getWebService(ShopService.class)).shopDirectoryItemList();
            this.buildTreeData(root, shopDirectoryItems);
            ((DefaultTreeModel)this.productTree.getModel()).setRoot(root);
            this.shopItemTypeMap.clear();
        });
    }

    private void buildTreeData(DefaultMutableTreeNode treeNode, List<ShopDirectoryItem> shopDirectoryItems) {
        int parentId = ((ShopDirectoryItem)treeNode.getUserObject()).getId();
        for (ShopDirectoryItem shopDirectoryItem : shopDirectoryItems) {
            if (shopDirectoryItem.getParentId() != parentId) continue;
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(shopDirectoryItem);
            treeNode.add(childNode);
            this.buildTreeData(childNode, shopDirectoryItems);
        }
    }

    class EditorPanel
    extends JPanel {
        private ShopDirectoryItem shopDirectoryItem;
        private JTextField title;
        private BGUList<IdTitle> selectedTypes;
        private BGUList<IdTitle> availabledTypes;
        private FilterTableModel filterTableModel;
        private JCheckBox allowSubDirectory;
        private List<ShopItemType> shopItemTypes;
        AbstractBGUPanel.DefaultAction addFilter;
        AbstractBGUPanel.DefaultAction editFilter;
        AbstractBGUPanel.DefaultAction deleteFilter;

        public EditorPanel() {
            super(new GridBagLayout());
            this.title = new JTextField();
            this.selectedTypes = new BGUList();
            this.availabledTypes = new BGUList();
            this.filterTableModel = new FilterTableModel();
            this.allowSubDirectory = new JCheckBox("\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u044b \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0435 \u043f\u0430\u043f\u043a\u0438");
            this.addFilter = new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    new FilterEditor("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0444\u0438\u043b\u044c\u0442\u0440", "").getDialog().setVisible(true);
                }
            };
            this.editFilter = new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    new FilterEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0444\u0438\u043b\u044c\u0442\u0440", "").getDialog().setVisible(true);
                }
            };
            this.deleteFilter = new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                }
            };
            BGButtonPanel buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.SAVE, BGButtonPanel.CLOSE});
            buttonPanel.addActionListener(e -> {
                if (BGButtonPanel.SAVE.command.equals(e.getActionCommand())) {
                    try {
                        this.updateData();
                        ShopTreePanel.this.productTree.setEnabled(true);
                        ((CardLayout)ShopTreePanel.this.getPropertiesPanel().getLayout()).show(ShopTreePanel.this.getPropertiesPanel(), "empty");
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                } else if (BGButtonPanel.CLOSE.command.equals(e.getActionCommand())) {
                    ShopTreePanel.this.productTree.setEnabled(true);
                    ((CardLayout)ShopTreePanel.this.getPropertiesPanel().getLayout()).show(ShopTreePanel.this.getPropertiesPanel(), "empty");
                }
            });
            BGUTable filterTable = new BGUTable((TableModel)((Object)this.filterTableModel));
            filterTable.setSelectionMode(0);
            this.add((Component)new TitleLabel("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u043f\u043a\u0438", 1, 1.5f), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 20, 3, 3), 0, 0));
            this.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 15, 0, 3), 0, 0));
            this.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 10, 0, 3), 0, 0));
            this.add((Component)this.allowSubDirectory, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 0, 3), 0, 0));
            this.add((Component)new TitleLabel("\u0422\u0438\u043f\u044b \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432:", 1, 1.25f), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 3), 0, 0));
            this.add((Component)this.getSelectTypePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 10, 0, 3), 0, 0));
            this.add((Component)this.getFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 3), 0, 0));
            this.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)filterTable, (int)300, (int)300), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 10, 0, 3), 0, 0));
            this.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
            this.add((Component)buttonPanel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 15, 5, 3), 0, 0));
        }

        private JPanel getFilterPanel() {
            this.getActionMap().put("new", (Action)this.addFilter);
            this.getActionMap().put("edit", (Action)this.editFilter);
            this.getActionMap().put("delete", (Action)this.deleteFilter);
            BGDialogToolBar toolBar = new BGDialogToolBar();
            BGSwingUtilites.buildToolBar((BGDialogToolBar)toolBar, (JComponent)this);
            toolBar.setFloatable(false);
            toolBar.compact();
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new TitleLabel("\u0424\u0438\u043b\u044c\u0442\u0440\u044b \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432:", 1, 1.25f), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)toolBar, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
            return panel;
        }

        private void updateData() throws BGException {
            boolean update = this.shopDirectoryItem.getId() > 0;
            this.shopDirectoryItem.setTitle(this.title.getText());
            this.shopDirectoryItem.setAllowSubDirectory(this.allowSubDirectory.isSelected());
            try {
                this.shopDirectoryItem.setId(((ShopService)((ClientContext)ShopTreePanel.this.getContext()).getWebService(ShopService.class)).shopDirectoryItemUpdate(this.shopDirectoryItem));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return;
            }
            TreePath treePath = ShopTreePanel.this.productTree.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (update) {
                ((DefaultTreeModel)ShopTreePanel.this.productTree.getModel()).reload();
                ShopTreePanel.this.productTree.fireTreeExpanded(treePath);
                ShopTreePanel.this.productTree.setSelectionPath(treePath);
            } else {
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(this.shopDirectoryItem);
                node.add(newNode);
                treePath = new TreePath(((DefaultTreeModel)ShopTreePanel.this.productTree.getModel()).getPathToRoot(newNode));
                ((DefaultTreeModel)ShopTreePanel.this.productTree.getModel()).reload();
                ShopTreePanel.this.productTree.fireTreeExpanded(treePath);
                ShopTreePanel.this.productTree.setSelectionPath(treePath);
            }
        }

        public void setData(ShopDirectoryItem shopDirectoryItem) {
            Objects.requireNonNull(shopDirectoryItem);
            try {
                this.shopItemTypes = ((ShopService)((ClientContext)ShopTreePanel.this.getContext()).getWebService(ShopService.class)).shopItemTypeList();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.shopDirectoryItem = shopDirectoryItem;
            this.title.setText(shopDirectoryItem.getTitle());
            this.allowSubDirectory.setSelected(shopDirectoryItem.isAllowSubDirectory());
            this.setTypes();
        }

        private void setTypes() {
            this.selectedTypes.setData(this.shopItemTypes.stream().filter(a -> this.shopDirectoryItem.getItemTypeIds().contains(a.getId())).map(IdTitle::toIdTitle).toList());
            this.availabledTypes.setData(this.shopItemTypes.stream().filter(a -> !this.shopDirectoryItem.getItemTypeIds().contains(a.getId())).map(IdTitle::toIdTitle).toList());
        }

        private JPanel getSelectTypePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 3), 0, 0));
            panel.add((Component)new JLabel(" "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 3), 0, 0));
            panel.add((Component)new JLabel("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 3), 0, 0));
            panel.add((Component)BGSwingUtilites.wrapScrollPane(this.selectedTypes, (int)200, (int)200), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)this.getSelectButtonPanel(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 10, 0, 10), 0, 0));
            panel.add((Component)BGSwingUtilites.wrapScrollPane(this.availabledTypes, (int)200, (int)200), new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getSelectButtonPanel() {
            JButton addButton = new JButton("<<<");
            addButton.addActionListener(e -> {
                this.shopDirectoryItem.getItemTypeIds().addAll(this.availabledTypes.getSelectedValuesList().stream().map(a -> a.getId()).toList());
                this.setTypes();
            });
            JButton delButton = new JButton(">>>");
            delButton.addActionListener(e -> {
                this.shopDirectoryItem.getItemTypeIds().removeAll(this.selectedTypes.getSelectedValuesList().stream().map(a -> a.getId()).toList());
                this.setTypes();
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)addButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)delButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }
    }

    class TreeNodeEditor
    extends BGEditorDialog<ShopDirectoryItem> {
        private JTextField title;
        private JCheckBox allowSubDirectory;

        public TreeNodeEditor(String title, ShopDirectoryItem data) {
            super(title, (Object)data);
            this.title = new JTextField(30);
            this.allowSubDirectory = new JCheckBox("\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u044b \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0435 \u043f\u0430\u043f\u043a\u0438");
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.allowSubDirectory, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
            this.title.setText(((ShopDirectoryItem)this.data).getTitle());
            this.allowSubDirectory.setSelected(((ShopDirectoryItem)this.data).isAllowSubDirectory());
        }

        public boolean doApply() throws Exception {
            boolean update = ((ShopDirectoryItem)this.data).getId() > 0;
            ((ShopDirectoryItem)this.data).setTitle(this.title.getText());
            ((ShopDirectoryItem)this.data).setAllowSubDirectory(this.allowSubDirectory.isSelected());
            ((ShopDirectoryItem)this.data).setId(((ShopService)((ClientContext)ShopTreePanel.this.getContext()).getWebService(ShopService.class)).shopDirectoryItemUpdate((ShopDirectoryItem)this.data));
            TreePath treePath = ShopTreePanel.this.productTree.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (update) {
                ((DefaultTreeModel)ShopTreePanel.this.productTree.getModel()).reload();
                ShopTreePanel.this.productTree.fireTreeExpanded(treePath);
                ShopTreePanel.this.productTree.setSelectionPath(treePath);
            } else {
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(this.data);
                node.add(newNode);
                treePath = new TreePath(((DefaultTreeModel)ShopTreePanel.this.productTree.getModel()).getPathToRoot(newNode));
                ((DefaultTreeModel)ShopTreePanel.this.productTree.getModel()).reload();
                ShopTreePanel.this.productTree.fireTreeExpanded(treePath);
                ShopTreePanel.this.productTree.setSelectionPath(treePath);
            }
            return true;
        }
    }

    class FilterEditor
    extends BGEditorDialog<String> {
        private BGUComboBox<IdTitle> shopItemTypes;
        private BGUComboBox<IdTitle> typeProperties;
        private JButton filterValue;

        public FilterEditor(String title, String data) {
            super(title, (Object)data);
            this.shopItemTypes = new BGUComboBox();
            this.typeProperties = new BGUComboBox();
            this.filterValue = new JButton("\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e");
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u0422\u0438\u043f \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            this.panel.add((Component)this.shopItemTypes, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            this.panel.add((Component)this.typeProperties, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0424\u0438\u043b\u044c\u0442\u0440:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            this.panel.add((Component)this.filterValue, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
        }

        public boolean doApply() throws Exception {
            return true;
        }
    }

    class FilterTableModel
    extends BGTableModel<ShopDirectoryItem> {
        public FilterTableModel() {
            super(FilterTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u0422\u0438\u043f \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430", 100, 300, 400, "typeId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e", 100, 300, 400, "propertyName", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0424\u0438\u043b\u044c\u0442\u0440", 100, 100, -1, "filterValue", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }
}

