/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.contract;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.smarthouse.client.contract.AbstractBasePanel;
import ru.bitel.bgbilling.modules.smarthouse.client.contract.PackageContractTableModel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageBase;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageContract;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.RowData;
import ru.bitel.common.model.SearchResult;

public class PackageContractPanel
extends AbstractBasePanel<SmartHousePackageContract, PackageContractTableModel> {
    private PackageTextField packageTitle;
    private PackageTextField packagePeriod;
    private PackageTextField packageStatus;
    private PackageTextField packageCost;
    private PackageTextField packageCostDate;
    private int[] packageNavigationIds = new int[3];
    private SmartHousePackageContract packageContract = null;
    private JButton prevButton = new JButton(ClientUtils.getIcon((String)"arrow_left"));
    private JButton nextButton = new JButton(ClientUtils.getIcon((String)"arrow_right"));
    private PackageContractTableModel packageContractTableModel = null;
    private PackageOptionTableModel packageOptionTableModel = null;

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getPackageTitlePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 5, 0, 5), 0, 0));
        this.add(this.getPackageDataPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 5, 0, 5), 0, 0));
        this.add(this.getPackageInfoPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 5, 0, 5), 0, 0));
        this.add(this.getPackageHistoryPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(15, 0, 0, 0), 0, 0));
        this.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (PackageContractPanel.this.getPopupMenu() != null && SwingUtilities.isRightMouseButton(event) && PackageContractPanel.this.getTable().getSelectedRow() == PackageContractPanel.this.getTable().rowAtPoint(event.getPoint())) {
                    PackageContractPanel.this.getPopupMenu().show((Component)PackageContractPanel.this.getTable(), event.getX(), event.getY());
                }
            }
        });
    }

    private JPanel getPackageInfoPanel() {
        this.packageCost = new PackageTextField(15);
        this.packageCostDate = new PackageTextField(15);
        this.packageStatus = new PackageTextField(15);
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u0430\u043a\u0435\u0442\u0430:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.packageStatus, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u0430\u043a\u0435\u0442\u0430:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.packageCost, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)new JLabel(" \u043d\u0430 "), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.packageCostDate, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getPackageTitlePanel() {
        this.packageTitle = new PackageTextField(20);
        this.packagePeriod = new PackageTextField(30);
        this.prevButton.setToolTipText("\u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439");
        this.prevButton.addActionListener(e -> this.doPackageNavigation(this.packageNavigationIds[0]));
        this.nextButton.setToolTipText("\u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439");
        this.nextButton.addActionListener(e -> this.doPackageNavigation(this.packageNavigationIds[2]));
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.prevButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.nextButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041f\u0430\u043a\u0435\u0442:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.packageTitle, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.packagePeriod, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getPackageDataPanel() {
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getPackageOptionPanel(), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getPackageAccountingPeriodPanel(), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getPackageOptionPanel() {
        BGUTable table = new BGUTable((TableModel)((Object)this.getPackageOptionTableModel()));
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041e\u043f\u0446\u0438\u0438 \u043f\u0430\u043a\u0435\u0442\u0430:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getPackageAccountingPeriodPanel() {
        PackageAccountingPeriodTableModel packageAccountingPeriodTableModel = new PackageAccountingPeriodTableModel(PackageAccountingPeriodTableModel.class.getName());
        BGUTable table = new BGUTable((TableModel)((Object)packageAccountingPeriodTableModel));
        Dimension dimension = new Dimension(400, 200);
        JScrollPane scrollPane = new JScrollPane((Component)table);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0423\u0447\u0435\u0442\u043d\u044b\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u044b (\u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 10 \u0438\u0437 ?):"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.doPackageNavigation(this.packageContract == null ? 0 : this.packageContract.getId());
            SearchResult searchResult = this.getSmartHousePackageService().packageContractSearch(((ClientContext)this.getContext()).getContractId(), false, new String[]{"dateFrom:desc"}, this.getPages().getPage());
            this.getTableModel().setData(searchResult.getList());
            Page page = searchResult.getPage();
            this.recordCount.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger((int)page.getRecordCount()));
            this.getPages().setPage(page);
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new PackageDialog("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0430\u043a\u0435\u0442", new SmartHousePackageContract()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> Optional.ofNullable(this.packageContract).ifPresentOrElse(a -> new PackageDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0430\u043a\u0435\u0442", this.packageContract).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u0442 \u043f\u0430\u043a\u0435\u0442\u0430 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f")));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            if (this.packageContract != null && this.packageContract.getPeriod().getLocalDateFrom().isAfter(LocalDate.now()) && ClientUtils.confirm((String)"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0430\u043a\u0435\u0442?", (String)"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435")) {
                this.getSmartHousePackageService().packageContractDelete(((ClientContext)this.getContext()).getContractId(), this.packageContract.getId());
                this.doPackageNavigation(0);
            }
        });
        new AbstractBGUPanel.DefaultAction("showOptions", "\u0421\u043f\u0438\u0441\u043e\u043a \u043e\u043f\u0446\u0438\u0439"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                JTextArea textArea = new JTextArea(15, 50);
                textArea.setText(((SmartHousePackageContract)PackageContractPanel.this.packageContractTableModel.getSelectedRow()).getData());
                JPanel panel = new JPanel(new GridBagLayout());
                panel.add((Component)new JScrollPane(textArea), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), panel, "\u0421\u043f\u0438\u0441\u043e\u043a \u043e\u043f\u0446\u0438\u0439", -1);
            }
        };
    }

    private void doPackageNavigation(int packageContractId) {
        this.tryCall(() -> {
            this.packageNavigationIds = this.getSmartHousePackageService().packageContractNavigationIds(((ClientContext)this.getContext()).getContractId(), packageContractId);
            this.prevButton.setEnabled(this.packageNavigationIds[0] > 0);
            this.nextButton.setEnabled(this.packageNavigationIds[2] > 0);
            this.packageTitle.setText("");
            this.packageCost.setText("0.00");
            this.packageCostDate.setText(LocalDateTime.now().format(TimeUtils.getDateTimeFormatter((String)"dd.MM.yyyy HH:mm:ss")));
            this.packageStatus.setText("\u041d\u0415 \u0410\u041a\u0422\u0418\u0412\u041d\u042b\u0419");
            this.packagePeriod.setText("");
            this.getPackageOptionTableModel().deleteRows();
            this.packageContract = this.getSmartHousePackageService().packageContractGet(((ClientContext)this.getContext()).getContractId(), this.packageNavigationIds[1]);
            if (this.packageContract != null) {
                SmartHousePackageBase packageBase = this.getSmartHousePackageService().smartHousePackageBaseGet(this.packageContract.getPackageId());
                this.packageTitle.setText(packageBase == null ? "" : packageBase.getTitle());
                this.packageCost.setText(Utils.formatCostByGrouping((BigDecimal)this.packageContract.getPackageCost(), (int)3, (int)2));
                this.packageCostDate.setText((this.packageContract.getPackageCostDate() != null ? this.packageContract.getPackageCostDate() : LocalDate.now()).format(TimeUtils.getDateTimeFormatter((String)"dd.MM.yyyy")));
                this.packagePeriod.setText(this.packageContract.getPeriod().toString());
                if (TimeUtils.dateInPeriod((LocalDate)LocalDate.now(), (ru.bitel.common.model.Period)this.packageContract.getPeriod())) {
                    this.packageStatus.setText("\u0410\u041a\u0422\u0418\u0412\u041d\u042b\u0419");
                }
                JSONObject data = new JSONObject(this.packageContract.getData());
                for (String key : data.keySet()) {
                    JSONObject json = new JSONObject().put("optionName", (Object)key).put("optionCount", data.optInt(key));
                    this.getPackageOptionTableModel().addRow(new RowData(json));
                }
            }
        });
    }

    private PackageOptionTableModel getPackageOptionTableModel() {
        if (this.packageOptionTableModel == null) {
            this.packageOptionTableModel = new PackageOptionTableModel(PackageOptionTableModel.class.getName());
        }
        return this.packageOptionTableModel;
    }

    @Override
    protected PackageContractTableModel getTableModel() {
        if (this.packageContractTableModel == null) {
            this.packageContractTableModel = new PackageContractTableModel(PackageContractTableModel.class.getName(), this);
        }
        return this.packageContractTableModel;
    }

    @Override
    protected void getPopupMenuItems() {
        this.getPopupMenu().add(new JMenuItem(this.getActionMap().get("showOptions")));
    }

    private JPanel getPackageHistoryPanel() {
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)this.recordCount, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        filterPanel.add((Component)this.getPages(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder("\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0441\u043c\u0435\u043d\u044b \u043f\u0430\u043a\u0435\u0442\u043e\u0432:"));
        panel.add((Component)filterPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.getTable()), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    class PackageOptionTableModel
    extends BGTableModel<RowData> {
        public static final String OPTION_NAME = "optionName";
        public static final String OPTION_COUNT = "optionCount";

        public PackageOptionTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u043f\u0446\u0438\u0438", 100, 300, -1, OPTION_NAME, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", 100, 100, 100, OPTION_COUNT, true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", 200, 200, 200, "optionCost", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
        }

        public Object getValue(RowData rowData, int column) throws Exception {
            JSONObject json = rowData.getJson();
            String identifier = this.getIdentifier(column);
            if (OPTION_NAME.equals(identifier)) {
                return json.optString(OPTION_NAME);
            }
            if (OPTION_COUNT.equals(identifier)) {
                return json.optInt(OPTION_COUNT);
            }
            return super.getValue((Object)rowData, column);
        }
    }

    class PackageTextField
    extends JTextField {
        public PackageTextField(int column) {
            super(column);
            Font font = this.getFont();
            Color bgColor = this.getBackground();
            this.setEditable(false);
            this.setHorizontalAlignment(0);
            this.setBackground(bgColor);
            this.setFont(new Font(font.getFamily(), 1, font.getSize() + 2));
        }
    }

    class PackageAccountingPeriodTableModel
    extends BGTableModel<Period> {
        public PackageAccountingPeriodTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 200, 300, 400, "period", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043b-\u0432\u043e", 80, 80, 80, "count", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
        }
    }

    class PackageDialog
    extends BGEditorDialog<SmartHousePackageContract> {
        private List<IdTitle> basePackageItems;
        private BGUComboBox<IdTitle> basePackage;
        private BGControlPanelPeriodNoB period;

        public PackageDialog(String title, SmartHousePackageContract data) {
            super(title, (Object)data);
            this.basePackageItems = new ArrayList<IdTitle>();
            this.basePackage = new BGUComboBox();
            this.period = new BGControlPanelPeriodNoB();
        }

        public void doDialogPanel() {
            this.addFieldV("\u041f\u0430\u043a\u0435\u0442:", (JComponent)this.basePackage);
            this.addFieldV("\u041f\u0435\u0440\u0438\u043e\u0434:", (JComponent)this.period);
            this.basePackage.setMinimumSize(new Dimension(500, 10));
            this.basePackage.setPreferredSize(new Dimension(500, 10));
            PackageContractPanel.this.tryCall(() -> {
                PackageContractPanel.this.getSmartHousePackageService().packageBaseSearch(null, false, null, new Page()).getList().forEach(a -> this.basePackageItems.add(new IdTitle(a.getId(), a.getTitle())));
                this.basePackage.setData(this.basePackageItems);
            });
            this.basePackage.setSelectedItem((Object)new Id().setId(((SmartHousePackageContract)this.data).getPackageId()));
            this.period.setPeriod(((SmartHousePackageContract)this.data).getPeriod());
        }

        public boolean doApply() throws Exception {
            if (this.basePackage.getSelectedItem() == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u043a\u0435\u0442");
                return false;
            }
            ((SmartHousePackageContract)this.data).setContractId(((ClientContext)PackageContractPanel.this.getContext()).getContractId());
            ((SmartHousePackageContract)this.data).setPackageId(((IdTitle)this.basePackage.getSelectedItem()).getId());
            ((SmartHousePackageContract)this.data).setPeriod(this.period.getPeriod());
            try {
                PackageContractPanel.this.getSmartHousePackageService().packageContractUpdate((SmartHousePackageContract)this.data);
                PackageContractPanel.this.performAction("refresh");
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return false;
            }
            return true;
        }
    }
}

