/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.directory;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.EditorTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.smarthouse.client.common.BooleanEditor;
import ru.bitel.bgbilling.modules.smarthouse.client.common.EditorUtils;
import ru.bitel.bgbilling.modules.smarthouse.client.contract.AbstractBasePanel;
import ru.bitel.bgbilling.modules.smarthouse.client.directory.BaseOptionTableModel;
import ru.bitel.bgbilling.modules.smarthouse.client.directory.BasePackageTableModel;
import ru.bitel.bgbilling.modules.smarthouse.client.directory.PackageDurationPanel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageBase;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageOption;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.enums.SmartHouseTariffMode;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.RowData;
import ru.bitel.common.model.SearchResult;

public class SmartHousePackageBasePanel
extends AbstractBasePanel<SmartHousePackageBase, BasePackageTableModel> {
    private static final String EDIT_OPTION = "editOption";
    private BasePackageTableModel tableModel = null;

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(new JScrollPane((Component)this.getTable()), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            SearchResult searchResult = this.getSmartHousePackageService().packageBaseSearch(null, false, this.getTable().getSort(), this.getPages().getPage());
            this.getTableModel().setData(searchResult.getList());
            this.getPages().setPage(searchResult.getPage());
            this.recordCount.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger((int)searchResult.getPage().getRecordCount()));
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new PackageDialogEditor("\u041d\u043e\u0432\u044b\u0439 \u043f\u0430\u043a\u0435\u0442", new SmartHousePackageBase()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.getTableModel().optSelectedRow().ifPresentOrElse(a -> new PackageDialogEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u043a\u0435\u0442\u0430", (SmartHousePackageBase)a).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u043a\u0435\u0442 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f")));
        new AbstractBGUPanel.DefaultAction(EDIT_OPTION, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043e\u043f\u0446\u0438\u0439", ClientUtils.getIcon((String)"fugue/present")){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                SmartHousePackageBasePanel.this.getTableModel().optSelectedRow().ifPresentOrElse(a -> new OptionDialogEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043e\u043f\u0446\u0438\u0439", (SmartHousePackageBase)a).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u043a\u0435\u0442 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f"));
            }
        };
    }

    @Override
    protected void getPopupMenuItems() {
        Action action = this.getActionMap().get("edit");
        action.putValue("Name", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435");
        this.getPopupMenu().add(new JMenuItem(action));
        this.getPopupMenu().add(new JMenuItem(this.getActionMap().get(EDIT_OPTION)));
    }

    @Override
    protected BasePackageTableModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new BasePackageTableModel(BasePackageTableModel.class.getName());
        }
        return this.tableModel;
    }

    private JPanel getFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.recordCount, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.getPages(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 0, 0), 0, 0));
        return panel;
    }

    class PackageDialogEditor
    extends BGEditorDialog<SmartHousePackageBase> {
        private EditorTextField title;
        private EditorTextField comment;
        private PackageDurationPanel duration;
        private BGControlPanelPeriodNoB period;
        private JTabbedPane tariffMode;
        private BGUComboBox<IdTitle> npayModule;
        private BGUComboBox<IdTitle> npayService;
        private List<IdTitle> npayModuleItems;
        private List<IdTitle> npayServiceItems;

        public PackageDialogEditor(String title, SmartHousePackageBase data) {
            super(title, (Object)data);
            this.title = new EditorTextField(50, "", SmartHousePackageBasePanel.this.focusListener);
            this.comment = new EditorTextField(50, "", SmartHousePackageBasePanel.this.focusListener);
            this.duration = new PackageDurationPanel();
            this.period = new BGControlPanelPeriodNoB(false);
            this.tariffMode = new JTabbedPane();
            this.npayModule = new BGUComboBox();
            this.npayService = new BGUComboBox();
        }

        public void doDialogPanel() {
            this.tariffMode.add("NPAY", this.getNpayTariffPanel());
            this.tariffMode.add("SMARTHOUSE", this.getSmarhouseTariffPanel());
            this.addFieldV("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:", (JComponent)this.title);
            this.addFieldV("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:", (JComponent)this.comment);
            this.addFieldV("\u041f\u0435\u0440\u0438\u043e\u0434:", (JComponent)this.period);
            this.addFieldV("\u0420\u0435\u0436\u0438\u043c \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438:", this.tariffMode);
            this.title.setText(((SmartHousePackageBase)this.data).getTitle());
            this.comment.setText(((SmartHousePackageBase)this.data).getComment());
            this.period.setPeriod(((SmartHousePackageBase)this.data).getPeriod());
            this.tariffMode.setSelectedIndex(((SmartHousePackageBase)this.data).getTariffMode() == SmartHouseTariffMode.NPAY ? 0 : 1);
            this.npayModule.setSelectedItem((Object)new Id().setId(((SmartHousePackageBase)this.data).getNpayModuleId()));
            this.npayService.setSelectedItem((Object)new Id().setId(((SmartHousePackageBase)this.data).getNpayServiceId()));
            this.duration.getValue().setText(String.valueOf(((SmartHousePackageBase)this.data).getDurationValue()));
            int unitCode = ((SmartHousePackageBase)this.data).getDurationUnitCode();
            int itemCount = this.duration.getUnit().getItemCount();
            for (int index = 0; index < itemCount; ++index) {
                if (((IdTitle)this.duration.getUnit().getItemAt(index)).getId() != unitCode) continue;
                this.duration.getUnit().setSelectedIndex(index);
                break;
            }
        }

        private JPanel getNpayTariffPanel() {
            this.npayModuleItems = new ArrayList<IdTitle>();
            this.npayModuleItems.add(IdTitle.NO_SELECT);
            SmartHousePackageBasePanel.this.tryCall(() -> this.npayModuleItems.addAll(SmartHousePackageBasePanel.this.getSmartHousePackageService().npayModules()));
            this.npayModule.setData(this.npayModuleItems);
            this.npayModule.addItemListener(SmartHousePackageBasePanel.this.comboBoxSelect(e -> this.setNpayServiceItems()));
            this.setNpayServiceItems();
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
            this.addFieldV("\u041c\u043e\u0434\u0443\u043b\u044c \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442:", (JComponent)this.npayModule, panel);
            this.addFieldV("\u0423\u0441\u043b\u0443\u0433\u0430:", (JComponent)this.npayService, panel);
            return panel;
        }

        private void setNpayServiceItems() {
            int moduleId = ((IdTitle)this.npayModule.getSelectedItem()).getId();
            this.npayServiceItems = new ArrayList<IdTitle>();
            this.npayServiceItems.add(IdTitle.NO_SELECT);
            if (moduleId > 0) {
                SmartHousePackageBasePanel.this.tryCall(() -> this.npayServiceItems.addAll(SmartHousePackageBasePanel.this.getSmartHousePackageService().npayServices(moduleId)));
            }
            this.npayService.setData(this.npayServiceItems);
        }

        private JPanel getSmarhouseTariffPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.addFieldV("\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c:", this.duration, panel);
            panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        public boolean doApply() throws Exception {
            Color color = Color.YELLOW;
            boolean error = EditorUtils.checkTextField(this.title, color, false);
            if (error) {
                ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043b\u0435\u0439.");
                return false;
            }
            SmartHousePackageBase packageBase = SmartHousePackageBase.builder().setId(((SmartHousePackageBase)this.data).getId()).setTitle(this.title.getText()).setComment(this.comment.getText()).setPeriod(this.period.getPeriod()).build();
            if (this.tariffMode.getSelectedIndex() == 0) {
                if (((IdTitle)this.npayModule.getSelectedItem()).getId() < 1) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043c\u043e\u0434\u0443\u043b\u044c \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442");
                    return false;
                }
                if (((IdTitle)this.npayService.getSelectedItem()).getId() < 1) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443 \u043c\u043e\u0434\u0443\u043b\u044f \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442");
                    return false;
                }
                packageBase.setTariffMode(SmartHouseTariffMode.NPAY).setNpayModuleId(((IdTitle)this.npayModule.getSelectedItem()).getId()).setNpayServiceId(((IdTitle)this.npayService.getSelectedItem()).getId()).setDurationUnitCode(0).setDurationValue(0);
            } else {
                packageBase.setTariffMode(SmartHouseTariffMode.SMARTHOUSE).setNpayModuleId(0).setNpayServiceId(0).setDurationValue(Utils.parseInt((String)this.duration.getValue().getText(), (int)1)).setDurationUnitCode(((IdTitle)this.duration.getUnit().getSelectedItem()).getId());
            }
            return SmartHousePackageBasePanel.this.tryCallBoolean(() -> {
                SmartHousePackageBasePanel.this.getSmartHousePackageService().smartHousePackageBaseUpdate(packageBase);
                SmartHousePackageBasePanel.this.performAction("refresh");
            });
        }
    }

    class OptionDialogEditor
    extends BGEditorDialog<SmartHousePackageBase> {
        private List<RowData> list;

        public OptionDialogEditor(String title, SmartHousePackageBase data) {
            super(title, (Object)data);
            this.list = new ArrayList<RowData>();
        }

        public void doDialogPanel() {
            BaseOptionTableModel baseOptionTableModel = new BaseOptionTableModel();
            BGUTable optionTable = new BGUTable((TableModel)((Object)baseOptionTableModel)){

                public TableCellEditor getCellEditor(int row, int column) {
                    return new BooleanEditor();
                }
            };
            optionTable.setContext((ClientContext)SmartHousePackageBasePanel.this.getContext());
            optionTable.setSelectionMode(0);
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)optionTable, (int)600, (int)250), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            try {
                JSONArray optionNames = new JSONArray(((SmartHousePackageBase)this.data).getOptionNames());
                for (SmartHousePackageOption packageOption : SmartHousePackageBasePanel.this.getSmartHousePackageService().packageOptionList()) {
                    boolean selected = false;
                    for (int index = 0; index < optionNames.length(); ++index) {
                        if (!packageOption.getName().equals(optionNames.getString(index))) continue;
                        selected = true;
                        break;
                    }
                    this.list.add(new RowData(new JSONObject().put("name", (Object)packageOption.getName()).put("title", (Object)packageOption.getTitle()).put("selected", selected)));
                }
                baseOptionTableModel.setData(this.list);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        public boolean doApply() throws Exception {
            try {
                JSONArray jsonArray = new JSONArray();
                for (RowData rowData : this.list) {
                    if (!rowData.getJson().optBoolean("selected")) continue;
                    jsonArray.put(rowData.getJson().get("name"));
                }
                ((SmartHousePackageBase)this.data).setOptionNames(jsonArray.toString());
                SmartHousePackageBasePanel.this.getSmartHousePackageService().packageBaseOptionUpdate(((SmartHousePackageBase)this.data).getId(), ((SmartHousePackageBase)this.data).getOptionNames());
                SmartHousePackageBasePanel.this.performAction("refresh");
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return false;
            }
            return true;
        }
    }
}

